/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.search;

import com.sap.ip.me.mdk.search.FileDocument;
import java.io.File;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;

class IndexFiles {
    IndexFiles() {
    }

    public static void main(String[] args) {
        try {
            Date start = new Date();
            IndexWriter writer = new IndexWriter("index", (Analyzer)new StandardAnalyzer(), true);
            IndexFiles.indexDocs(writer, new File(args[0]));
            writer.optimize();
            writer.close();
            Date end = new Date();
            System.out.print(end.getTime() - start.getTime());
            System.out.println(" total milliseconds");
        }
        catch (Exception e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    public static void indexDocs(IndexWriter writer, File file) throws Exception {
        if (file.isDirectory()) {
            String[] files = file.list();
            int i = 0;
            while (i < files.length) {
                IndexFiles.indexDocs(writer, new File(file, files[i]));
                ++i;
            }
        } else {
            System.out.println("adding " + file);
            writer.addDocument(FileDocument.Document(file));
        }
    }
}

