/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.search;

import com.sap.ip.me.mdk.search.html.parser.HTMLParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class HTMLDocument {
    static char dirSep = System.getProperty("file.separator").charAt(0);

    public static String uid(File f) {
        return f.getPath().replace(dirSep, '\u0000') + "\u0000" + DateField.timeToString((long)f.lastModified());
    }

    public static String uid2url(String uid) {
        String url = uid.replace('\u0000', '/');
        return url.substring(0, url.lastIndexOf(47));
    }

    public static Document Document(File f) throws IOException, InterruptedException {
        Document doc = new Document();
        doc.add(Field.UnIndexed((String)"url", (String)f.getPath().replace(dirSep, '/')));
        doc.add(Field.Keyword((String)"modified", (String)DateField.timeToString((long)f.lastModified())));
        doc.add(new Field("uid", HTMLDocument.uid(f), false, true, false));
        HTMLParser parser = new HTMLParser(f);
        doc.add(Field.Text((String)"contents", (Reader)parser.getReader()));
        doc.add(Field.UnIndexed((String)"summary", (String)parser.getSummary()));
        doc.add(Field.Text((String)"title", (String)parser.getTitle()));
        return doc;
    }

    private HTMLDocument() {
    }
}

