/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.warProjectSettings;

import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.IPropertySystem;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.warProjectSettings.WarProjectBasicSettings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class WarProjectBasicSettingsPage
extends WizardPage {
    public static final String THIS_PROP_GROUP = "com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar";
    private boolean saveBeforePackaging;
    private boolean startTomcatDebug;
    private boolean resourcesInJar;
    private boolean classesInJar;
    private boolean warUppercase;
    private boolean useMEClassloader;
    private boolean mdkProject;
    private boolean startME;
    private String parArchivFileName;
    private boolean status;
    private String[] quickstartPossibilities = new String[0];
    private IProject selectedProject;
    private Button saveBeforePackagingButton;
    private Button debugButton;
    private Button includeResInJarButton;
    private Button includeClassesInJarButton;
    private Button warInUppercase;
    private Button mdkProjectButton;
    private Button startMEHomepage;
    private Button useMEClassloaderButton;
    private StringFieldEditor urlPattern;
    private FieldEditor passwordTextField;
    private String urlPreference;

    public WarProjectBasicSettingsPage(String arg0) {
        super(arg0);
    }

    public void createControl(Composite composite) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(composite, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        this.selectedProject = ((WarProjectBasicSettings)this.getWizard()).getSelectedProject();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        GridData layoutData = new GridData(768);
        this.urlPattern = new StringFieldEditor("urlPreferenceField", "URL pattern to start application", container);
        this.warInUppercase = new Button(container, 32);
        this.warInUppercase.setText("&Uppercase for MI archive name");
        this.warInUppercase.setToolTipText("Use uppercase characaters for MI archive (.war/.jar) file to avoid naming clashes with backend");
        layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        this.warInUppercase.setLayoutData((Object)layoutData);
        this.includeResInJarButton = new Button(container, 32);
        this.includeResInJarButton.setText("&Include resource bundles in the 'application'.jar file");
        this.includeResInJarButton.setToolTipText("Include the resource bundles in the /WEB-INF/lib/application.jar file instead of the .class folder");
        layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        this.mdkProjectButton = new Button(container, 32);
        this.mdkProjectButton.setText("&MDK project created without the plug-in");
        this.mdkProjectButton.setToolTipText("When this checkbox is activated the project is recognized as MDK project");
        layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        this.includeClassesInJarButton = new Button(container, 32);
        this.includeClassesInJarButton.setText("&Package .class files in the 'application'.jar file");
        this.includeClassesInJarButton.setToolTipText("The .class files are packaged in the /WEB-INF/lib/application.jar file instead of having single files in the .class folder");
        layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        this.startMEHomepage = new Button(container, 32);
        this.startMEHomepage.setText("&Start MI Homepage when browser is launched");
        this.startMEHomepage.setToolTipText("Starts MI Homepage instead of application directly");
        layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        int i = 0;
        while (i < 5) {
            Text blankText = new Text(container, 1);
            blankText.setText(" ");
            blankText.setBackground(container.getBackground());
            ++i;
        }
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ip.me.mdk.developmentTools.help-createWAR");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.selectedProject = ((WarProjectBasicSettings)this.getWizard()).getSelectedProject();
            try {
                IDESettings is = IDESettings.getInstance();
                IPropertySystem propSystem = OpentoolsFactory.getPropertySystemInstance();
                String tempString = null;
                tempString = propSystem.loadProperty(THIS_PROP_GROUP, "resourcesInJarFile", this.selectedProject);
                this.resourcesInJar = tempString == null ? false : Boolean.valueOf(tempString);
                tempString = propSystem.loadProperty(THIS_PROP_GROUP, "classesInJarFile", this.selectedProject);
                this.classesInJar = tempString == null ? true : Boolean.valueOf(tempString);
                tempString = propSystem.loadProperty(THIS_PROP_GROUP, "isMDKProject", this.selectedProject);
                this.mdkProject = tempString == null ? false : Boolean.valueOf(tempString);
                tempString = propSystem.loadProperty(THIS_PROP_GROUP, "startMEHomepage", this.selectedProject);
                this.startME = tempString == null ? false : Boolean.valueOf(tempString);
                this.urlPreference = propSystem.loadProperty(THIS_PROP_GROUP, "urlPattern", this.selectedProject);
                if (this.urlPreference == null) {
                    this.urlPreference = "/start";
                }
                this.warUppercase = (tempString = propSystem.loadProperty(THIS_PROP_GROUP, "warFileInUppercase", this.selectedProject)) == null ? true : Boolean.valueOf(tempString);
            }
            catch (Exception e) {
                this.status = false;
            }
            if (this.selectedProject != null) {
                try {
                    if (this.selectedProject.getNature(MIPlugin.getMINatureID()) == null) {
                        this.mdkProjectButton.setText("&MDK project created without the plug-in");
                        this.mdkProjectButton.setSelection(this.mdkProject);
                        this.mdkProjectButton.setEnabled(true);
                    } else {
                        this.mdkProjectButton.setText("&MDK project created with plug-in");
                        this.mdkProjectButton.setSelection(true);
                        this.mdkProjectButton.setEnabled(false);
                    }
                    this.urlPattern.setStringValue(this.urlPreference);
                    this.warInUppercase.setSelection(this.warUppercase);
                    this.includeResInJarButton.setSelection(this.resourcesInJar);
                    this.includeClassesInJarButton.setSelection(this.classesInJar);
                    this.startMEHomepage.setSelection(this.startME);
                }
                catch (CoreException e) {
                    this.status = false;
                }
            } else {
                this.mdkProjectButton.setSelection(true);
            }
        }
        super.setVisible(visible);
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    public void setSelectedProject(IProject project) {
        this.selectedProject = project;
    }

    public boolean isWarUppercase() {
        return this.warInUppercase.getSelection();
    }

    public boolean isIncludeResourcesInJarFile() {
        return this.includeResInJarButton.getSelection();
    }

    public boolean isIncludeClassesInJarFile() {
        return this.includeClassesInJarButton.getSelection();
    }

    public boolean isMdkProject() {
        return this.mdkProjectButton.getSelection();
    }

    public boolean isStartME() {
        return this.startMEHomepage.getSelection();
    }

    public String getUrlPattern() {
        return this.urlPattern.getStringValue();
    }
}

