/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.warProjectSettings;

import com.sap.ip.me.mdk.developmentTools.general.api.EP;
import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.IPropertySystem;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.api.StringBasedFileFilter;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapmakewar.SAPMPWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.selectProject.SelectAProjectWizardPage;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.warProjectSettings.WarProjectBasicSettingsPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class WarProjectBasicSettings
extends Wizard
implements IExportWizard,
SAPMPWizardStringLiterals {
    private boolean status;
    private String statusType;
    private String statusMessage;
    WarProjectBasicSettingsPage myPage;
    SelectAProjectWizardPage selectPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            Shell parentGUIThing = this.getShell();
            MDKInstallation mdk = MDKInstallation.getInstance();
            if (!mdk.isConfiguredOnce()) {
                OpentoolsFactory.getGuiSystem().invokeConfigurationWizard(parentGUIThing);
            }
            if (mdk.isConfiguredOnce()) {
                this.setNeedsProgressMonitor(true);
                this.myPage = new WarProjectBasicSettingsPage("Project Settings");
                this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Configuration Error", (String)"Error during MDK Plugin installation");
        }
    }

    public boolean performFinish() {
        Cursor c = new Cursor((Device)this.getShell().getDisplay(), 1);
        this.getShell().setCursor(c);
        this.status = true;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IProject selectedProject = WarProjectBasicSettings.this.getSelectedProject();
                IDE ideInstance = OpentoolsFactory.getIDEInstance();
                IDESettings is = null;
                try {
                    is = IDESettings.getInstance();
                    IPropertySystem propSyst = OpentoolsFactory.getPropertySystemInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    WarProjectBasicSettings.this.status = false;
                    WarProjectBasicSettings.this.statusType = e.getClass().getName();
                    WarProjectBasicSettings.this.statusMessage = e.getMessage();
                }
                WarProjectBasicSettings.this.performOk(monitor, selectedProject, is);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status = false;
            this.statusType = e.getClass().getName();
            this.statusMessage = e.getMessage();
        }
        if (!this.status) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.statusType, (String)this.statusMessage);
        }
        c.dispose();
        c = new Cursor((Device)this.getShell().getDisplay(), 0);
        this.getShell().setCursor(c);
        return true;
    }

    public boolean performOk(IProgressMonitor monitor, IProject selectedProject, IDESettings is) {
        this.status = true;
        MDKInstallation mdk = null;
        try {
            mdk = MDKInstallation.getInstance();
            EP ep = OpentoolsFactory.getEPInstance();
            List coreClassPath = mdk.getListofJars(ep.isJSPProject(selectedProject));
            coreClassPath.add(MIPlugin.getEclipseFolder() + File.separator + mdk.getMDKApiRelativeFileName());
            if (ep.isJSPProject(selectedProject)) {
                coreClassPath.add(is.getToolsjar());
            }
            StringBasedFileFilter recFilter = new StringBasedFileFilter(){

                public boolean accept(String[] segments, boolean isDir) {
                    if (segments[0].equals("app-root")) {
                        if (segments.length == 1) {
                            return true;
                        }
                        if (segments.length == 2) {
                            if (segments[1].equals("WEB-INF")) {
                                return true;
                            }
                        } else {
                            return segments[2].equals("lib");
                        }
                    }
                    return false;
                }
            };
            StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

                public boolean accept(String[] segments, boolean isDir) {
                    if (segments.length < 4) {
                        return false;
                    }
                    return segments[0].equals("app-root") && segments[1].equals("WEB-INF") && segments[2].equals("lib") && segments[3].endsWith(".jar");
                }
            };
            List libJarFiles = OpentoolsFactory.getIDEInstance().getAllFilesInProject(selectedProject, acceptFilter, recFilter);
            Iterator it = libJarFiles.iterator();
            while (it.hasNext()) {
                String[] segments = (String[])it.next();
                coreClassPath.add(OpentoolsFactory.getIDEInstance().getFileObjectFor(selectedProject, segments));
            }
            OpentoolsFactory.getIDEInstance().adjustProjectClassPathTo(selectedProject, coreClassPath, "core", true);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        boolean resourcesInJar = this.myPage.isIncludeResourcesInJarFile();
        boolean classesInJar = this.myPage.isIncludeClassesInJarFile();
        boolean warUppercase = this.myPage.isWarUppercase();
        boolean mdkProject = this.myPage.isMdkProject();
        boolean startME = this.myPage.isStartME();
        String urlPattern = this.myPage.getUrlPattern();
        try {
            IPropertySystem propSyst = OpentoolsFactory.getPropertySystemInstance();
            propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "classesInJarFile", String.valueOf(classesInJar), selectedProject);
            propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "resourcesInJarFile", String.valueOf(resourcesInJar), selectedProject);
            propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "isMDKProject", String.valueOf(mdkProject), selectedProject);
            propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "startMEHomepage", String.valueOf(startME), selectedProject);
            propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "warFileInUppercase", String.valueOf(warUppercase), selectedProject);
            propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "urlPattern", urlPattern, selectedProject);
        }
        catch (Exception e) {
            this.status = false;
        }
        return true;
    }

    public IProject getSelectedProject() {
        return this.selectPage.getSelectedProject();
    }

    public String getWindowTitle() {
        return "MDK: Create a MI Archive File";
    }

    public void addPages() {
        super.addPages();
        this.selectPage = new SelectAProjectWizardPage("Select project first", "Select a project first", null);
        this.addPage((IWizardPage)this.selectPage);
        if (this.myPage == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Configuration Error", (String)"Please configure the MDK Plugin.");
        } else {
            this.addPage((IWizardPage)this.myPage);
        }
    }
}

