/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapnewproject;

import com.sap.ip.me.mdk.developmentTools.general.api.IGUI;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapnewproject.ISAPNPWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapnewproject.SAPNPWizardPage;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class SAPNSPWizard
extends Wizard
implements INewWizard,
ISAPNPWizardStringLiterals {
    private SAPNPWizardPage wpage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.wpage = new SAPNPWizardPage(true);
        this.setWindowTitle("MDK: New Mobile Application Service Project");
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wpage);
    }

    public boolean performFinish() {
        try {
            Shell parentGUIThing = this.getShell();
            boolean success = true;
            IGUI guiSystem = OpentoolsFactory.getGuiSystem();
            try {
                IDESettings iset = IDESettings.getInstance();
                iset.setProjectRootRootFolder(this.wpage.getProjectRootRootFolderName());
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
                guiSystem.showErrorMessage("Error", "An error occurred writing the project settings", e, parentGUIThing);
            }
            File f = new File(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName());
            if (f.exists()) {
                String errorMessage = "Folder " + this.wpage.getProjectName() + " already exists as subfolder of " + this.wpage.getProjectRootRootFolderName() + "." + "\nPlease specifiy a different project name or root folder.";
                System.out.println(errorMessage);
                guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + f.getAbsolutePath()), parentGUIThing);
                success = false;
            }
            if (success) {
                try {
                    IProject project = (IProject)OpentoolsFactory.getEPInstance().createNewAWTProject(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName());
                }
                catch (Exception fnfex) {
                    fnfex.printStackTrace();
                    guiSystem.showErrorMessage("Error", "An error has occured while trying to create the project structure", fnfex, parentGUIThing);
                }
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return true;
    }
}

