/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapnewproject;

import com.sap.ip.me.mdk.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.ModifyListenerDelegator;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapnewproject.ISAPNPWizardPage;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapnewproject.ISAPNPWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapnewproject.SAPNewProjectWizardTemplate;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.util.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class SAPNPWizardPage
extends WizardPage
implements ISAPNPWizardStringLiterals,
ISAPNPWizardPage,
ModifyListener {
    private LabeledTextField projectNameField;
    private LabeledTextField classNameField;
    private LabeledTextField constantsFileNameField;
    private LabeledTextField packageNameField;
    private LabeledTextField jspNameField;
    private LabeledTextField beanNameField;
    private LabeledTextField meAppNameField;
    private LabeledBrowsableTextField projectRootFolderField;
    private List allProjectNames = new ArrayList();
    private Button codeGeneration;
    String projectRootRootFolderName = "";
    private boolean configurationChecked = false;
    private boolean isServiceProject;
    private Group projectTypeGroup;
    private Button radioSelectJSP;
    private Button radioSelectAWT;

    protected SAPNPWizardPage(boolean isServiceProject) {
        super("New MI project");
        this.isServiceProject = isServiceProject;
        try {
            IWorkspaceRoot root = MIPlugin.getWorkspace().getRoot();
            IResource[] members = root.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member instanceof IProject) {
                    this.allProjectNames.add(member.getName());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        IDESettings iset = IDESettings.getInstance();
        this.setTitle("New Mobile Application Project");
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite container = sappoEclipseStylePanel.getContentPane();
        container.setLayout((Layout)new GridLayout(1, false));
        this.projectNameField = new LabeledTextField(container, 0, "Project &name:");
        this.projectNameField.setToolTipText("The name of the new project");
        this.projectNameField.setValue("NewMIProject");
        this.projectRootFolderField = new LabeledBrowsableTextField(container, 0, "Project &root folder:");
        this.projectRootFolderField.setValue(this.getProjectRootRootFolderName());
        this.projectRootFolderField.setFileSelectionMode(1);
        this.projectTypeGroup = new Group(container, 16);
        this.projectTypeGroup.setLayout((Layout)new GridLayout());
        this.projectTypeGroup.setLayoutData((Object)new GridData(768));
        this.projectTypeGroup.setText("Project Type");
        this.radioSelectJSP = new Button((Composite)this.projectTypeGroup, 16);
        this.radioSelectJSP.setText("&JSP Project. Creates the 'java' source folder and the 'app-root' folder");
        this.radioSelectJSP.setSelection(true);
        this.radioSelectJSP.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SAPNPWizardPage.this.setOptions();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.radioSelectAWT = new Button((Composite)this.projectTypeGroup, 16);
        this.radioSelectAWT.setText("&AWT Project. Creates the 'java' source folder");
        this.radioSelectAWT.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SAPNPWizardPage.this.setOptions();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.codeGeneration = new Button(container, 32);
        this.codeGeneration.setSelection(true);
        this.codeGeneration.setText("&Generate main classes of application");
        this.codeGeneration.setToolTipText("Generates basic servlet and AWT classes as termplates for development");
        GridData layoutData = new GridData(8);
        layoutData.grabExcessHorizontalSpace = true;
        this.codeGeneration.setLayoutData((Object)layoutData);
        this.codeGeneration.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SAPNPWizardPage.this.setOptions();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.packageNameField = new LabeledTextField(container, 0, "Package name:");
        this.packageNameField.setToolTipText("The name of the main class of the new project");
        this.packageNameField.setValue(iset.getNewProjectPackageName());
        this.classNameField = new LabeledTextField(container, 0, "Servlet name:");
        this.classNameField.setToolTipText("The name of the main class of the new project");
        this.classNameField.setValue(iset.getNewProjectClassName());
        this.meAppNameField = new LabeledTextField(container, 0, "MI application name:");
        this.meAppNameField.setToolTipText("The name of the main class of the new project");
        this.meAppNameField.setValue(iset.getNewProjectMEAppName());
        this.constantsFileNameField = new LabeledTextField(container, 0, "Constants file name:");
        this.constantsFileNameField.setToolTipText("Interface that contains constants for your application");
        this.constantsFileNameField.setValue(iset.getNewProjectConstantsFileName());
        this.beanNameField = new LabeledTextField(container, 0, "Name for bean:");
        this.beanNameField.setToolTipText("The name of the bean that is used to transfer data from servlet to JSP");
        this.beanNameField.setValue(iset.getNewProjectBeanName());
        this.jspNameField = new LabeledTextField(container, 0, "JSP name:");
        this.jspNameField.setToolTipText("Name of the initial JSP that is called by the servlet. A full qualified name (incl. folder name) can be specified");
        this.jspNameField.setValue(iset.getNewProjectJSPFileName());
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.projectNameField);
        labelGroup.add(this.projectRootFolderField);
        labelGroup.add(this.packageNameField);
        labelGroup.add(this.classNameField);
        labelGroup.add(this.meAppNameField);
        labelGroup.add(this.constantsFileNameField);
        labelGroup.add(this.beanNameField);
        labelGroup.add(this.jspNameField);
        labelGroup.alignTextFields();
        ModifyListenerDelegator validator = new ModifyListenerDelegator(this);
        this.projectNameField.getTextField().addModifyListener((ModifyListener)validator);
        this.projectRootFolderField.getTextField().addModifyListener((ModifyListener)validator);
        this.jspNameField.getTextField().addModifyListener((ModifyListener)validator);
        this.constantsFileNameField.getTextField().addModifyListener((ModifyListener)validator);
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ip.me.mdk.developmentTools.help-createMEProject");
    }

    protected void setOptions() {
        boolean vis1 = false;
        boolean vis2 = true;
        if (this.radioSelectJSP.getSelection()) {
            vis1 = true;
        }
        if (!this.codeGeneration.getSelection()) {
            vis1 = false;
            vis2 = false;
        }
        this.packageNameField.setVisible(vis2);
        this.classNameField.setVisible(vis2);
        this.beanNameField.setVisible(vis2);
        this.meAppNameField.setVisible(vis2);
        this.constantsFileNameField.setVisible(vis2);
        this.beanNameField.setVisible(vis1);
        this.jspNameField.setVisible(vis1);
    }

    public void setVisible(boolean visible) {
        if (!this.configurationChecked && !SAPNewProjectWizardTemplate.initializeWizardPage(this.getContainer().getShell(), this)) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"Error", (String)"Could not connect to MDK.\n\nPlease ensure that the MDK settings are correct and that the connection to the MDK is working.\n(You can change the settings in 'Window/Preferences')");
            this.getContainer().getShell().close();
        }
        this.configurationChecked = true;
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
            Text textField = this.projectNameField.getTextField();
            textField.setSelection(0, textField.getText().length());
        }
    }

    public void modifyText(ModifyEvent e) {
        String projectName = this.getProjectName();
        if (projectName == null || projectName.trim().equals("")) {
            this.setErrorMessage("Please specify a project name.");
            return;
        }
        if (this.allProjectNames.contains(projectName)) {
            this.setErrorMessage("Project name " + projectName + " already exists in this workspace.");
            return;
        }
        String rootFolder = this.getProjectRootRootFolderName();
        File rootFolderFile = new File(rootFolder);
        if (rootFolderFile.exists() && rootFolderFile.isFile()) {
            this.setErrorMessage("Root folder " + rootFolder + " is a file, not a directory.");
            return;
        }
        File projectFolderFile = new File(rootFolderFile, projectName);
        String absolutePath = projectFolderFile.getAbsolutePath();
        if (!Files.isValidFileName(absolutePath)) {
            this.setErrorMessage(absolutePath + " is not a valid file name.");
            return;
        }
        String con = this.getNewProjectConstantsFileName();
        if (!Files.isValidFileName(con)) {
            this.setErrorMessage(con + " is not a valid file name.");
            return;
        }
        String jsp = this.getNewProjectJSPFileName();
        if (!Files.isValidFileName(jsp)) {
            this.setErrorMessage(jsp + " is not a valid file name.");
            return;
        }
        if (projectFolderFile.exists()) {
            this.setErrorMessage("File/Folder " + projectFolderFile + " already exists.");
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String s) {
        super.setErrorMessage(s);
        this.setPageComplete(s == null);
    }

    public String getProjectName() {
        return this.projectNameField.getValue();
    }

    public void setProjectRootRootFolderName(String name) {
        if (this.projectRootFolderField != null) {
            this.projectRootFolderField.setValue(name);
        }
        this.projectRootRootFolderName = name;
    }

    public String getProjectRootRootFolderName() {
        String temp = this.projectRootFolderField.getValue();
        if (temp.length() < 1) {
            temp = IDESettings.DEFAULT_PROJECT_ROOT_ROOT_FOLDER;
        }
        return temp;
    }

    public boolean getRadioSelectJSP() {
        return this.radioSelectJSP.getSelection();
    }

    public boolean getCodeGenerationSelection() {
        return this.codeGeneration.getSelection();
    }

    public String getNewProjectClassName() {
        return this.classNameField.getValue();
    }

    public String getNewProjectPackageName() {
        return this.packageNameField.getValue();
    }

    public String getNewProjectConstantsFileName() {
        return this.constantsFileNameField.getValue();
    }

    public String getNewProjectJSPFileName() {
        return this.jspNameField.getValue();
    }

    public String getNewProjectBeanName() {
        return this.beanNameField.getValue();
    }

    public String getNewProjectMeAppName() {
        return this.meAppNameField.getValue();
    }
}

