/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar;

import com.sap.ip.me.mdk.developmentTools.general.api.EP;
import com.sap.ip.me.mdk.developmentTools.general.api.FileNotExistException;
import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.IPropertySystem;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.general.iDE.AbstractIDE;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapmakewar.SAPMPWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.configurationWizard.ConfigurationPage;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar.AntBuilder;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar.AntLaunchDelegate;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar.ProjectLaunchConfigurationDelegate;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar.SAPMPWizardPage;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.selectProject.SelectAProjectWizardPage;
import com.sap.ip.me.mdk.developmentTools.mbs.make.MergeWebXML;
import com.sap.ip.me.mdk.util.Files;
import com.sap.ip.me.mdk.util.Strings;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class SAPMPWizard
extends Wizard
implements IExportWizard,
SAPMPWizardStringLiterals {
    private static final String GEN_HOME = "$jsp";
    private static final String WEB_SAVE = "$web";
    private boolean status;
    private String statusType;
    private String statusMessage;
    SAPMPWizardPage myPage;
    SelectAProjectWizardPage selectPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            Shell parentGUIThing = this.getShell();
            MDKInstallation mdk = MDKInstallation.getInstance();
            if (!mdk.isConfiguredOnce()) {
                OpentoolsFactory.getGuiSystem().invokeConfigurationWizard(parentGUIThing);
            }
            if (mdk.isConfiguredOnce()) {
                this.setNeedsProgressMonitor(true);
                this.myPage = new SAPMPWizardPage();
                this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Configuration Error", (String)"Error during MDK Plugin installation");
        }
    }

    public boolean performFinish() {
        this.status = true;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block34: {
                    IProject selectedProject = SAPMPWizard.this.getSelectedProject();
                    IDE ideInstance = OpentoolsFactory.getIDEInstance();
                    IDESettings ideSet = IDESettings.getInstance();
                    ProjectLaunchConfigurationDelegate proLaunch = new ProjectLaunchConfigurationDelegate();
                    EP epInstance = OpentoolsFactory.getEPInstance();
                    boolean shouldSaveAndRebuild = true;
                    boolean resourcesinJar = false;
                    boolean classesinJar = true;
                    boolean tomcatInDebug = false;
                    boolean upperCase = true;
                    boolean startME = false;
                    boolean useMEClassloader = false;
                    try {
                        IDESettings is = IDESettings.getInstance();
                        IPropertySystem propSyst = OpentoolsFactory.getPropertySystemInstance();
                        is.setJspApplication(epInstance.isComponentProject(selectedProject));
                        String fileName = SAPMPWizard.this.myPage.getArchiveLocation().trim() + "\\" + SAPMPWizard.this.myPage.getApplicationName();
                        while (Strings.endsWithIgnoreCase(fileName, "." + is.getArchiveExtension().toLowerCase())) {
                            fileName = fileName.substring(0, fileName.length() - 4);
                        }
                        String warName = is.getParShortName(selectedProject);
                        warName = warName + "." + is.getArchiveExtension().toLowerCase();
                        String defparArchiveName = null;
                        MDKInstallation mdk = MDKInstallation.getInstance();
                        if (is.isJspApplication()) {
                            defparArchiveName = mdk.getInstFolderMETom() + File.separatorChar + "webapps" + File.separatorChar + warName;
                        } else {
                            defparArchiveName = mdk.getInstFolderMEAWT() + File.separatorChar + "lib" + File.separatorChar + warName;
                            is.setCompileJSP(false, selectedProject);
                        }
                        boolean uploadArchive = SAPMPWizard.this.myPage.isUploadArchive();
                        is.setDefault_WarFile(selectedProject, defparArchiveName);
                        is.setWarArchiveName(selectedProject, fileName);
                        is.setZipArchiveSrc(SAPMPWizard.this.myPage.isZipArchiveSrc(), selectedProject);
                        is.setAutoUpload(uploadArchive, selectedProject);
                        is.setCompileJSP(SAPMPWizard.this.myPage.isCompileJSP(), selectedProject);
                        is.setCompileJSPKeepFiles(SAPMPWizard.this.myPage.isCompileJSPKeepFiles(), selectedProject);
                        boolean keepGeneratedJavaFiles = is.isCompileJSP(selectedProject) && is.isCompileJSPKeepFiles(selectedProject);
                        String tempString = propSyst.loadProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "resourcesInJarFile", selectedProject);
                        if (tempString != null) {
                            resourcesinJar = Boolean.valueOf(tempString);
                        }
                        if ((tempString = propSyst.loadProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "classesInJarFile", selectedProject)) != null) {
                            classesinJar = Boolean.valueOf(tempString);
                        }
                        shouldSaveAndRebuild = SAPMPWizard.this.myPage.isSaveBeforePackaging();
                        resourcesinJar = SAPMPWizard.this.myPage.isResourcesInJar();
                        tomcatInDebug = SAPMPWizard.this.myPage.isStartTomcatInDebug();
                        useMEClassloader = SAPMPWizard.this.myPage.isUseMEClassloader();
                        upperCase = SAPMPWizard.this.myPage.isWarUppercase();
                        startME = SAPMPWizard.this.myPage.isStartME();
                        String urlPattern = SAPMPWizard.this.myPage.getUrlStartPattern();
                        propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "isMDKProject", String.valueOf(true), selectedProject);
                        propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "saveBeforePackage", String.valueOf(shouldSaveAndRebuild), selectedProject);
                        propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "resourcesInJarFile", String.valueOf(resourcesinJar), selectedProject);
                        propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "startTomcatInDebug", String.valueOf(tomcatInDebug), selectedProject);
                        propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "warFileInUppercase", String.valueOf(upperCase), selectedProject);
                        propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "startMEHomepage", String.valueOf(startME), selectedProject);
                        propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "useMEClassloader", String.valueOf(useMEClassloader), selectedProject);
                        propSyst.saveProperty("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar", "urlPattern", urlPattern, selectedProject);
                        String parShortName = is.getParShortName(selectedProject);
                        if (shouldSaveAndRebuild) {
                            monitor.beginTask("Processing request...", 4);
                            MIPlugin.saveAllDirtyEditorsForProject(selectedProject, monitor);
                            monitor.worked(4);
                        } else {
                            monitor.beginTask("Processing request...", 3);
                        }
                        monitor.subTask("Rebuilding the project...");
                        String meClassPath = mdk.getListofJarsAsString(true);
                        meClassPath = meClassPath + is.getToolsjar();
                        HashMap<String, String> userProps = new HashMap<String, String>();
                        userProps.put("tomcat_home", mdk.getInstFolderMETom());
                        String projectFolder = ideInstance.getCurrentProjectFolder(selectedProject);
                        userProps.put("gen_home", projectFolder + File.separator + SAPMPWizard.GEN_HOME);
                        userProps.put("web_home", projectFolder + File.separator + "app-root");
                        userProps.put("me_classpath", meClassPath);
                        userProps.put("web_save", projectFolder + File.separator + SAPMPWizard.WEB_SAVE);
                        AntLaunchDelegate antLaunch = new AntLaunchDelegate();
                        AntBuilder antBuild = new AntBuilder();
                        if (is.isCompileJSP(selectedProject)) {
                            if (Files.doesFileExist(projectFolder + File.separator + SAPMPWizard.WEB_SAVE + File.separator + "web.xml")) {
                                Files.copyFile(projectFolder + File.separator + SAPMPWizard.WEB_SAVE + File.separator + "web.xml", projectFolder + File.separator + "app-root" + File.separator + "WEB-INF" + File.separator + "web.xml");
                            }
                            String[] srcPathFolderNameSegments = new String[]{SAPMPWizard.GEN_HOME};
                            ideInstance.addSrcPathInProject(selectedProject, srcPathFolderNameSegments);
                            antBuild.setBuildFile("antCompileJSPTemplate.xml");
                            antBuild.setBuildFileFolder(MIPlugin.getEclipseFolder() + File.separator + "plugins" + File.separator + "com.sap.ip.me.mdk.developmentTools" + File.separator + "templates" + File.separator);
                            antBuild.setBuildFileProject(selectedProject);
                            antBuild.setAntArgs("");
                            antBuild.build(10, userProps, monitor);
                            MergeWebXML.merge(projectFolder + File.separator + "app-root" + File.separator + "WEB-INF" + File.separator + "web.xml", projectFolder + File.separator + SAPMPWizard.GEN_HOME + File.separator + "webinc.xml");
                        }
                        if (!ideInstance.rebuildCurrentProject(selectedProject, new int[]{0}, 0)) {
                            SAPMPWizard.this.status = false;
                            SAPMPWizard.this.statusType = "Build error";
                            SAPMPWizard.this.statusMessage = "Build of the project " + selectedProject.getName() + " failed.";
                            break block34;
                        }
                        monitor.worked(1);
                        boolean uploadSucceededOrOmitted = true;
                        try {
                            fileName = is.getArchiveName(selectedProject);
                            if (Strings.endsWithIgnoreCase(fileName, "." + is.getArchiveExtension().toLowerCase())) {
                                fileName.substring(0, fileName.length() - 4);
                            }
                            if (upperCase) {
                                fileName = fileName.toUpperCase();
                            }
                            File prospectedParFile = new File(fileName + "." + is.getArchiveExtension().toLowerCase());
                            monitor.subTask("Creating the archive...");
                            if (is.isJspApplication()) {
                                epInstance.makeWarArchiveFromProject(selectedProject, parShortName, prospectedParFile, is.isZipArchiveSrc(selectedProject), resourcesinJar, classesinJar, is.isCompileJSP(selectedProject));
                            } else {
                                epInstance.makeJarArchiveFromProject(selectedProject, parShortName, prospectedParFile, is.isZipArchiveSrc(selectedProject));
                            }
                            if (uploadArchive) {
                                String def_destination = mdk.getInstFolderMETom() + "/webapps/";
                                def_destination = def_destination.replace('\\', '/');
                                if (!(SAPMPWizard.this.myPage.getArchiveLocation().trim().replace('\\', '/') + "/").equalsIgnoreCase(def_destination)) {
                                    def_destination = def_destination + SAPMPWizard.this.myPage.getApplicationName() + "." + is.getArchiveExtension().toLowerCase();
                                    File deffile_destination = new File(def_destination);
                                    Files.copyFile(fileName + "." + is.getArchiveExtension().toLowerCase(), deffile_destination.toString());
                                }
                            }
                            monitor.worked(1);
                        }
                        catch (FileNotExistException e) {
                            uploadSucceededOrOmitted = true;
                            String fileNameRelativeToProjectRoot = AbstractIDE.getSlashSeparatedNameFromStringArray(e.getSegmentsInProject(), File.separatorChar);
                            SAPMPWizard.this.status = false;
                            SAPMPWizard.this.statusMessage = "File " + e.getFile().getAbsolutePath() + " does not exist on the harddisk,\nalthough it is referenced as " + fileNameRelativeToProjectRoot + " in the project.\nCancelling process.";
                            SAPMPWizard.this.statusType = e.getClass().getName();
                        }
                        catch (Exception e) {
                            uploadSucceededOrOmitted = true;
                            SAPMPWizard.this.status = false;
                            SAPMPWizard.this.statusMessage = "A general error occurred during the requested operation.\n" + e.getMessage();
                            SAPMPWizard.this.statusType = e.getClass().getName();
                            e.printStackTrace();
                        }
                        monitor.worked(1);
                        if (is.isCompileJSP(selectedProject) && !keepGeneratedJavaFiles) {
                            String[] antArgs = new String[]{"clean"};
                            antLaunch.launch(monitor, MIPlugin.getEclipseFolder() + File.separator + "plugins" + File.separator + "com.sap.ip.me.mdk.developmentTools" + "/templates/antCompileJSPTemplate.xml", antArgs, userProps);
                            ideInstance.removeSrcPathInProject(selectedProject, SAPMPWizard.GEN_HOME);
                            ideInstance.removeSrcPathInProject(selectedProject, SAPMPWizard.WEB_SAVE);
                        }
                        ConfigurationPage.storeSettings(is.getUserName(), is.getPassword(), is.getInvokeBrowserCmd(), mdk.getMEBaseURL(), mdk.getIrjWebappName());
                        if (!uploadSucceededOrOmitted) {
                            SAPMPWizard.this.status = true;
                        } else {
                            String quickstartSelection = "default";
                            ideSet.setQuickstartProfileName(selectedProject, quickstartSelection);
                            String compName = ideSet.getArchiveName(selectedProject);
                            compName = compName.replace('\\', '/');
                            int lastSlash = compName.lastIndexOf(47);
                            compName = compName.substring(lastSlash + 1);
                            if (Strings.endsWithIgnoreCase(compName, "." + is.getArchiveExtension().toLowerCase())) {
                                compName = compName.substring(0, compName.length() - 4);
                            }
                            if (upperCase) {
                                compName = compName.toUpperCase();
                            }
                            if (startME) {
                                compName = "";
                                urlPattern = "me";
                            }
                            if (uploadArchive) {
                                Object proc = null;
                                proLaunch.mdkStop(selectedProject, monitor, mdk, is.isJspApplication());
                                monitor.subTask("Starting browser ...");
                                String serverAddressBase = mdk.getMEBaseURL();
                                String default_destination = mdk.getInstFolderMETom() + File.separatorChar + "webapps" + File.separatorChar + ideInstance.getProjectName(selectedProject) + "." + is.getArchiveExtension().toLowerCase();
                                String fullAddress = serverAddressBase + compName;
                                int bd = Integer.valueOf(ideSet.getBrowserDelay());
                                String mainfolder = mdk.getInstFolderMETom() + File.separatorChar + "webapps" + File.separatorChar;
                                String subfolder = is.getParShortName(selectedProject);
                                Files.deleteFolders(mainfolder, subfolder);
                                if (!tomcatInDebug) {
                                    proLaunch.mdkLaunch(selectedProject, compName + urlPattern, monitor, "run", mdk, is.isJspApplication(), useMEClassloader);
                                } else {
                                    proLaunch.mdkLaunch(selectedProject, compName + urlPattern, monitor, "debug", mdk, is.isJspApplication(), useMEClassloader);
                                }
                            } else {
                                proLaunch.mdkSetLaunchManager(selectedProject, compName + urlPattern, mdk, is.isJspApplication(), useMEClassloader);
                            }
                            if (SAPMPWizard.this.myPage.isHint3Visible() && is.isJspApplication()) {
                                if (SAPMPWizard.this.myPage.getMiGateWayLength() < 1) {
                                    MessageDialog.openError((Shell)SAPMPWizard.this.getShell(), (String)"Warning", (String)"The MI Client is not configured corretly. The settings of the Sync Gateway are missing.\n\nThe MI Web Console can not be started. Please provide the Sync Gateway settings for the MI Client and export the project again.");
                                } else {
                                    Runtime.getRuntime().exec(ideSet.getInvokeBrowserCmd() + " " + SAPMPWizard.this.myPage.getMiWebConsoleURL());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SAPMPWizard.this.status = false;
                        SAPMPWizard.this.statusType = e.getClass().getName();
                        SAPMPWizard.this.statusMessage = e.getMessage();
                    }
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status = false;
            this.statusType = e.getClass().getName();
            this.statusMessage = this.statusType + ": " + e.getLocalizedMessage();
        }
        if (!this.status) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.statusType, (String)this.statusMessage);
        }
        return true;
    }

    public IProject getSelectedProject() {
        return this.selectPage.getSelectedProject();
    }

    public void addPages() {
        super.addPages();
        this.selectPage = new SelectAProjectWizardPage("Select project first", "Select a project first", null);
        this.addPage((IWizardPage)this.selectPage);
        if (this.myPage == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Configuration Error", (String)"Please configure the MDK Plugin.");
        } else {
            this.addPage((IWizardPage)this.myPage);
        }
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.myPage && this.myPage.isPageComplete();
    }

    public String getWindowTitle() {
        return "MDK: Create a MI Archive File";
    }
}

