/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar;

import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;

public class ProjectLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate
implements IDebugEventSetListener {
    private final String MIStartClassName = "com.sap.ip.me.core.FrameworkInitializer";
    private final String LAUNCH_STARTCLASS = "org.eclipse.jdt.launching.MAIN_TYPE";
    private final String LAUNCH_STARTCLASS_ARGUMENTS = "org.eclipse.jdt.launching.PROGRAM_ARGUMENTS";
    private final String VM_ARGS_PIOS_CONNECTOR = "pios.connector";
    private final String VM_ARGS_PIOS_PERIPHERAL = "PERIPHERAL_EMULATOR_HOME";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (configuration == null) {
            this.abort(LaunchingMessages.getString((String)"MDKLaunchConfigurationDelegate.No_launch_configuration_specified_1"), null, 107);
        }
        monitor.beginTask(MessageFormat.format(LaunchingMessages.getString((String)"MDKLaunchConfigurationDelegate.Starting MI_{0}..._1"), configuration.getName()), 3);
        monitor.subTask(LaunchingMessages.getString((String)"MDKLaunchConfigurationDelegate.Verifying_launch_attributes..._1"));
        String mainTypeName = this.verifyMainTypeName(configuration);
        IJavaProject javaProject = this.getJavaProject(configuration);
        String vmArgs = new String();
        String abacoJarFile = null;
        int arrayExtend = 0;
        try {
            MDKInstallation mdk = MDKInstallation.getInstance();
            if (mdk.isPios_Emulation_Mode()) {
                vmArgs = "-Dpios.connector=" + mdk.getPios_Emulator_Connector() + " -D" + "PERIPHERAL_EMULATOR_HOME" + "=\"" + mdk.getPios_Emulator_Home() + "\"";
                abacoJarFile = mdk.getPios_Classpath_Entry();
                arrayExtend = 1;
            }
        }
        catch (Exception e1) {
            JavaPlugin.log((Throwable)e1);
        }
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            if (mode == "debug") {
                this.abort(MessageFormat.format(LaunchingMessages.getString((String)"JavaLocalApplicationLaunchConfigurationDelegate.JRE_{0}_does_not_support_debug_mode._1"), vm.getName()), null, 106);
            } else {
                this.abort(MessageFormat.format(LaunchingMessages.getString((String)"JavaLocalApplicationLaunchConfigurationDelegate.JRE_{0}_does_not_support_run_mode._2"), vm.getName()), null, 106);
            }
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classPathEntries = this.getClasspath(configuration);
        String[] classPath = new String[classPathEntries.length + arrayExtend];
        boolean doAppend = true;
        int i = 0;
        while (i < classPathEntries.length) {
            classPath[i] = classPathEntries[i];
            if (classPath[i] == abacoJarFile) {
                doAppend = false;
            }
            ++i;
        }
        if (abacoJarFile != null && doAppend) {
            classPath[classPathEntries.length] = abacoJarFile;
        }
        String projectClassName = configuration.getAttribute("org.eclipse.jdt.launching.MAIN_TYPE", "");
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(projectClassName, classPath);
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setBootClassPath(this.getBootpath(configuration));
        if (monitor.isCanceled()) {
            return;
        }
        this.prepareStopInMain(configuration);
        monitor.worked(1);
        monitor.subTask(LaunchingMessages.getString((String)"ProjectLaunchConfigurationDelegate.Creating_source_locator..._2"));
        if (launch.getSourceLocator() == null) {
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, (String)null);
            if (id == null) {
                javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
                JavaSourceLocator sourceLocator = new JavaSourceLocator(javaProject);
                launch.setSourceLocator((ISourceLocator)sourceLocator);
            }
        } else {
            this.setDefaultSourceLocator(launch, configuration);
        }
        monitor.worked(1);
        if (abacoJarFile == null) {
            System.out.println("MDK Launcher: Launched for no emulation");
        } else {
            System.out.println("MDK Launcher: Launched for emulation with VM settings: " + vmArgs);
            System.out.println("and following classpath:");
            int i2 = 0;
            while (i2 < classPath.length) {
                System.out.println(classPath[i2].toString());
                ++i2;
            }
            System.out.println("--------------------");
        }
        runner.run(runConfig, launch, monitor);
        monitor.done();
    }

    public void handleDebugEvents(DebugEvent[] events) {
    }

    public void mdkLaunch(IProject project, String urlPattern, IProgressMonitor monitor, String mode, MDKInstallation mdk, boolean jspApp, boolean useMEClassloader) throws CoreException {
        ILaunchConfigurationWorkingCopy lconfigwc = this.mdkSetLaunchManager(project, urlPattern, mdk, jspApp, useMEClassloader);
        ILaunch lproc = lconfigwc.launch(mode, monitor);
    }

    public ILaunchConfigurationWorkingCopy mdkSetLaunchManager(IProject project, String urlPattern, MDKInstallation mdk, boolean jspApp, boolean useMEClassloader) throws CoreException {
        ILaunchManager lm = this.getLaunchManager();
        ILaunchConfigurationType lconfigurationtype = lm.getLaunchConfigurationType("com.sap.ip.me.mdk.developmentTools.launchConfigurationType");
        ILaunchConfigurationWorkingCopy lconfigwc = lconfigurationtype.newInstance(null, project.getName());
        MIPlugin.setLastLaunchWasJsp(false);
        String appType = " -app:awt";
        String instFolder = mdk.getInstFolderMEAWT();
        String startUrl = "";
        if (jspApp) {
            MIPlugin.setLastLaunchWasJsp(true);
            appType = " -app:jsp";
            startUrl = " -url:" + urlPattern;
            instFolder = mdk.getInstFolderMETom();
        }
        String projectClassName = "com.sap.ip.me.mdk.api.runtime.Start";
        if (useMEClassloader) {
            projectClassName = "com.sap.ip.me.mdk.api.runtime.StartMCL";
        }
        String projectClassNameArgument = "\"-home:" + instFolder + "\" -trace" + startUrl + appType;
        lconfigwc.setAttribute("org.eclipse.debug.core.source_locator_id", "org.eclipse.jdt.debug.ui.javaSourceLocator");
        lconfigwc.setAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", project.getName());
        lconfigwc.setAttribute("org.eclipse.debug.ui.target_run_perspective", "perspective_default");
        lconfigwc.setAttribute("org.eclipse.jdt.launching.MAIN_TYPE", projectClassName);
        lconfigwc.setAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", projectClassNameArgument);
        lconfigwc.setAttribute("org.eclipse.debug.ui.target_debug_perspective", "perspective_default");
        lconfigwc.doSave();
        return lconfigwc;
    }

    public String getJavaREHome() {
        return JavaRuntime.getDefaultVMInstall().getInstallLocation().toString();
    }

    public void mdkStop(IProject project, IProgressMonitor monitor, MDKInstallation mdk) throws CoreException, IOException {
        this.mdkStop(project, monitor, mdk, MIPlugin.isLastLaunchWasJsp());
    }

    public void mdkStop(IProject project, IProgressMonitor monitor, MDKInstallation mdk, boolean jspApp) throws CoreException, IOException {
        boolean meRunning = true;
        meRunning = ProjectLaunchConfigurationDelegate.isMEUp(mdk);
        String instFolder = mdk.getInstFolderMEAWT();
        if (jspApp || meRunning) {
            instFolder = mdk.getInstFolderMETom();
            meRunning = ProjectLaunchConfigurationDelegate.isMEUp(mdk);
        }
        String javaHome = this.getJavaREHome();
        String m = instFolder + "\\lib\\";
        String[] javaCommandLine = new String[]{"\"" + javaHome + "\\bin\\javaw.exe\"", "\"-Dtomcat.home=" + instFolder + "\"", "-classpath", "temporary entry", "com.sap.ip.me.core.FrameworkInitializer", "\"-home:" + instFolder + "\"", "-stop"};
        javaCommandLine[3] = "\"" + mdk.getListofJarsAsString(jspApp) + "\"";
        if (meRunning) {
            System.out.print("Stop MI with command:");
            int i = 0;
            while (i < javaCommandLine.length) {
                System.out.print(" " + javaCommandLine[i]);
                ++i;
            }
            System.out.println(" ");
            try {
                Runtime.getRuntime().exec(javaCommandLine);
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
            int justInCaseCounter = 0;
            int progressCounter = -1;
            meRunning = true;
            while (meRunning) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    JavaPlugin.log((Throwable)e);
                }
                meRunning = ProjectLaunchConfigurationDelegate.isMEUp(mdk);
                if (++justInCaseCounter > 5000) {
                    System.err.println("\nCould not stop MI");
                    meRunning = false;
                }
                if (justInCaseCounter / 10 <= progressCounter) continue;
                System.out.print(".");
                progressCounter = justInCaseCounter / 10;
            }
            System.err.println("\n");
        }
    }

    public void mdkStart(IProject project, IProgressMonitor monitor, MDKInstallation mdk, boolean jspApp) throws CoreException, IOException {
        String instFolder = mdk.getInstFolderMEAWT();
        MIPlugin.setLastLaunchWasJsp(false);
        if (jspApp) {
            instFolder = mdk.getInstFolderMETom();
            MIPlugin.setLastLaunchWasJsp(true);
        }
        String javaHome = this.getJavaREHome();
        String m = instFolder + "\\lib\\";
        String[] javaCommandLine = new String[]{"\"" + javaHome + "\\bin\\java.exe\"", "-classpath", "\"" + mdk.getWarServletApiFileName() + ";" + mdk.getWarME2libApiFileName() + ";" + mdk.getWarMEgApiFileName() + ";" + mdk.getTomcatApiFileName() + ";" + mdk.getJspApiFileName() + "\"", "com.sap.ip.me.core.FrameworkInitializer", "\"-home:" + instFolder + "\""};
        System.out.println("Start MI with command:");
        int i = 0;
        while (i < javaCommandLine.length) {
            System.out.println(" " + javaCommandLine[i]);
            ++i;
        }
        try {
            Runtime.getRuntime().exec(javaCommandLine);
        }
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public static boolean isMEUp(MDKInstallation mdk) {
        return ProjectLaunchConfigurationDelegate.isMEUp(mdk.getMERootURL());
    }

    public static boolean isMEUp(String Url) {
        try {
            HttpURLConnection httpConn = (HttpURLConnection)new URL(Url).openConnection();
            httpConn.connect();
            return httpConn.getResponseCode() == 200;
        }
        catch (Exception ex) {
            JavaPlugin.log((Throwable)ex);
            return false;
        }
    }
}

