/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ui.externaltools.internal.model.VariableContextManager;

public class AntBuilder
extends IncrementalProjectBuilder {
    private static final String BUILD_TYPE_SEPARATOR = ",";
    private static final int[] DEFAULT_BUILD_TYPES = new int[]{10, 6};
    private String buildFile;
    private String buildFileFolder;
    private String antArgs;
    private IProject buildFileProject;

    public IProject[] build(int kind, Map userProps, IProgressMonitor monitor) throws CoreException {
        try {
            System.out.println("Start JSP Precompiling: Build file: " + this.getBuildFile() + " Folder: " + this.getBuildFileFolder() + " Project: " + this.getBuildFileProject());
            ILaunchConfiguration config = AntBuilder.createDefaultConfig(this.getBuildFile(), this.getBuildFileFolder(), this.getBuildFileProject(), userProps, this.getAntArgs());
            boolean runTool = false;
            int[] buildKinds = AntBuilder.buildTypesToArray(config.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", ""));
            int i = 0;
            while (i < buildKinds.length) {
                if (kind == buildKinds[i]) {
                    runTool = true;
                    break;
                }
                ++i;
            }
            if (!runTool) {
                return null;
            }
            VariableContextManager.getDefault().buildStarted(this.getBuildFileProject(), kind);
            config.launch("run", null);
            VariableContextManager.getDefault().buildEnded();
            this.forgetLastBuiltState();
            System.out.println("JSP Precompiling finished");
        }
        catch (Throwable t) {
            JavaPlugin.log((Throwable)t);
        }
        return null;
    }

    public static ILaunchConfiguration createDefaultConfig(String buildFile, String buildFileFolder, IProject project, Map userProps, String antArgs) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        StringBuffer buffer = new StringBuffer(buildFileFolder);
        buffer.append(buildFile);
        String name = buffer.toString().trim();
        name = manager.generateUniqueLaunchConfigurationNameFrom(name);
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            StringBuffer buf = new StringBuffer();
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_IN_BACKGROUND", false);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", buildFileFolder + buildFile);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", userProps);
            if (antArgs.length() > 1) {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", antArgs);
            }
            CommonTab tab = new CommonTab();
            tab.setDefaults(workingCopy);
            tab.dispose();
            return workingCopy;
        }
        catch (Throwable t) {
            JavaPlugin.log((Throwable)t);
            return null;
        }
    }

    protected void startupOnInitialize() {
    }

    public static int[] buildTypesToArray(String buildTypes) {
        int count = 0;
        boolean incremental = false;
        boolean full = false;
        boolean auto = false;
        if (buildTypes == null || buildTypes.length() == 0) {
            return DEFAULT_BUILD_TYPES;
        }
        StringTokenizer tokenizer = new StringTokenizer(buildTypes, BUILD_TYPE_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("incremental".equals(token)) {
                if (incremental) continue;
                incremental = true;
                ++count;
                continue;
            }
            if ("full".equals(token)) {
                if (full) continue;
                full = true;
                ++count;
                continue;
            }
            if (!"auto".equals(token) || auto) continue;
            auto = true;
            ++count;
        }
        int[] results = new int[count];
        count = 0;
        if (incremental) {
            results[count] = 10;
            ++count;
        }
        if (full) {
            results[count] = 6;
            ++count;
        }
        if (auto) {
            results[count] = 9;
            ++count;
        }
        return results;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(String string) {
        this.buildFile = string;
    }

    public String getBuildFileFolder() {
        return this.buildFileFolder;
    }

    public void setBuildFileFolder(String string) {
        this.buildFileFolder = string;
    }

    public IProject getBuildFileProject() {
        System.out.println("get project: " + this.buildFileProject);
        return this.buildFileProject;
    }

    public void setBuildFileProject(IProject project) {
        System.out.println("set project: " + project);
        this.buildFileProject = project;
    }

    public String getAntArgs() {
        return this.antArgs;
    }

    public void setAntArgs(String string) {
        this.antArgs = string;
    }
}

