/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.customProfileAttributeDialog;

import com.sap.ip.me.mdk.developmentTools.general.AbstractCustomProfileAttribute;
import com.sap.ip.me.mdk.developmentTools.general.AbstractProfile;
import com.sap.ip.me.mdk.developmentTools.general.AbstractProfiles;
import com.sap.ip.me.mdk.developmentTools.general.CustomProfileAttribute;
import com.sap.ip.me.mdk.developmentTools.general.api.EP;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledComboBox;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.ip.me.mdk.developmentTools.general.wizards.parServiceRefManager.ICustomProfileStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.customProfileAttributeDialog.CustomAttributeModelAndProvider;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.customProfileAttributeDialog.MyComboBoxCellEditor;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.customProfileAttributeDialog.MySpecialComboCellEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CustomProfileAttributesComposite
extends Composite
implements ICustomProfileStringLiterals {
    private static final String[] booleanChoicesAsString = new String[]{"true", "false"};
    private LabeledTextField titleField;
    private LabeledComboBox componentTypeField;
    private LabeledComboBox classOrJSPNameField;
    private LabeledComboBox authRequirementField;
    private LabeledComboBox personalizationClassField;
    private LabeledComboBox personalizationBehaviourField;
    private LabeledTextField personalizationLinkField;
    private LabeledComboBox resourceBundleNameField;
    private LabeledComboBox isolatedField;
    private LabeledComboBox epcfLevelField;
    private Table table;
    private TableViewer tableViewer;
    private MySpecialComboCellEditor descriptionKeyCombo;
    private MyComboBoxCellEditor inheritanceCombo;
    private MyComboBoxCellEditor personalizationCombo;
    private AbstractProfile profile;
    private Object project;

    public CustomProfileAttributesComposite(Composite parent, AbstractProfile profile, Object project) {
        super(parent, 0);
        this.profile = profile;
        this.project = project;
        this.init();
    }

    public void init() {
        CustomProfileAttributesComposite container = this;
        EP epInstance = OpentoolsFactory.getEPInstance();
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 5;
        gridLayout.marginHeight = 5;
        container.setLayout((Layout)gridLayout);
        this.titleField = new LabeledTextField(container, 0, "Title");
        this.titleField.setToolTipText("The title as it will be displayed in some contexts.");
        this.titleField.setValue(this.profile.getTitle());
        this.componentTypeField = new LabeledComboBox(container, 0, "ComponentType", AbstractProfile.COMPONENT_TYPE_POSSIBILITIES, this.profile.getComponentType(), false);
        this.componentTypeField.setToolTipText("The type of the referenced iView");
        this.componentTypeField.getComboBox().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                String selection = combo.getItem(combo.getSelectionIndex());
                CustomProfileAttributesComposite.this.profile.setComponentType(selection);
                CustomProfileAttributesComposite.this.refreshClassJSPNameField();
            }
        });
        List classNamePossibilities = this.getNewClassNameFieldPossibilites();
        this.classOrJSPNameField = new LabeledComboBox(container, 0, "Class/JSP Name", classNamePossibilities.toArray(), this.profile.getClassName(), true);
        this.classOrJSPNameField.setToolTipText("The name of the class/JSP your profile references");
        this.authRequirementField = new LabeledComboBox(container, 0, "Authentication Requirement", AbstractProfile.AUTH_REQUIREMENT_POSSIBILITES, this.profile.getAuthRequirement(), false);
        this.authRequirementField.setToolTipText("The role the user must have in order to view this iView");
        ArrayList<String> portalComponentPossibilites = new ArrayList<String>(epInstance.getPortalComponentPossibilites(this.project));
        portalComponentPossibilites.add(0, "");
        this.personalizationClassField = new LabeledComboBox(container, 0, "Personalization Class", portalComponentPossibilites.toArray(), this.profile.getPersonalizationClass(), true);
        this.personalizationClassField.setToolTipText("An IPortalComponent that takes over the task of personalizing this Master iView");
        this.personalizationBehaviourField = new LabeledComboBox(container, 0, "Personalization Behaviour", AbstractProfile.PERSONALIZATION_BEHAVIOUR_POSSIBILITIES, this.profile.getPersonalizationBehaviour(), false);
        this.personalizationBehaviourField.setToolTipText("Should the personalization dialog be presented maximized or only inplace?");
        this.personalizationLinkField = new LabeledTextField(container, 0, "Personalization Link");
        this.personalizationLinkField.setToolTipText("A http link which points to the location of the personalization page");
        this.personalizationLinkField.setValue(this.profile.getPersonalizationLink());
        this.personalizationLinkField.getTextField().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomProfileAttributesComposite.this.updatePersonalizationClassFieldEnabledAccordingToPersonalizationLinkField();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.resourceBundleNameField = new LabeledComboBox(container, 0, "Resource Bundle Name", epInstance.getResourceBundleNames(this.project).toArray(), this.profile.getResourceBundleName(), true);
        this.resourceBundleNameField.setToolTipText("The resource bundle used in this Master iView");
        this.resourceBundleNameField.getComboBox().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomProfileAttributesComposite.this.tableViewer != null) {
                    CustomProfileAttributesComposite.this.descriptionKeyCombo.setItems(CustomProfileAttributesComposite.this.getDescriptionKeyPossibilities());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        String epcfLevelInProfile = this.profile.getEPCF();
        this.epcfLevelField = new LabeledComboBox(container, 0, "EPCF Level", AbstractProfile.EPCF_POSSIBILITIES, epcfLevelInProfile, false);
        this.epcfLevelField.setToolTipText("The level of Enterprise Portal Client Framework that is needed.");
        this.isolatedField = new LabeledComboBox(container, 0, "Isolated in PDK", booleanChoicesAsString, String.valueOf(this.profile.isIsolated()), false);
        this.isolatedField.setToolTipText("Determines if your iViews will be placed in an IFrame in the PDK");
        LabeledThingsGroup group = new LabeledThingsGroup();
        group.add(this.titleField);
        group.add(this.componentTypeField);
        group.add(this.classOrJSPNameField);
        group.add(this.authRequirementField);
        group.add(this.personalizationClassField);
        group.add(this.personalizationBehaviourField);
        group.add(this.personalizationLinkField);
        group.add(this.resourceBundleNameField);
        group.add(this.epcfLevelField);
        group.add(this.isolatedField);
        group.alignTextFields();
        Composite tableContainer = new Composite((Composite)container, 0);
        tableContainer.setLayoutData((Object)new GridData(1808));
        GridLayout tableGridLayout = new GridLayout(2, false);
        tableGridLayout.marginWidth = 0;
        tableGridLayout.marginHeight = 0;
        tableContainer.setLayout((Layout)tableGridLayout);
        Label tableLabel = new Label(tableContainer, 0);
        tableLabel.setText("Custom profile properties:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 3;
        tableLabel.setLayoutData((Object)gd);
        this.table = new Table(tableContainer, 65536);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] columnNames = new String[]{"Name", "Value", "Inheritance", "Personalization", "Description Key", "Plain Description"};
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(columnNames[0]);
        column = new TableColumn(this.table, 0);
        column.setText(columnNames[1]);
        column = new TableColumn(this.table, 0);
        column.setText(columnNames[2]);
        column = new TableColumn(this.table, 0);
        column.setText(columnNames[3]);
        column = new TableColumn(this.table, 0);
        column.setText(columnNames[4]);
        column = new TableColumn(this.table, 0);
        column.setText(columnNames[5]);
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.table.setLayout((Layout)tl);
        this.tableViewer = new TableViewer(this.table);
        CustomAttributeModelAndProvider provider = new CustomAttributeModelAndProvider(this.profile, this.tableViewer);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.tableViewer.setContentProvider((IContentProvider)provider);
        this.tableViewer.setInput((Object)this.profile);
        String[] colProps = new String[]{"0", "1", "2", "3", "4", "5"};
        this.tableViewer.setColumnProperties(colProps);
        CellEditor[] editors = new CellEditor[6];
        editors[0] = new TextCellEditor((Composite)this.table);
        editors[1] = new TextCellEditor((Composite)this.table);
        List poss = AbstractCustomProfileAttribute.getInheritancePossibilities();
        String[] inheritancePossibilities = poss.toArray(new String[poss.size()]);
        this.inheritanceCombo = new MyComboBoxCellEditor((Composite)this.table, inheritancePossibilities);
        editors[2] = this.inheritanceCombo;
        poss = AbstractCustomProfileAttribute.getPersonalizationPossibilites();
        String[] personalizationPossibilities = poss.toArray(new String[poss.size()]);
        this.personalizationCombo = new MyComboBoxCellEditor((Composite)this.table, personalizationPossibilities);
        editors[3] = this.personalizationCombo;
        this.descriptionKeyCombo = new MySpecialComboCellEditor((Composite)this.table, this.getDescriptionKeyPossibilities());
        editors[4] = this.descriptionKeyCombo;
        editors[5] = new TextCellEditor((Composite)this.table);
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                try {
                    int column = Integer.parseInt(property);
                    int index = -1;
                    switch (column) {
                        case 2: {
                            index = CustomProfileAttributesComposite.this.inheritanceCombo.getIndex(((AbstractCustomProfileAttribute)element).getInheritance());
                            if (index != -1) {
                                return new Integer(index);
                            }
                            return new Integer(0);
                        }
                        case 3: {
                            index = CustomProfileAttributesComposite.this.personalizationCombo.getIndex(((AbstractCustomProfileAttribute)element).getPersonalization());
                            if (index != -1) {
                                return new Integer(index);
                            }
                            return new Integer(0);
                        }
                        case 4: {
                            return CustomProfileAttributesComposite.this.descriptionKeyCombo.getValue();
                        }
                    }
                    return ((ITableLabelProvider)CustomProfileAttributesComposite.this.tableViewer.getLabelProvider()).getColumnText(element, column);
                }
                catch (NumberFormatException e) {
                    JavaPlugin.log((Throwable)e);
                    return "!!!error!!!";
                }
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                AbstractCustomProfileAttribute attr = (AbstractCustomProfileAttribute)element;
                int column = Integer.parseInt(property);
                switch (column) {
                    case 0: {
                        String newValue = (String)CustomProfileAttributesComposite.this.tableViewer.getCellEditors()[0].getValue();
                        attr.setName(newValue);
                        break;
                    }
                    case 1: {
                        String newValue = (String)CustomProfileAttributesComposite.this.tableViewer.getCellEditors()[1].getValue();
                        attr.setValue(newValue);
                        break;
                    }
                    case 2: {
                        String newValue = ((MyComboBoxCellEditor)CustomProfileAttributesComposite.this.tableViewer.getCellEditors()[2]).getSelection();
                        if (newValue == null) break;
                        attr.setInheritance(newValue);
                        break;
                    }
                    case 3: {
                        String newValue = ((MyComboBoxCellEditor)CustomProfileAttributesComposite.this.tableViewer.getCellEditors()[3]).getSelection();
                        if (newValue == null) break;
                        attr.setPersonalization(newValue);
                        break;
                    }
                    case 4: {
                        String newValue = (String)CustomProfileAttributesComposite.this.tableViewer.getCellEditors()[4].getValue();
                        if (newValue == null) break;
                        attr.setDescription(newValue);
                        break;
                    }
                    case 5: {
                        String newValue = (String)CustomProfileAttributesComposite.this.tableViewer.getCellEditors()[5].getValue();
                        attr.setPlainDescription(newValue);
                    }
                }
                CustomProfileAttributesComposite.this.tableViewer.setInput((Object)CustomProfileAttributesComposite.this.profile);
            }
        });
        Composite buttonContainer = new Composite(tableContainer, 0);
        buttonContainer.setLayout((Layout)new GridLayout(1, true));
        buttonContainer.setLayoutData((Object)new GridData(1168));
        Button addButton = new Button(buttonContainer, 0);
        addButton.setText("add");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomProfileAttributesComposite.this.addAttribute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button deleteButton = new Button(buttonContainer, 0);
        deleteButton.setText("delete");
        deleteButton.setLayoutData((Object)new GridData(768));
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomProfileAttributesComposite.this.deleteAttribute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CustomProfileAttributesComposite.this.deleteAttribute();
            }
        });
    }

    private String[] getDescriptionKeyPossibilities() {
        ArrayList possibilities = new ArrayList();
        try {
            possibilities.addAll(AbstractProfiles.getDescriptionKeysPossibilities(this.project, this.resourceBundleNameField.getComboBox().getText()));
            Collections.sort(possibilities, String.CASE_INSENSITIVE_ORDER);
        }
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
        }
        return possibilities.toArray(new String[possibilities.size()]);
    }

    private void refreshClassJSPNameField() {
        this.classOrJSPNameField.setComboBoxItems(this.getNewClassNameFieldPossibilites().toArray(), null);
        this.classOrJSPNameField.getComboBox().forceFocus();
    }

    private void deleteAttribute() {
        Object selection = this.tableViewer.getElementAt(this.table.getSelectionIndex());
        if (selection instanceof AbstractCustomProfileAttribute) {
            this.profile.removeCustomAttribute((AbstractCustomProfileAttribute)selection);
            this.tableViewer.refresh();
        }
    }

    private void addAttribute() {
        this.profile.addCustomAttribute(new CustomProfileAttribute("", this.profile));
        this.tableViewer.refresh();
    }

    private void updatePersonalizationClassFieldEnabledAccordingToPersonalizationLinkField() {
        String personalizationLink = this.personalizationLinkField.getValue();
        this.personalizationClassField.getComboBox().setEnabled(personalizationLink == null || personalizationLink.trim().equals(""));
    }

    private List getNewClassNameFieldPossibilites() {
        String componentType = this.profile.getComponentType();
        ArrayList<String> classNamePossibilities = null;
        EP epInstance = OpentoolsFactory.getEPInstance();
        if (componentType.equals("IPortalComponent")) {
            classNamePossibilities = epInstance.getPortalComponentPossibilites(this.project);
        } else if (componentType.equals("native JSP")) {
            List jspPossibilites = epInstance.getJspPossibilites(this.project);
            classNamePossibilities = new ArrayList<String>();
            Iterator iterator = jspPossibilites.iterator();
            while (iterator.hasNext()) {
                String[] segments = (String[])iterator.next();
                StringBuffer name = new StringBuffer();
                int i = 1;
                while (i < segments.length) {
                    name.append("/");
                    name.append(segments[i]);
                    ++i;
                }
                classNamePossibilities.add(name.toString());
            }
        } else {
            classNamePossibilities = epInstance.getServletPossibilites(this.project);
        }
        Collections.sort(classNamePossibilities, String.CASE_INSENSITIVE_ORDER);
        return classNamePossibilities;
    }

    protected void putSettingsInProfile() {
        this.profile.setTitle(this.titleField.getValue());
        this.profile.setComponentType(this.componentTypeField.getValue());
        this.profile.setClassName(this.classOrJSPNameField.getValue());
        this.profile.setAuthRequirement(this.authRequirementField.getValue());
        this.profile.setPersonalizationClass(this.personalizationClassField.getValue());
        this.profile.setPersonalizationBehaviour(this.personalizationBehaviourField.getValue());
        this.profile.setPersonalizationLink(this.personalizationLinkField.getValue());
        this.profile.setResourceBundleName(this.resourceBundleNameField.getValue());
        this.profile.setEPCF(this.epcfLevelField.getValue());
        this.profile.setIsolated(this.isolatedField.getValue());
    }
}

