/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager;

import com.sap.ip.me.mdk.developmentTools.general.AbstractProfile;
import com.sap.ip.me.mdk.developmentTools.general.AbstractProfiles;
import com.sap.ip.me.mdk.developmentTools.general.Service;
import com.sap.ip.me.mdk.developmentTools.general.wizards.parServiceRefManager.IProfileWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.AddProfileOpeningMiniDialog;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.ProfilesTableContentAndLabelProvider;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.parServiceRefManager.customProfileAttributeDialog.CustomProfileAttributesDialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;

public class ParServiceProfileComposite
extends Composite
implements IProfileWizardStringLiterals {
    private AbstractProfiles profiles;
    private TableViewer profilesViewer;
    private Object project;

    public ParServiceProfileComposite(Composite parent, AbstractProfiles profiles, Object project) {
        super(parent, 0);
        this.profiles = profiles;
        this.project = project;
        this.setLayout((Layout)new FillLayout());
        this.initComponents(this);
        WorkbenchHelp.setHelp((Control)this, (String)"com.sap.ip.me.mdk.developmentTools.help-profiles");
    }

    private void initComponents(Composite parent) {
        Composite container = parent;
        container.setLayout((Layout)new GridLayout(1, true));
        TabFolder folder = new TabFolder(container, 0);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 500;
        layoutData.widthHint = 500;
        folder.setLayoutData((Object)layoutData);
        this.createTabItems(folder);
    }

    private void createTabItems(TabFolder folder) {
        this.createDetailedTab(folder);
        this.createGeneralTab(folder);
    }

    private void createGeneralTab(TabFolder folder) {
        Composite content = this.createTabAsChildTo(folder, "General Profile Settings");
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 5;
        content.setLayout((Layout)gridLayout);
        final Button setSharingRefButton = new Button(content, 32);
        setSharingRefButton.setSelection(this.profiles.isSharingAccess());
        setSharingRefButton.setText("Allow other PARs to access your code by sharing references.");
        setSharingRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParServiceProfileComposite.this.profiles.setSharingAccess(setSharingRefButton.getSelection());
            }
        });
        setSharingRefButton.setLayoutData((Object)new GridData(770));
        try {
            this.createServiceOrComponentTable(content, "Referenced Services (Check a service to include its classes into the classpath)", this.profiles.getReferencedServices(), this.profiles.getCompleteServicesList());
            this.createServiceOrComponentTable(content, "Referenced Components (Check a component to include its classes into the classpath)", this.profiles.getReferencedComponents(), this.profiles.getCompleteComponentList());
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private void createServiceOrComponentTable(Composite content, String services_list_header, final Set referencedServices, List completeServicesList) {
        Label serviceLabel = new Label(content, 16384);
        serviceLabel.setText(services_list_header);
        serviceLabel.setLayoutData((Object)new GridData(578));
        GridData layoutData = new GridData(770);
        layoutData.heightHint = 150;
        layoutData.widthHint = 300;
        Table serviceTable = new Table(content, 98336);
        serviceTable.setLayoutData((Object)layoutData);
        serviceTable.setHeaderVisible(false);
        serviceTable.setLinesVisible(true);
        CheckboxTableViewer serviceTableViewer = new CheckboxTableViewer(serviceTable);
        serviceTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Service) {
                    Service service1 = (Service)e1;
                    if (e2 instanceof Service) {
                        Service service2 = (Service)e2;
                        return String.CASE_INSENSITIVE_ORDER.compare(service1.getName(), service2.getName());
                    }
                }
                return 0;
            }
        });
        ServicesAndComponentsTableLabelProvider labelProvider = new ServicesAndComponentsTableLabelProvider(referencedServices);
        serviceTableViewer.setContentProvider((IContentProvider)labelProvider);
        serviceTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        serviceTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String serviceName = ((Service)event.getElement()).getName();
                if (event.getChecked()) {
                    referencedServices.add(serviceName);
                } else {
                    referencedServices.remove(serviceName);
                }
            }
        });
        serviceTableViewer.setInput((Object)completeServicesList);
        Iterator iterator = completeServicesList.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            serviceTableViewer.setChecked((Object)service, referencedServices.contains(service.getName()));
        }
    }

    private Composite createTabAsChildTo(TabFolder folder, String text) {
        TabItem generalTab = new TabItem(folder, 0);
        Composite content = new Composite((Composite)folder, 0);
        generalTab.setControl((Control)content);
        generalTab.setText(text);
        return content;
    }

    private void createDetailedTab(TabFolder folder) {
        Composite content = this.createTabAsChildTo(folder, "Individual Profile Settings");
        content.setLayout((Layout)new GridLayout(2, false));
        Table profilesListTable = new Table(content, 65540);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 10;
        profilesListTable.setLayoutData((Object)gridData);
        profilesListTable.setLinesVisible(true);
        profilesListTable.setHeaderVisible(true);
        Button addButton = new Button(content, 8);
        addButton.setLayoutData((Object)new GridData(258));
        addButton.setText("add Profile");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParServiceProfileComposite.this.handleAddButton();
            }
        });
        final Button editButton = new Button(content, 8);
        editButton.setLayoutData((Object)new GridData(258));
        editButton.setText("edit Profile");
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParServiceProfileComposite.this.handleEdit();
            }
        });
        editButton.setEnabled(false);
        final Button removeButton = new Button(content, 8);
        removeButton.setLayoutData((Object)new GridData(258));
        removeButton.setText("remove Profile");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParServiceProfileComposite.this.handleRemoveButton();
            }
        });
        removeButton.setEnabled(false);
        TableColumn column = new TableColumn(profilesListTable, 16384, 0);
        column.setText("Name");
        column = new TableColumn(profilesListTable, 16384, 1);
        column.setText("ComponentType");
        column = new TableColumn(profilesListTable, 16384, 2);
        column.setText("Class Name");
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        profilesListTable.setLayout((Layout)tl);
        this.profilesViewer = new TableViewer(profilesListTable);
        ProfilesTableContentAndLabelProvider ptcalp = new ProfilesTableContentAndLabelProvider();
        this.profilesViewer.setLabelProvider((IBaseLabelProvider)ptcalp);
        this.profilesViewer.setContentProvider((IContentProvider)ptcalp);
        this.profilesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractProfile profile = (AbstractProfile)((IStructuredSelection)event.getSelection()).getFirstElement();
                removeButton.setEnabled(profile != null && !profile.getName().equals("default"));
                editButton.setEnabled(profile != null);
            }
        });
        this.profilesViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ParServiceProfileComposite.this.handleEdit();
            }
        });
        this.profilesViewer.setInput((Object)this.profiles);
        this.profiles.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ParServiceProfileComposite.this.profilesViewer.setInput((Object)ParServiceProfileComposite.this.profiles);
            }
        });
    }

    private void handleRemoveButton() {
        AbstractProfile profile = (AbstractProfile)((IStructuredSelection)this.profilesViewer.getSelection()).getFirstElement();
        this.profiles.removeProfile(profile.getName());
    }

    private void handleEdit() {
        AbstractProfile profile = (AbstractProfile)((IStructuredSelection)this.profilesViewer.getSelection()).getFirstElement();
        CustomProfileAttributesDialog dialog = new CustomProfileAttributesDialog(this.getShell(), profile, this.project);
        if (dialog.open() == 0) {
            this.profilesViewer.refresh();
        }
    }

    private void handleAddButton() {
        AddProfileOpeningMiniDialog apomd = new AddProfileOpeningMiniDialog(this.getShell(), this.profiles);
        apomd.setSelectedInvokeProfileEditorAfterCreation(true);
        if (apomd.open() == 0) {
            try {
                AbstractProfile newProfile = apomd.createTheNewProfile();
                if (apomd.invokeProfileEditorEnabled()) {
                    CustomProfileAttributesDialog dialog = new CustomProfileAttributesDialog(this.getShell(), newProfile, this.project);
                    dialog.open();
                }
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    public void finishAndSaveProfiles() {
        try {
            this.profiles.doSave();
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private static class ServicesAndComponentsTableLabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        private Set referencedServices;

        public ServicesAndComponentsTableLabelProvider(Set referencedServices) {
            this.referencedServices = referencedServices;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray(new Object[list.size()]);
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Service) {
                Service service = (Service)element;
                String name = service.getName();
                switch (columnIndex) {
                    case 0: {
                        return name;
                    }
                    case 1: {
                        return String.valueOf(this.referencedServices.contains(name));
                    }
                }
                return null;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

