/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.openWar;

import com.sap.ip.me.mdk.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.ip.me.mdk.developmentTools.general.wizards.openArchive.IOpenArchiveStringLiterals;
import com.sap.ip.me.mdk.developmentTools.general.wizards.openArchive.IOpenArchiveWizardPage;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.util.Files;
import com.sap.ip.me.mdk.util.eclipse.ProjectNameValidator;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenWarWizardPage
extends WizardPage
implements IOpenArchiveStringLiterals,
IOpenArchiveWizardPage,
ModifyListener {
    private boolean isConfigured;
    LabeledBrowsableTextField parNameField;
    LabeledTextField projectNameField;
    LabeledBrowsableTextField rootFolderField;
    private ProjectNameValidator pnValid = new ProjectNameValidator(MIPlugin.getWorkspace());
    private String projectRootFolderName;
    private String openParFolder;

    public OpenWarWizardPage() {
        super("MDK: Open a MI Archive", "MDK: Open a MI Archive", SAPImageDescriptors.SAP_LOGO);
    }

    public void createControl(Composite parent) {
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        Composite content = sappoEclipseStylePanel.getContentPane();
        this.setTitle("MDK: Open a MI Archive");
        if (this.isConfigured) {
            this.setDescription("A new project is created from an existing .war/.jar file.\n");
            content.setLayout((Layout)new GridLayout(1, true));
            this.parNameField = new LabeledBrowsableTextField(content, 0, "&Archive file name:");
            this.parNameField.setToolTipText("The absolute path of the archive file to open");
            this.parNameField.setFileSelectionMode(0);
            this.parNameField.setFilterNames(new String[]{"*.war;*.jar - MI Servlet or AWT application", "*.war - Web archive (MI Servlet application)", "*.jar - Java archive (MI AWT application)"});
            this.parNameField.setFilterExtensions(new String[]{"*.war;*.jar", "*.war", "*.jar"});
            if (this.openParFolder != null) {
                this.parNameField.setInitalDirectory(this.openParFolder);
            }
            this.parNameField.getTextField().addModifyListener((ModifyListener)this);
            this.parNameField.setDialogFlags(4096);
            this.parNameField.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.stateMask != 262144 || (char)(e.character | 0x60) == 'v') {
                        // empty if block
                    }
                }
            });
            this.projectNameField = new LabeledTextField(content, 0, "Project &name:");
            this.projectNameField.setToolTipText("the name of your new project");
            this.projectNameField.setValue("NewProject");
            this.projectNameField.getTextField().addModifyListener((ModifyListener)this);
            this.rootFolderField = new LabeledBrowsableTextField(content, 0, "Project &root folder:");
            this.rootFolderField.setToolTipText("the folder in which your project will reside");
            this.rootFolderField.setValue(this.projectRootFolderName);
            this.rootFolderField.setFileSelectionMode(1);
            this.rootFolderField.setDialogFlags(4096);
            this.rootFolderField.addModifyListener(this);
            LabeledThingsGroup ltg = new LabeledThingsGroup();
            ltg.add(this.parNameField);
            ltg.add(this.projectNameField);
            ltg.add(this.rootFolderField);
            ltg.alignTextFields();
            DropTarget dropTarget = new DropTarget((Control)parent, 21);
            dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
            dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void drop(DropTargetEvent event) {
                    String filename = ((String[])event.data)[0];
                    OpenWarWizardPage.this.parNameField.getTextField().setText(filename);
                }
            });
        } else {
            Text introText = new Text(content, 1);
            introText.setBackground(content.getBackground());
            introText.setText("Please configure the MDK Plugin.");
        }
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ip.me.mdk.developmentTools.help-openWar");
        this.modifyText(null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isConfigured) {
            this.projectNameField.setFocus();
            this.projectNameField.selectAll();
        }
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setPageComplete(newMessage == null);
    }

    public boolean checkParField() {
        return true;
    }

    public String getFilePath() {
        return this.parNameField.getValue();
    }

    public String getProjectRootFolderName() {
        return this.rootFolderField.getValue();
    }

    public String getProjectName() {
        return this.projectNameField.getValue();
    }

    public void setOpenParFolder(String openParFolder) {
        this.openParFolder = openParFolder;
    }

    public void setConfigured(boolean config) {
        this.isConfigured = config;
    }

    public void setProjectRootRootFolder(String projectRootRootFolder) {
        this.projectRootFolderName = projectRootRootFolder;
    }

    public void modifyText(ModifyEvent e) {
        if (this.isConfigured) {
            String parName = this.parNameField.getValue();
            String projectName = this.projectNameField.getValue();
            String projectRootRootFolder = this.rootFolderField.getValue();
            if (parName == null || parName.trim().equals("")) {
                this.setErrorMessage("Please specify the name of the archive you want to open");
                return;
            }
            File f = new File(parName);
            if (!f.exists() || f.isDirectory()) {
                this.setErrorMessage("File does not exist!");
                return;
            }
            if (!Files.isValidLocalFileName(projectName)) {
                this.setErrorMessage(projectName + " is not a valid file name");
                return;
            }
            if (!Files.isValidFileName(projectRootRootFolder)) {
                this.setErrorMessage(projectRootRootFolder + " is not a valid folder name");
                return;
            }
            File file = new File(projectRootRootFolder, projectName);
            if (file.exists()) {
                this.setErrorMessage("File/Folder " + file.getAbsolutePath() + " already exists.\nPlease choose a different location or project name.");
                return;
            }
            try {
                if (projectName == null || projectName.trim().equals("")) {
                    this.setErrorMessage("Project name is missing.");
                    return;
                }
                if (this.pnValid.existsProjectNameInScope(projectName)) {
                    this.setErrorMessage("Project name " + projectName + " exists already in the workspace.");
                    return;
                }
            }
            catch (CoreException ex) {
                JavaPlugin.log((Throwable)ex);
            }
        }
        this.setErrorMessage(null);
    }
}

