/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject;

import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.IGUI;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapnewproject.ISAPNPWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject.BoOrganizeImportsAction;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject.BoSettingsWizard;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject.NewSmartSyncProjectWizardPage;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class NewSmartSyncProjectWizard
extends Wizard
implements INewWizard,
ISAPNPWizardStringLiterals {
    private NewSmartSyncProjectWizardPage wpage;
    private boolean success;
    private IWorkbench actualWorkbench;
    private IStructuredSelection actualStructuredSelection;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.actualWorkbench = iWorkbench;
        this.actualStructuredSelection = iStructuredSelection;
        this.wpage = new NewSmartSyncProjectWizardPage(false);
        this.setWindowTitle("MDK: New Smart Sync Application Project");
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.wpage.canFlipToNextPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wpage);
    }

    public boolean performFinish() {
        block10: {
            try {
                Shell parentGUIThing = this.getShell();
                boolean success = true;
                IGUI guiSystem = OpentoolsFactory.getGuiSystem();
                IDE ideInstance = OpentoolsFactory.getIDEInstance();
                try {
                    IDESettings iset = IDESettings.getInstance();
                    iset.setProjectRootRootFolder(this.wpage.getProjectRootRootFolderName());
                    iset.setNewProjectClassName(this.wpage.getNewProjectClassName());
                    iset.setNewProjectMEAppName(this.wpage.getNewProjectMeAppName());
                    iset.setNewProjectPackageName(this.wpage.getNewProjectPackageName());
                }
                catch (Exception e) {
                    JavaPlugin.log((Throwable)e);
                    guiSystem.showErrorMessage("Error", "An error occurred writing the project settings", e, parentGUIThing);
                }
                File f = new File(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName());
                if (f.exists()) {
                    String errorMessage = "Folder " + this.wpage.getProjectName() + " already exists as subfolder of " + this.wpage.getProjectRootRootFolderName() + "." + "\nPlease specifiy a different project name or root folder.";
                    System.out.println(errorMessage);
                    guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + f.getAbsolutePath()), parentGUIThing);
                    success = false;
                }
                if (!success) break block10;
                IProject project = null;
                try {
                    if (this.wpage.getRadioSelectJSP()) {
                        project = (IProject)OpentoolsFactory.getEPInstance().createNewSmartSyncProject(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName(), true);
                        OpentoolsFactory.getEPInstance().createNewMEJSPSmartSyncProject(project, this.wpage.getNewProjectPackageName(), this.wpage.getNewProjectXMLName(), this.wpage.getNewProjectClassName(), "Constants", this.wpage.getNewProjectMeAppName(), "TableViewBean");
                    } else {
                        project = (IProject)OpentoolsFactory.getEPInstance().createNewAWTProject(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName());
                    }
                    if (project != null) {
                        ideInstance.rebuildCurrentProject(project, new int[]{0}, 0);
                        IWorkbenchWindow wbWindow = this.actualWorkbench.getActiveWorkbenchWindow();
                        IWorkbenchPage wbPage = wbWindow.getActivePage();
                        IWorkbenchPart aw = wbPage.getActivePart();
                        BoOrganizeImportsAction oia = new BoOrganizeImportsAction((IWorkbenchSite)aw.getSite());
                        oia.run(this.actualStructuredSelection, project);
                    }
                }
                catch (Exception fnfex) {
                    fnfex.printStackTrace();
                    guiSystem.showErrorMessage("Error", "An error has occured while trying to create the project structure", fnfex, parentGUIThing);
                }
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        return true;
    }

    public boolean performFinish_old_wizard() {
        try {
            Shell parentGUIThing = this.getShell();
            this.success = true;
            IGUI guiSystem = OpentoolsFactory.getGuiSystem();
            try {
                IDESettings iset = IDESettings.getInstance();
                iset.setProjectRootRootFolder(this.wpage.getProjectRootRootFolderName());
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
                guiSystem.showErrorMessage("Error", "An error occurred writing the project settings", e, parentGUIThing);
            }
            File f = new File(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName());
            if (f.exists()) {
                String errorMessage = "Folder " + this.wpage.getProjectName() + " already exists as subfolder of " + this.wpage.getProjectRootRootFolderName() + "." + "\nPlease specifiy a different project name or root folder.";
                System.out.println(errorMessage);
                guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + f.getAbsolutePath()), parentGUIThing);
                this.success = false;
            }
            if (this.success) {
                try {
                    IProject project = (IProject)OpentoolsFactory.getEPInstance().createNewSmartSyncProject(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName(), false);
                    this.wpage.setVisible(false);
                    parentGUIThing.setVisible(false);
                    BoSettingsWizard nextPage = new BoSettingsWizard();
                    nextPage.setActProject(project);
                    nextPage.init(this.actualWorkbench, null);
                    WizardDialog wd = new WizardDialog(parentGUIThing, (IWizard)nextPage);
                    wd.open();
                }
                catch (Exception fnfex) {
                    JavaPlugin.log((Throwable)fnfex);
                    guiSystem.showErrorMessage("Error", "An error has occured while trying to create the project structure", fnfex, parentGUIThing);
                }
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return true;
    }
}

