/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject;

import com.sap.ip.me.mdk.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.ModifyListenerDelegator;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPPOEclipseStylePanel;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.wizards.configurationWizard.IConfigurationWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapnewproject.ISAPNPWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.util.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class BoSettingsWizardPage
extends WizardPage
implements ISAPNPWizardStringLiterals,
IConfigurationWizardStringLiterals,
ModifyListener {
    private LabeledTextField boAuthorField;
    private LabeledTextField boInterfacePackNameField;
    private LabeledTextField boImplPackNameField;
    private LabeledTextField projectNameField;
    private LabeledBrowsableTextField projectRootFolderField;
    private LabeledTextField bowebAppliPackNameField;
    private LabeledBrowsableTextField boMetaXMLFileField;
    private IDESettings iset;
    private boolean status = false;
    private IProject actualProject;
    private Composite container;
    private List allProjectNames = new ArrayList();
    private static final String[] BO_OPTIONS = new String[]{"-a | Generate all files", "-s | Generate application files only", "-b | Generate BO only"};
    String projectRootRootFolderName = "";

    protected BoSettingsWizardPage(IProject project) {
        super("BO Wrapper Generation Settings");
        this.actualProject = project;
        try {
            IWorkspaceRoot root = MIPlugin.getWorkspace().getRoot();
            IResource[] members = root.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member instanceof IProject) {
                    this.allProjectNames.add(member.getName());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        this.setTitle("BO Wrapper Generation Settings");
        SAPPOEclipseStylePanel sappoEclipseStylePanel = new SAPPOEclipseStylePanel(parent, "", "");
        this.container = sappoEclipseStylePanel.getContentPane();
        this.createContents(this.container);
        this.setControl((Control)sappoEclipseStylePanel.getTopContainer());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ip.me.mdk.developmentTools.help-createMEProject");
    }

    protected Control createContents(Composite container) {
        this.iset = IDESettings.getInstance();
        ModifyListenerDelegator validator = new ModifyListenerDelegator(this);
        this.projectNameField = new LabeledTextField(container, 0, "Project &name:");
        this.projectNameField.setToolTipText("The name of the new project");
        this.projectNameField.setValue("NewSmartSyncProject");
        this.projectRootFolderField = new LabeledBrowsableTextField(container, 0, "Project &root folder:");
        this.projectRootFolderField.setValue(this.getProjectRootRootFolderName());
        this.projectRootFolderField.setFileSelectionMode(1);
        String boMetaXML = "";
        try {
            IDESettings iset = IDESettings.getInstance();
            boMetaXML = iset.getBoMetaXML(this.actualProject);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        this.boMetaXMLFileField = new LabeledBrowsableTextField(container, 1, "Meta XML file:\t");
        this.boMetaXMLFileField.getTextField().addModifyListener((ModifyListener)validator);
        this.boMetaXMLFileField.setValue(boMetaXML);
        this.boMetaXMLFileField.setFileSelectionMode(0);
        this.boMetaXMLFileField.setFilterExtensions(new String[]{"*.xml"});
        this.projectNameField.getTextField().addModifyListener((ModifyListener)validator);
        this.projectRootFolderField.getTextField().addModifyListener((ModifyListener)validator);
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.projectNameField);
        labelGroup.add(this.projectRootFolderField);
        labelGroup.add(this.boMetaXMLFileField);
        labelGroup.alignTextFields();
        labelGroup.alignTextFields();
        String boOption = "";
        String boAuthor = "";
        String boInterfacePackName = "";
        String boImplPackName = "";
        String bowebAppliName = "";
        String bowebAppliPackName = "";
        try {
            boOption = this.iset.getBoOption(this.actualProject);
            boAuthor = this.iset.getBoAuthor(this.actualProject);
            boInterfacePackName = this.iset.getBoInterfacePackName(this.actualProject);
            boImplPackName = this.iset.getBoImplPackName(this.actualProject);
            bowebAppliName = this.iset.getBoWebAppliName(this.actualProject);
            bowebAppliPackName = this.iset.getBoWebAppliPackName(this.actualProject);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
            this.status = false;
        }
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.boAuthorField = new LabeledTextField(container, 0, "Author:\t\t\t\t");
        this.boAuthorField.setToolTipText("Name of author");
        this.boAuthorField.setValue(boAuthor);
        this.boInterfacePackNameField = new LabeledTextField(container, 0, "Interface package name:\t\t");
        this.boInterfacePackNameField.setToolTipText("Name of package for Interfaces");
        this.boInterfacePackNameField.setValue(boInterfacePackName);
        this.boImplPackNameField = new LabeledTextField(container, 0, "Implementation package name:\t");
        this.boImplPackNameField.setToolTipText("Name of package for implementation");
        this.boImplPackNameField.setValue(boImplPackName);
        this.bowebAppliPackNameField = new LabeledTextField(container, 0, "Web application package name:\t");
        this.bowebAppliPackNameField.setToolTipText("Web application package name");
        this.bowebAppliPackNameField.setValue(bowebAppliPackName);
        int i = 0;
        while (i < 5) {
            Text blankText = new Text(container, 1);
            blankText.setText(" ");
            blankText.setBackground(container.getBackground());
            ++i;
        }
        return null;
    }

    public void modifyText(ModifyEvent e) {
        String projectName = this.getProjectName();
        if (projectName == null || projectName.trim().equals("")) {
            this.setErrorMessage("Please specify a project name.");
            return;
        }
        if (this.allProjectNames.contains(projectName)) {
            this.setErrorMessage("Project name " + projectName + " already exists in this workspace.");
            return;
        }
        String rootFolder = this.getProjectRootRootFolderName();
        File rootFolderFile = new File(rootFolder);
        if (rootFolderFile.exists() && rootFolderFile.isFile()) {
            this.setErrorMessage("Root folder " + rootFolder + " is a file, not a directory.");
            return;
        }
        File projectFolderFile = new File(rootFolderFile, projectName);
        String absolutePath = projectFolderFile.getAbsolutePath();
        if (!Files.isValidFileName(absolutePath)) {
            this.setErrorMessage(absolutePath + " is not a valid file name.");
            return;
        }
        if (projectFolderFile.exists()) {
            this.setErrorMessage("File/Folder already exists.");
            return;
        }
        String XMLName = this.getBoMetaXMLFile();
        if (XMLName == null || XMLName.trim().equals("")) {
            this.setErrorMessage("Please specify a Meta XML file.");
            return;
        }
        File XMLFile = new File(XMLName);
        if (!XMLFile.isFile()) {
            this.setErrorMessage("Specified XML file is not a file.");
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String s) {
        super.setErrorMessage(s);
        this.setPageComplete(s == null);
    }

    public String getBoOption() {
        return "-a";
    }

    public String getBoAuthor() {
        return this.boAuthorField.getValue();
    }

    public String getBoInterfacePackName() {
        return this.boInterfacePackNameField.getValue();
    }

    public String getBoImplPackName() {
        return this.boImplPackNameField.getValue();
    }

    public String getBoMetaXMLFile() {
        return this.boMetaXMLFileField.getValue();
    }

    public String getBowebAppliPackName() {
        return this.bowebAppliPackNameField.getValue();
    }

    public void setActProject(IProject actProject) {
        this.actualProject = actProject;
    }

    public String getProjectName() {
        return this.projectNameField.getValue();
    }

    public void setProjectRootRootFolderName(String name) {
        if (this.projectRootFolderField != null) {
            this.projectRootFolderField.setValue(name);
        }
        this.projectRootRootFolderName = name;
    }

    public String getProjectRootRootFolderName() {
        String temp = "";
        if (this.projectRootFolderField != null) {
            temp = this.projectRootFolderField.getValue();
        }
        if (temp.length() < 1) {
            temp = this.iset.getProjectRootRootFolder();
        }
        if (temp.length() < 1) {
            temp = IDESettings.DEFAULT_PROJECT_ROOT_ROOT_FOLDER;
        }
        return temp;
    }
}

