/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject;

import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.IGUI;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapmakewar.SAPMPWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.general.wizards.sapnewproject.ISAPNPWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject.BoOrganizeImportsAction;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject.BoSettingsWizardPage;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject.CreateBOWrapperCode;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class BoSettingsWizard
extends Wizard
implements IImportWizard,
SAPMPWizardStringLiterals,
ISAPNPWizardStringLiterals {
    private boolean status;
    private String statusType;
    private String statusMessage;
    private IProject actualProject;
    private IWorkbench actualWorkbench;
    private IStructuredSelection actualSelection;
    private BoSettingsWizardPage wpage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.actualWorkbench = workbench;
        this.actualSelection = selection;
        this.wpage = new BoSettingsWizardPage(this.actualProject);
        this.setWindowTitle("MDK: New Smart Sync Application Project");
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.wpage.canFlipToNextPage();
    }

    public boolean performFinish() {
        Shell parentGUIThing = this.getShell();
        Cursor c = new Cursor((Device)parentGUIThing.getDisplay(), 1);
        parentGUIThing.setCursor(c);
        try {
            this.status = true;
            IGUI guiSystem = OpentoolsFactory.getGuiSystem();
            try {
                IDESettings iset = IDESettings.getInstance();
                iset.setProjectRootRootFolder(this.wpage.getProjectRootRootFolderName());
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
                guiSystem.showErrorMessage("Error", "An error occurred writing the project settings", e, parentGUIThing);
            }
            File f = new File(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName());
            if (f.exists()) {
                String errorMessage = "Folder " + this.wpage.getProjectName() + " already exists as subfolder of " + this.wpage.getProjectRootRootFolderName() + "." + "\nPlease specifiy a different project name or root folder.";
                System.out.println(errorMessage);
                guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + f.getAbsolutePath()), parentGUIThing);
                this.status = false;
            }
            if (this.status) {
                try {
                    this.actualProject = (IProject)OpentoolsFactory.getEPInstance().createNewSmartSyncProject(this.wpage.getProjectRootRootFolderName(), this.wpage.getProjectName(), false);
                }
                catch (Exception fnfex) {
                    fnfex.printStackTrace();
                    guiSystem.showErrorMessage("Error", "An error has occured while trying to create the project structure", fnfex, parentGUIThing);
                }
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        this.status = true;
        String boOption = this.wpage.getBoOption();
        String boAuthor = this.wpage.getBoAuthor();
        String boInterfacePackName = this.wpage.getBoInterfacePackName();
        String boImplPackName = this.wpage.getBoImplPackName();
        String boMetaXML = this.wpage.getBoMetaXMLFile();
        String bowebAppliName = OpentoolsFactory.getIDEInstance().getProjectName(this.actualProject);
        String bowebAppliPackName = this.wpage.getBowebAppliPackName();
        try {
            IDESettings iset = IDESettings.getInstance();
            IDE ideInstance = OpentoolsFactory.getIDEInstance();
            iset.setBoOption(this.actualProject, boOption);
            iset.setBoAuthor(this.actualProject, boAuthor);
            iset.setBoInterfacePackName(this.actualProject, boInterfacePackName);
            iset.setBoImplPackName(this.actualProject, boImplPackName);
            iset.setBoMetaXML(this.actualProject, boMetaXML);
            iset.setBoWebAppliName(this.actualProject, bowebAppliName);
            iset.setBoWebAppliPackName(this.actualProject, bowebAppliPackName);
            bowebAppliName = OpentoolsFactory.getIDEInstance().getProjectName(this.actualProject);
            String rootProjectPath = OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(this.actualProject);
            rootProjectPath = rootProjectPath.substring(0, rootProjectPath.indexOf(bowebAppliName) - 1);
            CreateBOWrapperCode.execute(boOption, boMetaXML, boAuthor, rootProjectPath, bowebAppliName, bowebAppliPackName, boInterfacePackName, boImplPackName);
            OpentoolsFactory.getEPInstance().doCoreClassPathSettings(this.actualProject, true, true);
            ideInstance.rebuildCurrentProject(this.actualProject, new int[]{0}, 0);
            IWorkbenchWindow wbWindow = this.actualWorkbench.getActiveWorkbenchWindow();
            IWorkbenchPage wbPage = wbWindow.getActivePage();
            IWorkbenchPart aw = wbPage.getActivePart();
            BoOrganizeImportsAction oia = new BoOrganizeImportsAction((IWorkbenchSite)aw.getSite());
            oia.run(this.actualSelection, this.actualProject);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
            this.status = false;
            this.statusType = e.getClass().getName();
            this.statusMessage = e.getMessage();
        }
        c.dispose();
        c = new Cursor((Device)parentGUIThing.getDisplay(), 0);
        parentGUIThing.setCursor(c);
        return this.status;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wpage);
    }

    public void setActProject(IProject project) {
        this.actualProject = project;
    }
}

