/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newSmartSyncProject;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.ValidateEditException;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.MultiElementListSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorActionBarContributor;

public class BoOrganizeImportsAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public BoOrganizeImportsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString((String)"OrganizeImportsAction.label"));
        this.setToolTipText(ActionMessages.getString((String)"OrganizeImportsAction.tooltip"));
        this.setDescription(ActionMessages.getString((String)"OrganizeImportsAction.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.organize_imports_action_context");
    }

    public BoOrganizeImportsAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(BoOrganizeImportsAction.getCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private ICompilationUnit[] getCompilationUnits(IStructuredSelection selection, IProject actualProject) {
        HashSet result = new HashSet();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)actualProject);
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int k = 0;
            while (k < roots.length) {
                this.collectCompilationUnits(roots[k], result);
                ++k;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
        }
        return ((AbstractCollection)result).toArray(new ICompilationUnit[result.size()]);
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection result) throws JavaModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectCompilationUnits((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            try {
                if (selected[i] instanceof IJavaElement) {
                    IJavaElement elem = (IJavaElement)selected[i];
                    switch (elem.getElementType()) {
                        case 5: {
                            return true;
                        }
                        case 12: {
                            return true;
                        }
                        case 3: 
                        case 4: {
                            IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                            return root.getKind() == 1;
                        }
                        case 2: {
                            return this.hasSourceFolders((IJavaProject)elem);
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
            }
            ++i;
        }
        return false;
    }

    private boolean hasSourceFolders(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(ITextSelection selection) {
        this.run(BoOrganizeImportsAction.getCompilationUnit(this.fEditor));
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit cu = manager.getWorkingCopy(editor.getEditorInput());
        return cu;
    }

    public void run(IStructuredSelection selection, IProject actualProject) {
        ICompilationUnit[] cus = this.getCompilationUnits(selection, actualProject);
        if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.runOnMultiple(cus);
        }
    }

    private void runOnMultiple(final ICompilationUnit[] cus) {
        try {
            String message = ActionMessages.getString((String)"OrganizeImportsAction.multi.status.description");
            final MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, message, null);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    BoOrganizeImportsAction.this.doRunOnMultiple(cus, status, monitor);
                }
            }));
            if (!status.isOK()) {
                String title = ActionMessages.getString((String)"OrganizeImportsAction.multi.status.title");
                ProblemDialog.open((Shell)this.getShell(), (String)title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)ActionMessages.getString((String)"OrganizeImportsAction.error.title"), (String)ActionMessages.getString((String)"OrganizeImportsAction.error.message"));
        }
        catch (InterruptedException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private void doRunOnMultiple(ICompilationUnit[] cus, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(ActionMessages.getString((String)"OrganizeImportsAction.multi.op.description"));
        monitor.beginTask("", cus.length);
        try {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference((IPreferenceStore)store);
            int threshold = JavaPreferencesSettings.getImportNumberThreshold((IPreferenceStore)store);
            boolean ignoreLowerCaseNames = store.getBoolean("org.eclipse.jdt.ui.ignorelowercasenames");
            OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

                public TypeInfo[] chooseImports(TypeInfo[][] openChoices, ISourceRange[] ranges) {
                    throw new OrganizeImportError();
                }
            };
            int i = 0;
            while (i < cus.length) {
                ICompilationUnit cu = cus[i];
                if (this.testOnBuildPath(cu, status)) {
                    String cuLocation = cu.getPath().makeRelative().toString();
                    cu = JavaModelUtil.toWorkingCopy((ICompilationUnit)cu);
                    monitor.subTask(cuLocation);
                    OrganizeImportsOperation op = new OrganizeImportsOperation(cu, prefOrder, threshold, ignoreLowerCaseNames, !cu.isWorkingCopy(), true, query);
                    this.runInSync(op, cuLocation, status, monitor);
                    IProblem parseError = op.getParseError();
                    if (parseError != null) {
                        String message = ActionMessages.getFormattedString((String)"OrganizeImportsAction.multi.error.parse", (Object)cuLocation);
                        status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
                    }
                    ICodeFormatter formatter = ToolFactory.createCodeFormatter();
                    try {
                        String formattedString = formatter.format(cu.getSource(), 0, null, null);
                        cu.getBuffer().setContents(formattedString);
                        cu.save(monitor, true);
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((Throwable)e);
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                ++i;
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private boolean testOnBuildPath(ICompilationUnit cu, MultiStatus status) {
        IJavaProject project = cu.getJavaProject();
        if (!project.isOnClasspath((IJavaElement)cu)) {
            String cuLocation = cu.getPath().makeRelative().toString();
            String message = ActionMessages.getFormattedString((String)"OrganizeImportsAction.multi.error.notoncp", (Object)cuLocation);
            status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
            return false;
        }
        return true;
    }

    private void runInSync(final OrganizeImportsOperation op, final String cuLocation, final MultiStatus status, final IProgressMonitor monitor) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (ValidateEditException e) {
                    status.add(e.getStatus());
                }
                catch (CoreException e) {
                    JavaPlugin.log((Throwable)e);
                    String message = ActionMessages.getFormattedString((String)"OrganizeImportsAction.multi.error.unexpected", (Object)e.getStatus().getMessage());
                    status.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, message, null));
                }
                catch (OrganizeImportError e) {
                    String message = ActionMessages.getFormattedString((String)"OrganizeImportsAction.multi.error.unresolvable", (Object)cuLocation);
                    status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
                }
            }
        };
        this.getShell().getDisplay().syncExec(runnable);
    }

    public void run(ICompilationUnit cu) {
        if (!ElementValidator.check((IJavaElement)cu, (Shell)this.getShell(), (String)ActionMessages.getString((String)"OrganizeImportsAction.error.title"), (this.fEditor != null ? 1 : 0) != 0)) {
            return;
        }
        if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)cu)) {
            return;
        }
        try {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference((IPreferenceStore)store);
            int threshold = JavaPreferencesSettings.getImportNumberThreshold((IPreferenceStore)store);
            boolean ignoreLowerCaseNames = store.getBoolean("org.eclipse.jdt.ui.ignorelowercasenames");
            if (!cu.isWorkingCopy()) {
                IEditorPart editor = EditorUtility.openInEditor((Object)cu);
                if (editor instanceof JavaEditor) {
                    this.fEditor = (JavaEditor)editor;
                }
                cu = JavaModelUtil.toWorkingCopy((ICompilationUnit)cu);
            }
            OrganizeImportsOperation op = new OrganizeImportsOperation(cu, prefOrder, threshold, ignoreLowerCaseNames, !cu.isWorkingCopy(), true, this.createChooseImportQuery());
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            context.run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)op));
            IProblem parseError = op.getParseError();
            if (parseError != null) {
                String message = ActionMessages.getFormattedString((String)"OrganizeImportsAction.single.error.parse", (Object)parseError.getMessage());
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.getString((String)"OrganizeImportsAction.error.title"), (String)message);
                if (this.fEditor != null && parseError.getSourceStart() != -1) {
                    this.fEditor.selectAndReveal(parseError.getSourceStart(), parseError.getSourceEnd() - parseError.getSourceStart() + 1);
                }
            } else if (this.fEditor != null) {
                this.setStatusBarMessage(this.getOrganizeInfo(op));
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)ActionMessages.getString((String)"OrganizeImportsAction.error.title"), (String)ActionMessages.getString((String)"OrganizeImportsAction.error.message"));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)ActionMessages.getString((String)"OrganizeImportsAction.error.title"), (String)ActionMessages.getString((String)"OrganizeImportsAction.error.message"));
        }
        catch (InterruptedException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private String getOrganizeInfo(OrganizeImportsOperation op) {
        int nImportsAdded = op.getNumberOfImportsAdded();
        if (nImportsAdded >= 0) {
            return ActionMessages.getFormattedString((String)"OrganizeImportsAction.summary_added", (Object)String.valueOf(nImportsAdded));
        }
        return ActionMessages.getFormattedString((String)"OrganizeImportsAction.summary_removed", (Object)String.valueOf(-nImportsAdded));
    }

    private OrganizeImportsOperation.IChooseImportQuery createChooseImportQuery() {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeInfo[] chooseImports(TypeInfo[][] openChoices, ISourceRange[] ranges) {
                return BoOrganizeImportsAction.this.doChooseImports(openChoices, ranges);
            }
        };
    }

    private TypeInfo[] doChooseImports(TypeInfo[][] openChoices, final ISourceRange[] ranges) {
        ISelection sel = this.fEditor != null ? this.fEditor.getSelectionProvider().getSelection() : null;
        TypeInfo[] result = null;
        TypeInfoLabelProvider labelProvider = new TypeInfoLabelProvider(1);
        MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                BoOrganizeImportsAction.this.doListSelectionChanged(this.getCurrentPage(), ranges);
            }
        };
        dialog.setTitle(ActionMessages.getString((String)"OrganizeImportsAction.selectiondialog.title"));
        dialog.setMessage(ActionMessages.getString((String)"OrganizeImportsAction.selectiondialog.message"));
        dialog.setElements((Object[][])openChoices);
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            result = new TypeInfo[res.length];
            int i = 0;
            while (i < res.length) {
                Object[] array = (Object[])res[i];
                if (array.length > 0) {
                    result[i] = (TypeInfo)array[0];
                }
                ++i;
            }
        }
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            this.fEditor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
        return result;
    }

    private void doListSelectionChanged(int page, ISourceRange[] ranges) {
        if (page >= 0 && page < ranges.length) {
            ISourceRange range = ranges[page];
            this.fEditor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    private void setStatusBarMessage(String message) {
        IEditorActionBarContributor contributor = this.fEditor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            IStatusLineManager manager = ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
            manager.setMessage(message);
        }
    }

    static final class OrganizeImportError
    extends Error {
        OrganizeImportError() {
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private BoOrganizeImportsAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new BoOrganizeImportsAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }
}

