/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newProjectFromExisting;

import com.sap.ip.me.mdk.developmentTools.general.api.EP;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newProjectFromExisting.NewProjectFromExistingPage;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class NewProjectFromExistingProjectWizard
extends Wizard
implements IImportWizard {
    private NewProjectFromExistingPage myPage;
    private IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        this.myPage = new NewProjectFromExistingPage();
        this.addPage((IWizardPage)this.myPage);
    }

    public boolean performFinish() {
        try {
            File selectedFolder = this.myPage.getSelectedFolder();
            File dotProject = new File(selectedFolder, ".project");
            File dotClasspath = new File(selectedFolder, ".classpath");
            if (dotProject.exists()) {
                dotProject.delete();
            }
            if (dotClasspath.exists()) {
                dotClasspath.delete();
            }
            EP epInstance = OpentoolsFactory.getEPInstance();
            Object project = epInstance.createNewIViewProject(selectedFolder.getParentFile().getAbsolutePath(), selectedFolder.getName());
            epInstance.getCurrentProfiles(project).updateClasspath();
            Eclipse2IDE.selectAndReveal((IResource)project, this.workbench.getActiveWorkbenchWindow());
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return true;
    }
}

