/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newProjectFromExisting;

import com.sap.ip.me.mdk.developmentTools.general.api.EP;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.FileBrowsePanel;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewProjectFromExistingPage
extends WizardPage {
    private EP epinstance = OpentoolsFactory.getEPInstance();
    private FileBrowsePanel fbp;
    private Label projectNameInputField;
    final HashSet existingProjectNames = new HashSet();

    public NewProjectFromExistingPage() {
        super("New mobile application project from existing project.", "New mobile application project from existing project.", SAPImageDescriptors.SAP_LOGO);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(control, 0);
        l.setText("Please select the location of your existing project.");
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        l.setLayoutData((Object)layoutData);
        FileFilter onlyDirsFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        this.fbp = new FileBrowsePanel(control, 0, onlyDirsFilter);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        this.fbp.getControl().setLayoutData((Object)layoutData);
        this.fbp.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewProjectFromExistingPage.this.checkState();
            }
        });
        Label projectNameDescriptionLabel = new Label(control, 0);
        projectNameDescriptionLabel.setLayoutData((Object)new GridData(32));
        projectNameDescriptionLabel.setText("Prospective project name:");
        this.projectNameInputField = new Label(control, 0);
        this.projectNameInputField.setLayoutData((Object)new GridData(768));
        this.projectNameInputField.setText("?");
        FontData fontData = this.projectNameInputField.getFont().getFontData()[0];
        this.projectNameInputField.setFont(new Font((Device)this.getShell().getDisplay(), fontData.getName(), fontData.getHeight(), 1));
        try {
            IResource[] existingProjects = MIPlugin.getWorkspace().getRoot().members(4);
            int i = 0;
            while (i < existingProjects.length) {
                this.existingProjectNames.add(existingProjects[i].getName());
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
        this.setControl((Control)control);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ip.me.mdk.developmentTools.help-newFromExisting");
        WorkbenchHelp.setHelp((Control)this.fbp.getControl(), (String)"com.sap.ip.me.mdk.developmentTools.help-newFromExisting");
    }

    public void performHelp() {
        super.performHelp();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fbp.getControl().setFocus();
        }
    }

    private void checkState() {
        File folder = this.getSelectedFolder();
        if (!this.epinstance.isPossibleComponentRootFolder(folder)) {
            this.projectNameInputField.setText("?");
            this.setErrorMessage("This folder doesn't look like a portal component project.");
            this.setPageComplete(false);
            return;
        }
        this.projectNameInputField.setText(folder.getName());
        if (this.existingProjectNames.contains(folder.getName())) {
            this.setErrorMessage("A project of the same name already exists.");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public File getSelectedFolder() {
        return (File)this.fbp.getSelection().getFirstElement();
    }
}

