/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard;

import com.sap.ip.me.mdk.developmentTools.general.AbstractProfiles;
import com.sap.ip.me.mdk.developmentTools.general.api.IPropertySystem;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.wizards.newGenericWizard.INewGenericWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.IPDKCustomComponentWizard;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.NewGenericWizard;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.PDKCustomComponentExtension;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.PDKCustomComponentExtensionPoint;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.PDKExtensionPointContentAndLabelProvider;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewGenericWizardPage
extends WizardPage
implements INewGenericWizardStringLiterals {
    private AbstractProfiles profiles;
    private IProject lastSelectedProject;
    private static final String THIS_PROP_GROUP = "com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard";
    private static final String SELECTED_WIZARD_PROP = "selectedCustomWizard";
    private PDKCustomComponentExtensionPoint pdkExtensionPoint = null;
    private StyledText text;
    private PDKCustomComponentExtension selectedPDKExtension;
    private HashMap extensionObjectToWizard = new HashMap();
    private Table table;
    private TableViewer tableViewer;

    public NewGenericWizardPage(String pageName) {
        super(pageName);
        this.setTitle("New Master iView.");
        this.setDescription("Please select a template");
    }

    public boolean canFlipToNextPage() {
        return this.selectedPDKExtension != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.table.setFocus();
            IProject selectedProject = ((NewGenericWizard)this.getWizard()).getSelectedProject();
            IPropertySystem propSystem = OpentoolsFactory.getPropertySystemInstance();
            try {
                String wizardName = propSystem.loadProperty(THIS_PROP_GROUP, SELECTED_WIZARD_PROP, selectedProject);
                PDKCustomComponentExtension[] extensions = this.pdkExtensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    PDKCustomComponentExtension extension = extensions[i];
                    if (extension.getName().equals(wizardName)) {
                        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)extension));
                    }
                    ++i;
                }
                if (this.tableViewer.getSelection().isEmpty() && extensions.length > 0) {
                    this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)extensions[0]));
                }
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    public IWizardPage getNextPage() {
        if (this.selectedPDKExtension == null) {
            return null;
        }
        IPDKCustomComponentWizard pdkCustomComponentWizard = (IPDKCustomComponentWizard)this.extensionObjectToWizard.get(this.selectedPDKExtension);
        IProject selectedProject = ((NewGenericWizard)this.getWizard()).getSelectedProject();
        if (selectedProject != this.lastSelectedProject) {
            try {
                this.profiles = OpentoolsFactory.getEPInstance().getCurrentProfiles(selectedProject);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An error occurred reading the profiles of project " + selectedProject.getName()));
                this.getContainer().getShell().close();
                return null;
            }
        }
        if (pdkCustomComponentWizard == null) {
            IPropertySystem propSystem = OpentoolsFactory.getPropertySystemInstance();
            try {
                propSystem.saveProperty(THIS_PROP_GROUP, SELECTED_WIZARD_PROP, this.selectedPDKExtension.getName(), selectedProject);
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
            String wizardsClassName = this.selectedPDKExtension.getClassName();
            ClassLoader wizardsClassLoader = this.selectedPDKExtension.getExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
            try {
                pdkCustomComponentWizard = (IPDKCustomComponentWizard)wizardsClassLoader.loadClass(wizardsClassName).newInstance();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error on selected wizard", (String)("An error occurred during creation of the selected wizard.\nException(" + e.getClass().getName() + "): " + e.getMessage()));
                JavaPlugin.log((Throwable)e);
                return null;
            }
            StructuredSelection projectSelection = new StructuredSelection((Object)selectedProject);
            pdkCustomComponentWizard.setContainer(this.getContainer());
            pdkCustomComponentWizard.setProfiles(this.profiles);
            pdkCustomComponentWizard.init(MIPlugin.getDefault().getWorkbench(), (IStructuredSelection)projectSelection);
            pdkCustomComponentWizard.addPages();
            this.extensionObjectToWizard.put(this.selectedPDKExtension, pdkCustomComponentWizard);
        }
        this.lastSelectedProject = selectedProject;
        if (pdkCustomComponentWizard.getProject() != selectedProject) {
            pdkCustomComponentWizard.setCurrentProject(selectedProject);
            pdkCustomComponentWizard.setProfiles(this.profiles);
        }
        return pdkCustomComponentWizard.getStartingPage();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, true));
        Composite tableComposite = new Composite(main, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        tableComposite.setLayout((Layout)new GridLayout());
        Composite descriptionComposite = new Composite(main, 0);
        descriptionComposite.setLayoutData((Object)new GridData(1808));
        descriptionComposite.setLayout((Layout)new GridLayout());
        Label tableLabel = new Label(tableComposite, 0);
        tableLabel.setText("Please &select a template:");
        IExtensionPoint extensionPoint = MIPlugin.getDefault().getDescriptor().getExtensionPoint("PDKCustomPortalComponent");
        try {
            this.pdkExtensionPoint = new PDKCustomComponentExtensionPoint(extensionPoint);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)parent.getShell(), (String)"Error", (String)e.getMessage());
        }
        this.table = new Table(tableComposite, 2048);
        this.table.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(this.table);
        PDKExtensionPointContentAndLabelProvider provider = new PDKExtensionPointContentAndLabelProvider();
        this.tableViewer.setContentProvider((IContentProvider)provider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.tableViewer.setInput((Object)this.pdkExtensionPoint);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
                NewGenericWizardPage.this.selectedPDKExtension = (PDKCustomComponentExtension)selectedObject;
                NewGenericWizardPage.this.text.setText(NewGenericWizardPage.this.selectedPDKExtension.getDescription());
                NewGenericWizardPage.super.getContainer().updateButtons();
            }
        });
        this.tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                NewGenericWizardPage.super.getContainer().showPage(NewGenericWizardPage.this.getNextPage());
            }
        });
        Label descLabel = new Label(descriptionComposite, 0);
        descLabel.setText("Description:");
        this.text = new StyledText(descriptionComposite, 2048);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.setEditable(false);
        this.text.setEnabled(false);
        this.text.setWordWrap(true);
        this.text.setBackground(new Color((Device)this.getShell().getDisplay(), 255, 255, 255));
        this.text.setText("<b>No</b>thing selected yet.");
        this.setControl((Control)main);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"com.sap.ip.me.mdk.developmentTools.help-newMasterIView");
    }
}

