/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newComponentWizards;

import com.sap.ip.me.mdk.developmentTools.general.AbstractCustomProfileAttribute;
import com.sap.ip.me.mdk.developmentTools.general.AbstractProfile;
import com.sap.ip.me.mdk.developmentTools.general.AbstractProfiles;
import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.general.iDE.AbstractIDE;
import com.sap.ip.me.mdk.developmentTools.general.wizards.newComponentWizards.INewJSPDynPageWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newComponentWizards.NewJSPDynPageWiizardPageTwo;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newComponentWizards.NewJSPDynPageWizardPage;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.IPDKCustomComponentWizard;
import com.sap.ip.me.mdk.util.Templating;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewJSPDynPageWizard
extends Wizard
implements INewWizard,
IPDKCustomComponentWizard,
INewJSPDynPageWizardStringLiterals {
    private NewJSPDynPageWizardPage pageOne;
    private NewJSPDynPageWiizardPageTwo pageTwo;
    private AbstractProfiles profiles;
    private URL pluginInstallURL;
    private IProject project = null;
    private Set forbiddenClassNames = new HashSet();

    public NewJSPDynPageWizard() {
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.pluginInstallURL = MIPlugin.getDefault().getDescriptor().getInstallURL();
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New JSPDynPage");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        this.project = firstElement != null && firstElement instanceof IResource ? ((IResource)firstElement).getProject() : Eclipse2IDE.getCurrentProject();
        this.pageOne = new NewJSPDynPageWizardPage(this.project, this.profiles);
        this.pageTwo = new NewJSPDynPageWiizardPageTwo(this.project);
        this.addPage((IWizardPage)this.pageOne);
        this.addPage((IWizardPage)this.pageTwo);
        this.setCurrentProject(this.project);
    }

    public void setProfiles(AbstractProfiles profiles) {
        this.profiles = profiles;
        if (this.pageOne != null) {
            this.pageOne.setProfiles(profiles);
        }
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String dynPageClassName = NewJSPDynPageWizard.this.pageOne.getClassName();
                String dynPagePackageName = NewJSPDynPageWizard.this.pageOne.getPackageName();
                String dynPageFullyQualifiedClassName = NewJSPDynPageWizard.this.pageOne.getFullyQualifiedClassName();
                String beanClassName = "";
                String beanFullyQualifiedClassName = "";
                String beanScope = "";
                String beanName = "";
                String jspFilename = AbstractIDE.cleanJSPFileName(NewJSPDynPageWizard.this.pageOne.getJSPName());
                IDE ideInstance = OpentoolsFactory.getIDEInstance();
                int taskCount = 3;
                boolean generateBeanStatements = NewJSPDynPageWizard.this.pageTwo.isGenerateBeanStatements();
                boolean useExistingBean = NewJSPDynPageWizard.this.pageTwo.isUseExistingBean();
                if (generateBeanStatements && !useExistingBean) {
                    ++taskCount;
                }
                monitor.beginTask("Processing requested operation...", taskCount);
                if (generateBeanStatements) {
                    beanName = NewJSPDynPageWizard.this.pageTwo.getBeanName();
                    String beanPackageName = NewJSPDynPageWizard.this.pageTwo.getBeanPackageName();
                    beanClassName = NewJSPDynPageWizard.this.pageTwo.getBeanClassName();
                    beanFullyQualifiedClassName = NewJSPDynPageWizard.this.pageTwo.getBeanFullyQualifiedClassName();
                    beanScope = NewJSPDynPageWizard.this.pageTwo.getBeanScope();
                    if (!useExistingBean) {
                        monitor.subTask("Creating bean source");
                        HashMap<String, String> beanTemplateMap = new HashMap<String, String>();
                        if (beanPackageName == null) {
                            beanPackageName = "";
                        }
                        beanPackageName = beanPackageName.trim();
                        beanTemplateMap.put("package", beanPackageName);
                        beanTemplateMap.put("class-name", beanClassName);
                        try {
                            MIPlugin.createJavaFileFromXMLTemplateAndOpenIt(NewJSPDynPageWizard.this.project, beanFullyQualifiedClassName, "templates/SimpleBeanTemplate.xml", beanTemplateMap);
                        }
                        catch (Exception e) {
                            JavaPlugin.log((Throwable)e);
                            MessageDialog.openError((Shell)NewJSPDynPageWizard.this.getShell(), (String)"Error", (String)("Couldn't create/open bean class !!!\n\nError message: " + e.getMessage()));
                        }
                        monitor.worked(1);
                    }
                }
                monitor.subTask("Saving profiles");
                AbstractProfile defaultProfile = NewJSPDynPageWizard.this.profiles.getProfileByName("default");
                AbstractCustomProfileAttribute tagLibAttribute = defaultProfile.createOrGetCustomAttribute("tagLib");
                tagLibAttribute.setValue("/SERVICE/htmlb/taglib/htmlb.tld");
                tagLibAttribute.setPersonalization("none");
                tagLibAttribute.setInheritance("final");
                AbstractProfile selectedProfile = NewJSPDynPageWizard.this.pageOne.getSelectedProfile();
                selectedProfile.setComponentType("IPortalComponent");
                selectedProfile.setClassName(dynPageFullyQualifiedClassName);
                try {
                    NewJSPDynPageWizard.this.profiles.ensureServiceIsReferenced("htmlb");
                    NewJSPDynPageWizard.this.profiles.doSave();
                }
                catch (Exception e) {
                    JavaPlugin.log((Throwable)e);
                    MessageDialog.openError((Shell)NewJSPDynPageWizard.this.pageOne.getShell(), (String)"Error", (String)("Couldn't save profiles !!!\n\nError message: " + e.getMessage()));
                }
                monitor.worked(1);
                monitor.subTask("Creating DynPage source");
                HashMap<String, String> dynPageClassMap = new HashMap<String, String>();
                if (dynPagePackageName == null) {
                    dynPagePackageName = "";
                }
                dynPagePackageName = dynPagePackageName.trim();
                dynPageClassMap.put("package", dynPagePackageName);
                dynPageClassMap.put("class-name", dynPageClassName);
                dynPageClassMap.put("scope", beanScope);
                dynPageClassMap.put("bean-class-name", beanClassName);
                dynPageClassMap.put("bean-full-class-name", beanFullyQualifiedClassName);
                dynPageClassMap.put("bean-name", beanName);
                dynPageClassMap.put("jsp-name", jspFilename);
                try {
                    MIPlugin.createJavaFileFromXMLTemplateAndOpenIt(NewJSPDynPageWizard.this.project, dynPageFullyQualifiedClassName, "templates/JSPDynPageClassTemplate.xml", dynPageClassMap);
                }
                catch (Exception e) {
                    JavaPlugin.log((Throwable)e);
                    MessageDialog.openError((Shell)NewJSPDynPageWizard.this.pageOne.getShell(), (String)"Error", (String)("Couldn't create/open DynPage source file !!!\n\nError message: " + e.getMessage()));
                }
                monitor.worked(1);
                monitor.subTask("Creating JSP source");
                String[] privateResourcePath = OpentoolsFactory.getEPInstance().getPrivateResourcePath();
                String[] jspSegments = AbstractIDE.getFileNameSegmentsForSlashSeparatedFileName(jspFilename);
                ArrayList<String> absoluteSegmentsList = new ArrayList<String>(Arrays.asList(privateResourcePath));
                absoluteSegmentsList.add("pagelet");
                absoluteSegmentsList.addAll(Arrays.asList(jspSegments));
                String[] absoluteSegments = absoluteSegmentsList.toArray(new String[absoluteSegmentsList.size()]);
                try {
                    File jspFile = ideInstance.createFileInProject(NewJSPDynPageWizard.this.project, absoluteSegments, true);
                    FileWriter jspWriter = new FileWriter(jspFile);
                    InputStream jspTemplateStream = new URL(NewJSPDynPageWizard.this.pluginInstallURL, "templates/NewJSPDynPage_JSP.xml").openStream();
                    HashMap<String, String> jspMap = new HashMap<String, String>();
                    jspMap.put("bean-name", beanName);
                    jspMap.put("bean-class", beanFullyQualifiedClassName);
                    jspMap.put("scope", beanScope);
                    Templating.writeTemplateToWriter(jspMap, jspTemplateStream, jspWriter);
                    jspTemplateStream.close();
                    jspWriter.close();
                    ideInstance.openFileInEditor(NewJSPDynPageWizard.this.project, absoluteSegments);
                }
                catch (Exception e) {
                    JavaPlugin.log((Throwable)e);
                    MessageDialog.openError((Shell)NewJSPDynPageWizard.this.pageOne.getShell(), (String)"Error", (String)("Couldn't create/open JSP file !!!\n\nError message: " + e.getMessage()));
                }
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return true;
    }

    public void setCurrentProject(IProject project) {
        this.project = project;
        try {
            this.forbiddenClassNames = MIPlugin.getAllFullyQualifiedClassNamesInProject(project);
        }
        catch (JavaModelException e) {
            this.forbiddenClassNames = new HashSet();
        }
        if (this.pageOne != null) {
            this.pageOne.setProject(project);
            this.pageOne.setForbiddenClassNames(this.forbiddenClassNames);
        }
        if (this.pageTwo != null) {
            this.pageTwo.setProject(project);
        }
    }

    public IProject getProject() {
        return this.project;
    }
}

