/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.configurationWizard;

import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledBrowsableTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.TCPPortFieldEditor;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.developmentTools.general.wizards.configurationWizard.IConfigurationWizardStringLiterals;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar.ProjectLaunchConfigurationDelegate;
import com.sap.ip.me.mdk.util.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConfigurationPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IConfigurationWizardStringLiterals {
    private Color disabledBackground;
    private Color standardBackground;
    private StringFieldEditor serveraddressField;
    private StringFieldEditor webappnameField;
    private StringFieldEditor userNameField;
    private StringFieldEditor passwordField;
    private LabeledBrowsableTextField instFolderMETom;
    private LabeledBrowsableTextField instFolderMEAWT;
    private Text infoText;
    private TCPPortFieldEditor tcpPortField;
    private StringFieldEditor invokeBrowserCommandLineField;
    private LabeledBrowsableTextField toolsjarField;
    private boolean status = false;
    private boolean settingsJSPOK = false;
    private boolean settingsAWTOK = false;
    private final String fileToIdentifyMI = "listOfJars.txt";
    private String statusType;
    private String statusMessage;
    private Button testButton;

    public void init(IWorkbench workbench) {
    }

    public ConfigurationPage() {
        super("MDK: Settings of MI Client", 0x800000);
        this.setDescription("Location and settings of the MI Client.");
    }

    protected Control createContents(Composite parent) {
        Group tomcatRuntime = new Group(parent, 0);
        tomcatRuntime.setText("Tomcat Runtime");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        tomcatRuntime.setLayout((Layout)layout);
        GridData gridDataParent = new GridData();
        gridData.verticalAlignment = 2;
        gridData.horizontalSpan = 3;
        tomcatRuntime.setLayoutData((Object)new GridData(768));
        this.instFolderMETom = new LabeledBrowsableTextField((Composite)tomcatRuntime, 0, "MI home folder:");
        this.instFolderMETom.setFileSelectionMode(1);
        this.disabledBackground = tomcatRuntime.getBackground();
        this.standardBackground = this.instFolderMETom.getTextField().getBackground();
        tomcatRuntime.setLayout((Layout)layout);
        tomcatRuntime.setLayoutData((Object)new GridData(768));
        this.toolsjarField = new LabeledBrowsableTextField((Composite)tomcatRuntime, 0, "&Java SDK tools.jar file:");
        this.toolsjarField.setFileSelectionMode(0);
        this.toolsjarField.setFilterNames(new String[]{"*.jar - Java archive"});
        Group tomcatRuntimeSettings = new Group((Composite)tomcatRuntime, 0);
        tomcatRuntimeSettings.setLayout((Layout)layout);
        tomcatRuntimeSettings.setLayoutData((Object)new GridData(768));
        tomcatRuntimeSettings.setText("Server Settings and Browser to Connect to MI Client");
        this.createFieldEditors_tom(tomcatRuntimeSettings);
        GridLayout awtlayout = new GridLayout();
        awtlayout.numColumns = 1;
        Group awtRuntime = new Group(parent, 0);
        awtRuntime.setText("AWT Runtime");
        awtRuntime.setLayout((Layout)awtlayout);
        awtRuntime.setLayoutData((Object)new GridData(768));
        this.instFolderMEAWT = new LabeledBrowsableTextField((Composite)awtRuntime, 0, "MI home folder:");
        this.instFolderMEAWT.setFileSelectionMode(1);
        Group userDataGroup = new Group(parent, 0);
        userDataGroup.setText("MI Logon Information");
        userDataGroup.setLayoutData((Object)new GridData(768));
        String[] userData = ConfigurationPage.getMDKParams();
        this.userNameField = new StringFieldEditor(userData[0], "MI logon user name: ", (Composite)userDataGroup);
        this.userNameField.setStringValue(userData[0]);
        this.passwordField = new StringFieldEditor(userData[1], "MI logon password: ", (Composite)userDataGroup);
        char ec = '\u25cf';
        this.passwordField.getTextControl((Composite)userDataGroup).setEchoChar(ec);
        this.passwordField.setStringValue(userData[1]);
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        this.infoText = new Text(this.getFieldEditorParent(), 1);
        this.infoText.setEditable(false);
        this.infoText.setText("invisible entry\ninvisible entry");
        this.infoText.setVisible(false);
        this.initFieldsToFormerValues();
        this.updateToolsjarFieldVisibility(this.instFolderMETom.getTextField().getText());
        this.instFolderMETom.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ConfigurationPage.this.updateToolsjarFieldVisibility(ConfigurationPage.this.instFolderMETom.getTextField().getText());
            }
        });
        this.instFolderMEAWT.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (ConfigurationPage.this.instFolderMEAWT.getTextField().getText().length() > 1) {
                    int status = ConfigurationPage.this.isValidMIFolder(ConfigurationPage.this.instFolderMEAWT.getTextField().getText(), false);
                    ConfigurationPage.this.settingsAWTOK = true;
                    if (status < 0) {
                        ConfigurationPage.this.settingsAWTOK = false;
                        MessageDialog.openError((Shell)ConfigurationPage.this.getShell(), (String)"Error", (String)"This is not a valid root folder for MI Client - AWT runtime.\nPossible reasons:\n - The MI Client installation did not finish successfully.\n - The runtime of the MI Client does not match.");
                    }
                }
            }
        });
    }

    protected void createFieldEditors_tom(Group group) {
        WorkbenchHelp.setHelp((Control)group, (String)"com.sap.ip.me.mdk.developmentTools.help-config");
        String preferenceNamePrefix = "com.sap.ip.me.mdk.developmentTools.general.MISettings.";
        String serverAddressPreferenceName = preferenceNamePrefix + "IRJ_SERVER";
        String webappRootNamePreferenceName = preferenceNamePrefix + "IRJ_WEBAPP_NAME";
        String instFolderMETomPreferenceName = preferenceNamePrefix + "INST_FOLDER_NAME_TOM";
        String instFolderMEAWTPreferenceName = preferenceNamePrefix + "INST_FOLDER_NAME_AWT";
        String tcpPortPreferenceName = preferenceNamePrefix + "IRJ_PORT";
        String delayPreference = preferenceNamePrefix + "5";
        String invokeBrowserPreferenceName = preferenceNamePrefix + "browser_cmd";
        String invokeStartTomcatPreferenceName = preferenceNamePrefix + "tomcatstart_cmd";
        String invokeStopTomcatPreferenceName = preferenceNamePrefix + "tomcatstop_cmd";
        String toolsjarfolder = preferenceNamePrefix + "toolsjar_folder";
        this.serveraddressField = new StringFieldEditor(serverAddressPreferenceName, "MI server name:", (Composite)group);
        this.serveraddressField.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.serveraddressField);
        this.webappnameField = new StringFieldEditor(webappRootNamePreferenceName, "MI webapp root:", (Composite)group);
        this.addField((FieldEditor)this.webappnameField);
        this.tcpPortField = new TCPPortFieldEditor(tcpPortPreferenceName, "MI webapp TCP port:", (Composite)group);
        this.addField((FieldEditor)this.tcpPortField);
        this.invokeBrowserCommandLineField = new StringFieldEditor(invokeBrowserPreferenceName, "Command line to launch browser:", (Composite)group);
    }

    protected void contributeButtons(Composite parent) {
        GridLayout parentsLayout = (GridLayout)parent.getLayout();
        parentsLayout.numColumns = 1;
        int heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        this.testButton = new Button(parent, 8);
        this.testButton.setFont(super.getFont());
        this.testButton.setText("Test Settings");
        GridData data = new GridData(256);
        data.heightHint = heightHint;
        data.widthHint = Math.max(widthHint, this.testButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.testButton.setLayoutData((Object)data);
        this.testButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ConfigurationPage.this.testSettings();
            }
        });
    }

    public boolean performOk() {
        int len = this.instFolderMETom.getTextField().getText().length() + this.instFolderMEAWT.getTextField().getText().length();
        if (len < 1) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"At least one MI Client home folder has to be specified.");
            this.status = false;
        } else {
            this.status = this.settingsJSPOK | this.settingsAWTOK;
            if (this.status) {
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String instFolderAWT;
                        monitor.beginTask("Verifying settings", 4);
                        int port = ConfigurationPage.this.tcpPortField.getIntValue();
                        String servername = ConfigurationPage.this.serveraddressField.getStringValue();
                        String webappName = ConfigurationPage.this.webappnameField.getStringValue();
                        String browserInvokeCmd = ConfigurationPage.this.invokeBrowserCommandLineField.getStringValue();
                        String userName = ConfigurationPage.this.userNameField.getStringValue();
                        String password = ConfigurationPage.this.passwordField.getStringValue();
                        if (userName == null) {
                            userName = "";
                        }
                        if (password == null) {
                            password = "";
                        }
                        ConfigurationPage.storeSettings(userName, password, browserInvokeCmd, "http://" + servername + ":" + ConfigurationPage.this.tcpPortField.getStringValue() + "/", webappName);
                        String instFolderTom = ConfigurationPage.this.instFolderMETom.getValue();
                        if (instFolderTom.endsWith("\\")) {
                            instFolderTom = instFolderTom.substring(0, instFolderTom.length() - 1);
                        }
                        if ((instFolderAWT = ConfigurationPage.this.instFolderMEAWT.getValue()).endsWith("\\")) {
                            instFolderAWT = instFolderAWT.substring(0, instFolderAWT.length() - 1);
                        }
                        String toolsjar = ConfigurationPage.this.toolsjarField.getValue();
                        monitor.worked(1);
                        try {
                            MDKInstallation mdkinstall = MDKInstallation.getInstance();
                            mdkinstall.setIrjPort(port);
                            mdkinstall.setIrjServerName(servername);
                            mdkinstall.setIrjWebappName(webappName);
                            mdkinstall.setInstFolderMETom(instFolderTom);
                            mdkinstall.setInstFolderMEAWT(instFolderAWT);
                            IDESettings iset = IDESettings.getInstance();
                            iset.setInvokeBrowserCmd(browserInvokeCmd);
                            iset.setToolsjar(toolsjar);
                            iset.setUserName(userName);
                            iset.setPassword(password);
                            MIPlugin.getDefault().savePluginPreferences();
                            monitor.worked(1);
                            mdkinstall.updateIrjWebappFileHome();
                            mdkinstall.updateInstalledServicesOnDisk();
                            mdkinstall.doSave();
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            JavaPlugin.log((Throwable)e);
                            ConfigurationPage.this.status = false;
                            ConfigurationPage.this.statusType = e.getClass().getName();
                            ConfigurationPage.this.statusMessage = e.getMessage();
                        }
                    }
                };
                try {
                    pmd.run(false, false, runnable);
                }
                catch (Exception e) {
                    JavaPlugin.log((Throwable)e);
                    this.status = false;
                    this.statusType = e.getClass().getName();
                    this.statusMessage = e.getMessage();
                }
                if (!this.status) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An error occurred while trying to adopt the new settings.\nError type: \"" + this.statusType + "\"\nError message: \"" + this.statusMessage + "\"\n\nPlease check your settings again.\n(Note: The PDK must be running to update the settings!)"));
                }
            }
        }
        return this.status;
    }

    protected void initialize() {
    }

    private void testSettings() {
        Cursor c = new Cursor((Device)this.getShell().getDisplay(), 1);
        this.getShell().setCursor(c);
        boolean connectionPossible = false;
        int port = this.tcpPortField.getIntValue();
        String servername = this.serveraddressField.getStringValue();
        String webappName = this.webappnameField.getStringValue();
        String instMe = this.instFolderMETom.getValue();
        String toolsjar = this.toolsjarField.getValue();
        String toolsjarmessage = null;
        toolsjarmessage = Files.doesFileExist(toolsjar) ? "'" + toolsjar + "' found" : "'" + toolsjar + "' NOT found. Please correct setting !";
        String urlToPDK = null;
        try {
            MDKInstallation mdkinstall = MDKInstallation.getInstance();
            mdkinstall.setIrjPort(port);
            mdkinstall.setIrjServerName(servername);
            mdkinstall.setIrjWebappName(webappName);
            urlToPDK = mdkinstall.getMERootURL();
            if (mdkinstall.isServerReachable()) {
                mdkinstall.updateIrjWebappFileHome();
                mdkinstall.doSave();
                connectionPossible = true;
            } else {
                mdkinstall.reload();
                connectionPossible = false;
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (!connectionPossible) {
            urlToPDK = "http://www.sap.com";
        }
        String openBrowserCmdLine = this.invokeBrowserCommandLineField.getStringValue();
        boolean openBrowserPossible = false;
        connectionPossible = false;
        ProjectLaunchConfigurationDelegate proLaunch = new ProjectLaunchConfigurationDelegate();
        MDKInstallation pdkinstall = null;
        try {
            pdkinstall = MDKInstallation.getInstance();
        }
        catch (Throwable e) {
            JavaPlugin.log((Throwable)e);
        }
        if (instMe.length() >= 1) {
            pdkinstall.setInstFolderMETom(instMe);
            try {
                proLaunch.mdkStop(null, null, pdkinstall, true);
            }
            catch (Throwable e) {
                JavaPlugin.log((Throwable)e);
            }
            try {
                proLaunch.mdkStart(null, null, pdkinstall, true);
                connectionPossible = true;
            }
            finally {
                int justInCaseCounter = 0;
            }
        }
        toolsjarmessage = toolsjarmessage + "\nME Installation folder missing";
        connectionPossible = false;
        c.dispose();
        c = new Cursor((Device)this.getShell().getDisplay(), 0);
        this.getShell().setCursor(c);
        String connectionMessage = null;
        String openBrowserMessage = null;
        int messageImageType = connectionPossible && openBrowserPossible ? 2 : 4;
        connectionMessage = connectionPossible ? "Connection to MI successful." : "Connection to MI could not be established.";
        openBrowserMessage = openBrowserPossible ? "Invoking browser was successful." : "Invoking browser caused problems.";
        String messageText = toolsjarmessage + "\n" + connectionMessage + "\n" + openBrowserMessage;
        MessageDialog md = new MessageDialog(this.getShell(), "Connection Test", null, messageText, messageImageType, new String[]{"OK"}, 0);
        md.open();
        try {
            proLaunch.mdkStop(null, null, pdkinstall, true);
        }
        catch (CoreException e1) {
            JavaPlugin.log((Throwable)e1);
        }
        catch (IOException e1) {
            JavaPlugin.log((Throwable)e1);
        }
    }

    protected void performDefaults() {
        this.initFieldsToFormerValues();
    }

    protected void initFieldsToFormerValues() {
        try {
            MDKInstallation mdkinstall = MDKInstallation.getInstance();
            mdkinstall.reload();
            this.serveraddressField.setStringValue(mdkinstall.getIrjServerName());
            this.webappnameField.setStringValue(mdkinstall.getIrjWebappName());
            this.tcpPortField.setStringValue(String.valueOf(mdkinstall.getIrjPort()));
            this.instFolderMETom.setValue(mdkinstall.getInstFolderMETom());
            this.instFolderMEAWT.setValue(mdkinstall.getInstFolderMEAWT());
            IDESettings iset = IDESettings.getInstance();
            this.invokeBrowserCommandLineField.setStringValue(iset.getInvokeBrowserCmd());
            this.toolsjarField.setValue(iset.getToolsjar());
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return MIPlugin.getDefault().getPreferenceStore();
    }

    public static void storeSettings(String name, String pwd, String browser, String server, String url) {
        try {
            Files.writeFile(ConfigurationPage.getUserDir() + "Logon.out", name + "~" + pwd + "~" + browser + "~" + server + "~" + url + "~");
        }
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private static String getUserDir() {
        String dir = System.getProperty("user.home");
        if (!dir.endsWith("\\")) {
            dir = dir + "\\";
        }
        return dir;
    }

    public static String[] getMDKParams() {
        String[] out = new String[2];
        String input = null;
        try {
            input = Files.readFile(ConfigurationPage.getUserDir() + "Logon.out");
        }
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
        }
        out[0] = "";
        out[1] = "";
        if (input != null && input.length() != 0) {
            out[0] = input.substring(0, input.indexOf("~"));
            input = input.substring(input.indexOf("~") + 1);
            out[1] = input.substring(0, input.indexOf("~"));
        }
        return out;
    }

    public static String getMEInstallFolderTom() {
        String inst = "";
        try {
            MDKInstallation mdkinstall = MDKInstallation.getInstance();
            mdkinstall.reload();
            inst = mdkinstall.getInstFolderMETom();
            if (inst == null) {
                inst = "";
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return inst;
    }

    public static String getMEInstallFolderAWT() {
        String inst = "";
        try {
            MDKInstallation mdkinstall = MDKInstallation.getInstance();
            mdkinstall.reload();
            inst = mdkinstall.getInstFolderMEAWT();
            if (inst == null) {
                inst = "";
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return inst;
    }

    private int isValidMIFolder(String folder, boolean jspApp) {
        int isF = -1;
        String chFolder = folder.replace('\\', '/');
        MDKInstallation mdkinstall = null;
        try {
            mdkinstall = MDKInstallation.getInstance();
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        String runtime = mdkinstall.getMIConfigValue(folder, "Runtime", jspApp);
        if (jspApp && runtime.equalsIgnoreCase("tomcat")) {
            isF = 0;
        }
        if (!jspApp && runtime.equalsIgnoreCase("awt")) {
            isF = 0;
        }
        if (!chFolder.endsWith("/")) {
            chFolder = chFolder + "/";
        }
        if (jspApp && Files.doesFileExist(chFolder + "startup.bat")) {
            File batFile = new File(chFolder + "startup.bat");
            try {
                String jHome = Files.findVariableinBatFile(batFile, "SET JAVA_HOME", false, false);
                isF = 1;
                if (jHome != null && (jHome = jHome.substring(jHome.indexOf("=") + 1).trim()).length() > 1) {
                    if (!(jHome = jHome.replace('\\', '/')).endsWith("/")) {
                        jHome = jHome + "/";
                    }
                    if (Files.doesFileExist(jHome + "lib/tools.jar")) {
                        this.toolsjarField.setValue(jHome + "lib/tools.jar");
                        isF = 2;
                    }
                }
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
                return isF;
            }
        }
        return isF;
    }

    private void updateToolsjarFieldVisibility(String folder) {
        if (folder.length() > 1) {
            int status = this.isValidMIFolder(folder, true);
            boolean toolsJarVis = false;
            this.settingsJSPOK = true;
            if (status == 1) {
                toolsJarVis = true;
            }
            if (status < 0) {
                toolsJarVis = true;
                this.settingsJSPOK = false;
                if (this.testButton != null) {
                    this.testButton.setEnabled(false);
                }
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"This is not a valid root folder for MI Client - Tomcat runtime.\nPossible reasons:\n - The MI Client installation did not finish successfully.\n - The runtime of the MI Client does not match.");
            } else if (this.testButton != null) {
                this.testButton.setEnabled(true);
            }
            this.toolsjarField.setEnabled(toolsJarVis);
            if (!toolsJarVis) {
                this.toolsjarField.getTextField().setBackground(this.disabledBackground);
            } else {
                this.toolsjarField.getTextField().setBackground(this.standardBackground);
            }
        }
    }
}

