/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.common;

import com.sap.ip.me.mdk.developmentTools.general.AbstractProfiles;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.SAPImageDescriptors;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.common.SpecifyClassAndProfilePage;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.newGenericWizard.IPDKCustomComponentWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public abstract class OneClassMasterIViewWizard
extends Wizard
implements IPDKCustomComponentWizard {
    protected SpecifyClassAndProfilePage myPage;
    protected IProject project;
    protected AbstractProfiles profiles;
    private String title;
    private String description;
    protected final String templateLocation;
    private String infopopID;

    public OneClassMasterIViewWizard(String title, String description, String templateLocation, String infopopID) {
        this.setDefaultPageImageDescriptor(SAPImageDescriptors.SAP_LOGO);
        this.setNeedsProgressMonitor(true);
        this.title = title;
        this.description = description;
        this.templateLocation = templateLocation;
        this.infopopID = infopopID;
    }

    public void setCurrentProject(IProject project) {
        this.project = project;
        if (this.myPage != null) {
            this.myPage.setProject(project);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProfiles(AbstractProfiles profiles) {
        this.profiles = profiles;
        if (this.myPage != null) {
            this.myPage.setProfiles(profiles);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.project = (IProject)selection.getFirstElement();
    }

    public void addPages() {
        this.myPage = new SpecifyClassAndProfilePage(this.title, this.description, this.infopopID);
        this.myPage.setProject(this.project);
        this.myPage.setProfiles(this.profiles);
        this.addPage((IWizardPage)this.myPage);
    }

    protected abstract void doProfileTasks();

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Processing request", 2);
                monitor.subTask("Saving profiles");
                OneClassMasterIViewWizard.this.doProfileTasks();
                try {
                    OneClassMasterIViewWizard.this.profiles.doSave();
                }
                catch (Exception e) {
                    JavaPlugin.log((Throwable)e);
                    MessageDialog.openWarning((Shell)OneClassMasterIViewWizard.this.getShell(), (String)"Warning", (String)"Couldn't save the profiles. Any changes to the profiles will be lost.");
                }
                monitor.worked(1);
                monitor.subTask("Creating .java file");
                HashMap<String, String> templateMap = new HashMap<String, String>();
                templateMap.put("package", OneClassMasterIViewWizard.this.myPage.getPackageName());
                templateMap.put("class-name", OneClassMasterIViewWizard.this.myPage.getClassName());
                try {
                    MIPlugin.createJavaFileFromXMLTemplateAndOpenIt(OneClassMasterIViewWizard.this.project, OneClassMasterIViewWizard.this.myPage.getFullyQualifiedClassName(), OneClassMasterIViewWizard.this.templateLocation, templateMap);
                }
                catch (Exception e) {
                    JavaPlugin.log((Throwable)e);
                    MessageDialog.openWarning((Shell)OneClassMasterIViewWizard.this.getShell(), (String)"Error", (String)"Couldn't create .java file.");
                }
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return true;
    }
}

