/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.impl;

import com.sap.ip.me.mdk.developmentTools.general.api.StringBasedFileFilter;
import com.sap.ip.me.mdk.developmentTools.general.iDE.AbstractIDE;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;

public class Eclipse2IDE
extends AbstractIDE {
    private static QualifiedName ADDED_LIBS_QNAME = new QualifiedName((class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE == null ? (class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE = Eclipse2IDE.class$("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE")) : class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE).getName(), "addedLibraries");
    private static QualifiedName OUTPATHS_QNAME = new QualifiedName((class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE == null ? (class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE = Eclipse2IDE.class$("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE")) : class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE).getName(), "project_outpaths");
    private static QualifiedName SRCPATHS_QNAME = new QualifiedName((class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE == null ? (class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE = Eclipse2IDE.class$("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE")) : class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE).getName(), "project_srcpaths");
    private static final String PATHS_DELIMITER = ",";
    private ArrayList srcPaths = new ArrayList();
    private ArrayList outPaths = new ArrayList();
    static /* synthetic */ Class class$com$sap$ip$me$mdk$developmentTools$ideSpecific$eclipse$impl$Eclipse2IDE;
    static /* synthetic */ Class class$org$eclipse$ui$part$ISetSelectionTarget;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public String getCurrentProjectFolder(Object project) {
        IProject currentProject = (IProject)project;
        if (currentProject == null) {
            return null;
        }
        return currentProject.getLocation().toFile().getAbsolutePath();
    }

    public String getProjectName(Object project) {
        return ((IProject)project).getName();
    }

    private IFolder createFolderInProject(String[] nameSegments, IProject project) throws Exception {
        if (nameSegments == null || nameSegments.length < 1) {
            return null;
        }
        IFolder folder = null;
        int i = 0;
        while (i < nameSegments.length) {
            folder = i == 0 ? project.getFolder(nameSegments[0]) : folder.getFolder(nameSegments[i]);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            ++i;
        }
        return folder;
    }

    private boolean deleteFolderInProject(String nameSegments, IProject project) throws Exception {
        if (nameSegments == null || nameSegments.length() < 1) {
            return false;
        }
        IFolder folder = null;
        folder = project.getFolder(nameSegments);
        if (folder.exists()) {
            folder.delete(true, true, null);
        }
        return true;
    }

    public File createFileInProject(Object project, String[] nameSegments, boolean visible) throws Exception {
        IProject iProject = (IProject)project;
        IFile file = null;
        if (nameSegments == null || nameSegments.length < 1) {
            return null;
        }
        if (nameSegments.length == 1) {
            file = iProject.getFile((IPath)new Path(nameSegments[0]));
        } else {
            IFolder folder = iProject.getFolder(nameSegments[0]);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            int i = 1;
            while (i < nameSegments.length - 1) {
                if (!(folder = folder.getFolder(nameSegments[i])).exists()) {
                    folder.create(true, true, null);
                }
                ++i;
            }
            file = folder.getFile(nameSegments[nameSegments.length - 1]);
        }
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(new byte[]{20}), true, null);
        }
        return new File(file.getLocation().toOSString());
    }

    public boolean deleteFileFromProject(Object project, String[] nameSegments) throws IOException {
        File now = new File(this.getCurrentProjectFolder(project));
        int i = 0;
        while (i < nameSegments.length) {
            now = new File(now, nameSegments[i]);
            ++i;
        }
        return now.delete();
    }

    public File getFileObjectFor(Object project, String[] nameSegments) throws IOException {
        File now = new File(this.getCurrentProjectFolder(project));
        int i = 0;
        while (i < nameSegments.length) {
            now = new File(now, nameSegments[i]);
            ++i;
        }
        return now;
    }

    public List getEmptyFoldersInProject(Object project, StringBasedFileFilter fileFilter, StringBasedFileFilter recursionFilter) throws IOException {
        ArrayList retVal = new ArrayList();
        String currentProjectFolder = this.getCurrentProjectFolder(project);
        if (currentProjectFolder != null) {
            this.getEmptyFoldersInProjectHelper(retVal, new String[0], new File(currentProjectFolder), fileFilter, recursionFilter);
        }
        return retVal;
    }

    private void getEmptyFoldersInProjectHelper(List toAddTo, String[] folderName, File folderNow, StringBasedFileFilter fileFilter, StringBasedFileFilter recursionFilter) throws IOException {
        File[] children = folderNow.listFiles();
        if (children.length == 0) {
            String[] nameSegsNow = new String[folderName.length];
            System.arraycopy(folderName, 0, nameSegsNow, 0, folderName.length);
            if (fileFilter.accept(nameSegsNow, true)) {
                toAddTo.add(nameSegsNow);
            }
        } else {
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                String[] nameSegsNow = new String[folderName.length + 1];
                System.arraycopy(folderName, 0, nameSegsNow, 0, folderName.length);
                nameSegsNow[nameSegsNow.length - 1] = child.getName();
                boolean isDir = child.isDirectory();
                if (isDir && recursionFilter.accept(nameSegsNow, true)) {
                    this.getEmptyFoldersInProjectHelper(toAddTo, nameSegsNow, child, fileFilter, recursionFilter);
                }
                ++i;
            }
        }
    }

    public List getAllFilesInProject(Object project, StringBasedFileFilter fileFilter, StringBasedFileFilter recursionFilter) throws IOException {
        ArrayList retVal = new ArrayList();
        String currentProjectFolder = this.getCurrentProjectFolder(project);
        if (currentProjectFolder != null) {
            this.getAllFilesInProjectHelper(retVal, new String[0], new File(currentProjectFolder), fileFilter, recursionFilter);
        }
        return retVal;
    }

    private void getAllFilesInProjectHelper(List toAddTo, String[] folderName, File folderNow, StringBasedFileFilter fileFilter, StringBasedFileFilter recursionFilter) throws IOException {
        File[] children = folderNow.listFiles();
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            String[] nameSegsNow = new String[folderName.length + 1];
            System.arraycopy(folderName, 0, nameSegsNow, 0, folderName.length);
            nameSegsNow[nameSegsNow.length - 1] = child.getName();
            boolean isDir = child.isDirectory();
            if (fileFilter.accept(nameSegsNow, isDir)) {
                toAddTo.add(nameSegsNow);
            }
            if (isDir && recursionFilter.accept(nameSegsNow, true)) {
                this.getAllFilesInProjectHelper(toAddTo, nameSegsNow, child, fileFilter, recursionFilter);
            }
            ++i;
        }
    }

    protected void defineFullProjectClasspath(Object project, List jarFiles, boolean newClassPath) throws Exception {
        IProject currentProject = (IProject)project;
        this.defineFullProjectClasspath(currentProject, jarFiles, newClassPath);
    }

    private void defineFullProjectClasspath(IProject currentProject, List jarFiles, boolean newClassPath) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)currentProject);
        ArrayList<String> libsAddedByOurselfBefore = new ArrayList<String>();
        String alreadyAddedLibsPropertyString = currentProject.getPersistentProperty(ADDED_LIBS_QNAME);
        if (alreadyAddedLibsPropertyString != null) {
            StringTokenizer st = new StringTokenizer(alreadyAddedLibsPropertyString, ";");
            while (st.hasMoreTokens()) {
                String libPathNow = st.nextToken();
                libsAddedByOurselfBefore.add(libPathNow);
            }
        }
        ArrayList<IClasspathEntry> allClasspathEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] formerClassPathEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < formerClassPathEntries.length) {
            IClasspathEntry formerClassPathEntry = formerClassPathEntries[i];
            if (!newClassPath) {
                if (!libsAddedByOurselfBefore.contains(formerClassPathEntry.getPath().toString())) {
                    allClasspathEntries.add(formerClassPathEntry);
                }
            } else if (formerClassPathEntry.getContentKind() == 1) {
                allClasspathEntries.add(formerClassPathEntry);
            }
            ++i;
        }
        StringBuffer newLibsAddedByOurselfBeforePropertyString = new StringBuffer();
        Iterator iterator = jarFiles.iterator();
        if (iterator.hasNext()) {
            this.doFullClassPathSettingHelper((String)iterator.next(), newLibsAddedByOurselfBeforePropertyString, allClasspathEntries);
        }
        while (iterator.hasNext()) {
            newLibsAddedByOurselfBeforePropertyString.append(';');
            String fileName = iterator.next().toString();
            this.doFullClassPathSettingHelper(fileName, newLibsAddedByOurselfBeforePropertyString, allClasspathEntries);
        }
        IClasspathEntry[] rawPath = allClasspathEntries.toArray(new IClasspathEntry[allClasspathEntries.size()]);
        try {
            javaProject.setRawClasspath(rawPath, null);
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
        }
        currentProject.setPersistentProperty(ADDED_LIBS_QNAME, newLibsAddedByOurselfBeforePropertyString.toString());
    }

    private void doFullClassPathSettingHelper(String fileName, StringBuffer newLibsAddedByOurselfBeforePropertyString, ArrayList allClasspathEntries) {
        File file = new File(fileName);
        Path path = new Path(file.getAbsolutePath());
        newLibsAddedByOurselfBeforePropertyString.append(path.toString());
        IClasspathEntry classpathEntry = JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)false);
        allClasspathEntries.add(classpathEntry);
    }

    public void openFileInEditor(Object project, String[] fileNameSegments) throws Exception {
        IProject iProject = (IProject)project;
        String projectRelativeFileName = this.fileNameSegsToRelativeName(fileNameSegments);
        IFile theIFile = iProject.getFile((IPath)new Path(projectRelativeFileName));
        MIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(theIFile);
    }

    public boolean rebuildCurrentProject(Object project, int[] srcPaths, int targetOutPath) {
        try {
            IProject iProject = (IProject)project;
            iProject.refreshLocal(2, null);
            iProject.build(6, null);
            iProject.refreshLocal(2, null);
            IMarker[] markers = iProject.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int i = 0;
            while (i < markers.length) {
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
            return false;
        }
    }

    public int getOutPathCount(Object project) throws Exception {
        String storedOutpaths = ((IProject)project).getPersistentProperty(OUTPATHS_QNAME);
        if (storedOutpaths != null) {
            return new StringTokenizer(storedOutpaths, PATHS_DELIMITER).countTokens();
        }
        return 0;
    }

    public String getProjectOutPath(Object project, int outPathIndex) throws Exception {
        IProject iProject = (IProject)project;
        String storedOutpaths = iProject.getPersistentProperty(OUTPATHS_QNAME);
        int outPathCount = this.getOutPathCount(iProject);
        if (outPathIndex >= outPathCount) {
            storedOutpaths = "classes";
            IDESettings is = IDESettings.getInstance();
            if (is.isJspApplication()) {
                storedOutpaths = "app-root/WEB-INF/classes";
            }
        }
        return storedOutpaths;
    }

    public File getOutPath(Object project, int outPathIndex) throws Exception {
        IProject iProject = (IProject)project;
        String storedOutpaths = this.getProjectOutPath(project, outPathIndex);
        StringTokenizer tokenizer = new StringTokenizer(storedOutpaths, PATHS_DELIMITER);
        int i = 0;
        while (i < outPathIndex) {
            tokenizer.nextToken();
            ++i;
        }
        return new File(this.getCurrentProjectFolder(iProject), tokenizer.nextToken());
    }

    public String getOutPathRelative(Object project, int outPathIndex) throws Exception {
        IProject iProject = (IProject)project;
        String storedOutpaths = this.getProjectOutPath(project, outPathIndex);
        StringTokenizer tokenizer = new StringTokenizer(storedOutpaths, PATHS_DELIMITER);
        int i = 0;
        while (i < outPathIndex) {
            tokenizer.nextToken();
            ++i;
        }
        return tokenizer.nextToken();
    }

    public int getSourcePathCount(Object project) throws Exception {
        IJavaProject jProject = Eclipse2IDE.getCurrentJavaProject(project);
        if (jProject == null) {
            throw new Exception("Current project (" + project + ") is not a Java Project");
        }
        IClasspathEntry[] entries = jProject.getRawClasspath();
        int count = 0;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public File getSrcPath(Object project, int srcPathIndex) throws Exception {
        IJavaProject jProject = Eclipse2IDE.getCurrentJavaProject(project);
        if (jProject == null) {
            throw new Exception("Current project (" + project + ") is not a Java Project");
        }
        IClasspathEntry[] entries = jProject.getRawClasspath();
        IClasspathEntry entry = null;
        int i = 0;
        while (i < entries.length && srcPathIndex >= 0) {
            entry = entries[i];
            if (entry.getEntryKind() == 3) {
                --srcPathIndex;
            }
            ++i;
        }
        if (entry != null) {
            String[] segs = entry.getPath().segments();
            String[] projRelSegs = new String[segs.length - 1];
            System.arraycopy(segs, 1, projRelSegs, 0, projRelSegs.length);
            return this.getFileObjectFor(project, projRelSegs);
        }
        return null;
    }

    public void updateProjectFromFilesSystem(Object project, StringBasedFileFilter exclusionFilter) throws IOException {
        IProject iProject = (IProject)project;
        try {
            if (iProject != null) {
                iProject.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public File getUserDirectory() {
        return new File(System.getProperty("user.home"));
    }

    public File createJavaSourceFileInCurrentProject(Object project, String fqClassName, int sourcePathIndex) throws Exception {
        File sourcePath = this.getSrcPath(project, sourcePathIndex);
        String fileNameRelativeToSourcePath = fqClassName.replace('.', File.separatorChar) + ".java";
        File javaFile = new File(sourcePath, fileNameRelativeToSourcePath);
        this.createFileInProject(project, this.getSegmentsForFile(project, javaFile), false);
        JavaCore.create((IFile)((IProject)project).getFile(javaFile.getAbsolutePath()));
        return javaFile;
    }

    public File createAnyFileInCurrentProject(Object project, String fqClassName, String sourcePath, int sourcePathIndex) throws Exception {
        String fileNameRelativeToSourcePath = fqClassName;
        File anyFile = new File(sourcePath, fileNameRelativeToSourcePath);
        this.createFileInProject(project, this.getSegmentsForFile(project, anyFile), false);
        JavaCore.create((IFile)((IProject)project).getFile(anyFile.getAbsolutePath()));
        return anyFile;
    }

    private int addSrcPathInProject(String[] srcPathFolderNameSegments, IJavaProject jProject) throws Exception {
        if (jProject == null || srcPathFolderNameSegments == null || srcPathFolderNameSegments.length == 0) {
            throw new Exception("Parameters can't be null or empty!");
        }
        IFolder folder = this.createFolderInProject(srcPathFolderNameSegments, jProject.getProject());
        IClasspathEntry[] oldEntries = jProject.getRawClasspath();
        boolean exists = false;
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].getPath().toString().equals(folder.getFullPath().toString())) {
                exists = true;
            }
            ++i;
        }
        int add = 0;
        if (!exists) {
            add = 1;
        }
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + add];
        int i2 = 0;
        while (i2 < oldEntries.length) {
            newEntries[i2] = oldEntries[i2];
            ++i2;
        }
        if (!exists) {
            IClasspathEntry sourceEntry;
            newEntries[newEntries.length - 1] = sourceEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
            jProject.setRawClasspath(newEntries, null);
        }
        return newEntries.length;
    }

    private void removeSrcPathInProject(String srcPathFolderNameSegments, IJavaProject jProject) throws Exception {
        if (jProject == null || srcPathFolderNameSegments == null || srcPathFolderNameSegments.length() == 0) {
            throw new Exception("Parameters can't be null or empty!");
        }
        boolean ok = this.deleteFolderInProject(srcPathFolderNameSegments, jProject.getProject());
        IFolder folder = jProject.getProject().getFolder(srcPathFolderNameSegments);
        String srcPathFullName = folder.getFullPath().toString();
        IClasspathEntry[] oldEntries = jProject.getRawClasspath();
        boolean exists = false;
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].getPath().toString().equals(srcPathFullName)) {
                exists = true;
            }
            ++i;
        }
        if (exists) {
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length - 1];
            int j = 0;
            int i2 = 0;
            while (i2 < oldEntries.length) {
                if (!oldEntries[i2].getPath().toString().equals(srcPathFullName)) {
                    newEntries[j] = oldEntries[i2];
                    ++j;
                }
                ++i2;
            }
            jProject.setRawClasspath(newEntries, null);
        }
    }

    public int addSrcPathInProject(Object project, String[] srcPathFolderNameSegments) throws Exception {
        return this.addSrcPathInProject(srcPathFolderNameSegments, Eclipse2IDE.getCurrentJavaProject(project));
    }

    public void removeSrcPathInProject(Object project, String srcPathFolderNameSegments) throws Exception {
        this.removeSrcPathInProject(srcPathFolderNameSegments, Eclipse2IDE.getCurrentJavaProject(project));
    }

    private int addOutPathInProject(String[] outPathFolderNameSegments, IJavaProject jProject) throws Exception {
        if (jProject == null || outPathFolderNameSegments == null || outPathFolderNameSegments.length == 0) {
            throw new Exception("Parameters can't be null or empty!");
        }
        String storedOutpaths = jProject.getProject().getPersistentProperty(OUTPATHS_QNAME);
        this.createFolderInProject(outPathFolderNameSegments, jProject.getProject());
        if (storedOutpaths == null || storedOutpaths.equals("")) {
            storedOutpaths = this.concatFolderSegments(outPathFolderNameSegments);
            IPath newPath = jProject.getProject().getFolder(this.concatFolderSegments(outPathFolderNameSegments)).getFullPath();
            jProject.setOutputLocation(newPath, null);
        } else {
            storedOutpaths = storedOutpaths + PATHS_DELIMITER + this.concatFolderSegments(outPathFolderNameSegments);
        }
        jProject.getProject().setPersistentProperty(OUTPATHS_QNAME, storedOutpaths);
        StringTokenizer t = new StringTokenizer(storedOutpaths, PATHS_DELIMITER);
        return t.countTokens();
    }

    public int addOutPathInProject(Object project, String[] outPathFolderNameSegments) throws Exception {
        return this.addOutPathInProject(outPathFolderNameSegments, Eclipse2IDE.getCurrentJavaProject(project));
    }

    private String fileNameSegsToRelativeName(String[] segments) {
        StringBuffer sb = new StringBuffer();
        sb.append(segments[0]);
        int i = 1;
        while (i < segments.length) {
            sb.append('/');
            sb.append(segments[i]);
            ++i;
        }
        return sb.toString();
    }

    private String concatFolderSegments(String[] segments, int count) {
        StringBuffer result = new StringBuffer();
        int min = Math.min(segments.length, count);
        int i = 0;
        while (i < min) {
            if (i == 0) {
                result.append(segments[0]);
            } else {
                result.append("/").append(segments[i]);
            }
            ++i;
        }
        return result.toString();
    }

    private String concatFolderSegments(String[] segments) {
        return this.concatFolderSegments(segments, segments.length);
    }

    public void addServiceNatureToProject(IProject project) {
    }

    public Object prepareNewProject(File projectRootFolder, String[] initialSrcPathFolderNameSegments, String[] initialOutPathFolderNameSegments) throws Exception {
        return this.prepareNewProject(projectRootFolder, initialSrcPathFolderNameSegments, initialOutPathFolderNameSegments, false);
    }

    public Object prepareNewProject(File projectRootFolder, String[] initialSrcPathFolderNameSegments, String[] initialOutPathFolderNameSegments, boolean isServiceProject) throws Exception {
        String[] nature;
        File rootRootFolder;
        Path projectLocation = new Path(projectRootFolder.getAbsolutePath());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File defaultWorkspaceRootRootFolder = new File(workspace.getRoot().getLocation().toString());
        if (defaultWorkspaceRootRootFolder.equals(rootRootFolder = projectRootFolder.getParentFile())) {
            projectLocation = null;
        }
        IProject project = workspace.getRoot().getProject(projectRootFolder.getName());
        IProjectDescription desc = workspace.newProjectDescription("SAPmi Project");
        desc.setLocation((IPath)projectLocation);
        if (isServiceProject) {
            nature = new String[]{"org.eclipse.jdt.core.javanature", MIPlugin.getMINatureID()};
            desc.setNatureIds(nature);
        } else {
            nature = new String[]{"org.eclipse.jdt.core.javanature", MIPlugin.getMINatureID(), MIPlugin.getServiceNatureID()};
            desc.setNatureIds(nature);
        }
        if (!project.exists()) {
            project.create(desc, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        String name = project.getName();
        String fullpath = project.getFullPath().toOSString();
        String location = project.getLocation().toOSString();
        this.createFolderInProject(initialSrcPathFolderNameSegments, project);
        this.createFolderInProject(initialOutPathFolderNameSegments, project);
        IJavaProject jProject = JavaCore.create((IProject)project);
        fullpath = jProject.getProject().getFullPath().toOSString();
        location = jProject.getProject().getLocation().toOSString();
        this.addOutPathInProject(initialOutPathFolderNameSegments, jProject);
        IClasspathEntry sourceEntry = JavaCore.newSourceEntry((IPath)jProject.getPath().append(this.concatFolderSegments(initialSrcPathFolderNameSegments)));
        IClasspathEntry jreLibEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
        IClasspathEntry[] entries = new IClasspathEntry[]{sourceEntry, jreLibEntry};
        jProject.setRawClasspath(entries, null);
        IProjectDescription d = jProject.getProject().getDescription();
        ICommand builder = d.newCommand();
        builder.setBuilderName("org.eclipse.jdt.core.javabuilder");
        ICommand[] buildSpec = new ICommand[]{builder};
        d.setBuildSpec(buildSpec);
        jProject.getProject().setDescription(d, null);
        Eclipse2IDE.selectAndReveal((IResource)jProject.getProject(), MIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
        return project;
    }

    public List getAllNonAbstractClassesDerivedFromInCurrentProject(Object project, String fullyQualifiedName) {
        ArrayList<String> retVal = new ArrayList<String>();
        IJavaProject iProject = Eclipse2IDE.getCurrentJavaProject(project);
        try {
            IType type = iProject.findType(fullyQualifiedName);
            IRegion region = JavaCore.newRegion();
            region.add((IJavaElement)type);
            IClasspathEntry[] classpath = iProject.getResolvedClasspath(true);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry iClasspathEntry = classpath[i];
                if (iClasspathEntry.getEntryKind() == 3) {
                    IPackageFragmentRoot[] packageFragmentRoots = iProject.getPackageFragmentRoots(iClasspathEntry);
                    int j = 0;
                    while (j < packageFragmentRoots.length) {
                        region.add((IJavaElement)packageFragmentRoots[j]);
                        ++j;
                    }
                }
                ++i;
            }
            ITypeHierarchy hierarchy = iProject.newTypeHierarchy(region, null);
            IType[] classes = hierarchy.getAllSubtypes(type);
            int i2 = 0;
            while (i2 < classes.length) {
                boolean isNotDirectlyInstantiableInnerMember;
                IType aClass = classes[i2];
                int flags = aClass.getFlags();
                boolean isAbstract = (flags & 0x400) == 1024;
                boolean isProtected = (flags & 4) == 4;
                boolean bl = isNotDirectlyInstantiableInnerMember = aClass.isMember() || (flags & 8) == 8;
                if (!isAbstract && !isProtected && isNotDirectlyInstantiableInnerMember) {
                    retVal.add(aClass.getFullyQualifiedName());
                }
                ++i2;
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return retVal;
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        if (resource instanceof IProject) {
            try {
                IProject ppp = (IProject)resource;
                IResource[] members = ppp.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IFolder) {
                        resource = members[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        ArrayList<Object> partReferences = new ArrayList<Object>();
        partReferences.addAll(Arrays.asList(page.getViewReferences()));
        partReferences.addAll(Arrays.asList(page.getEditorReferences()));
        Iterator iterator = partReferences.iterator();
        while (iterator.hasNext()) {
            IWorkbenchPartReference reference = (IWorkbenchPartReference)iterator.next();
            IWorkbenchPart part = reference.getPart(false);
            if (part == null) continue;
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(class$org$eclipse$ui$part$ISetSelectionTarget == null ? Eclipse2IDE.class$("org.eclipse.ui.part.ISetSelectionTarget") : class$org$eclipse$ui$part$ISetSelectionTarget);
            if (target == null) continue;
            ISetSelectionTarget finalTarget = target;
            finalTarget.selectReveal((ISelection)selection);
        }
    }

    public static IJavaProject getCurrentJavaProject(Object project) {
        return JavaCore.create((IProject)((IProject)project));
    }

    public static IProject getCurrentProject() {
        IResource selectedResource;
        IStructuredSelection selection;
        try {
            selection = (IStructuredSelection)MIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.ui.views.ResourceNavigator");
            selectedResource = (IResource)selection.getFirstElement();
            if (selectedResource != null) {
                return selectedResource.getProject();
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        try {
            selection = (IStructuredSelection)MIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.jdt.ui.PackageExplorer");
            selectedResource = (IJavaElement)selection.getFirstElement();
            if (selectedResource != null) {
                return (IProject)selectedResource.getJavaProject().getAdapter(class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = Eclipse2IDE.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject);
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        ISelection simple = MIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        try {
            IAdaptable adaptable;
            IResource res;
            Object o;
            if (simple instanceof IStructuredSelection && (o = ((IStructuredSelection)simple).getFirstElement()) != null && o instanceof IAdaptable && (res = (IResource)(adaptable = (IAdaptable)o).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = Eclipse2IDE.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) != null) {
                return res.getProject();
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

