/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.documentationTools.documentationLauncher;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.AppserverPlugin;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.eclipse.help.internal.appserver.PluginClassLoaderWrapper;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class LaunchAppserver
implements IWebappServer {
    private static LaunchAppserver singletonInstance;
    private IWebappServer server;

    public static LaunchAppserver getInstance() throws Exception {
        if (singletonInstance == null) {
            singletonInstance = new LaunchAppserver();
        }
        return singletonInstance;
    }

    public void start(String webappName, String pluginId, IPath path) throws CoreException {
        IPath webappPath = LaunchAppserver.getWebappPath(pluginId, path);
        this.server = AppserverPlugin.getDefault().getAppServer();
        this.server.start(webappName, webappPath, (ClassLoader)new PluginClassLoaderWrapper(pluginId));
    }

    public void stop(String webappName) throws CoreException {
        AppserverPlugin.getDefault().getAppServer().stop(webappName);
    }

    public int getPort() {
        try {
            return AppserverPlugin.getDefault().getAppServer().getPort();
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
            return 0;
        }
    }

    public String getHost() {
        try {
            return AppserverPlugin.getDefault().getAppServer().getHost();
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
            return null;
        }
    }

    private static IPath getWebappPath(String pluginId, IPath path) throws CoreException {
        IPluginDescriptor descriptor = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
        if (descriptor == null) {
            throw new CoreException((IStatus)new Status(4, AppserverPlugin.getID(), 0, "MDK Documentation: CannotFindPlugin", null));
        }
        URL webappURL = descriptor.find(path);
        if (webappURL == null) {
            throw new CoreException((IStatus)new Status(4, AppserverPlugin.getID(), 0, "MDK Documentation: CannotResolvePlugin", null));
        }
        try {
            String webappLocation = Platform.resolve((URL)webappURL).getFile();
            return new Path(webappLocation);
        }
        catch (IOException ioe) {
            throw new CoreException((IStatus)new Status(4, AppserverPlugin.getID(), 0, "MDK Documentation: CannotResolvePlugin", (Throwable)ioe));
        }
    }

    public void start(int arg0, String arg1) throws CoreException {
    }

    public void stop() throws CoreException {
    }

    public boolean isRunning() {
        boolean res = false;
        if (this.server != null) {
            res = this.server.isRunning();
        }
        return res;
    }

    public void start(String arg0, IPath arg1, ClassLoader arg2) throws CoreException {
    }
}

