/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse;

import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.IPropertySystem;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.iDE.AbstractIDE;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.impl.Eclipse2IDE;
import com.sap.ip.me.mdk.util.Files;
import com.sap.ip.me.mdk.util.Templating;
import com.sap.ip.me.mdk.util.TemplatingTemplates;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MIPlugin
extends AbstractUIPlugin {
    public static final String THIS_PROP_GROUP = "com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.wizards.sapmakewar";
    public static final String PLUGIN_ID = "com.sap.ip.me.mdk.developmentTools";
    public static final String PLUGIN_FOLDER = "plugins";
    public static boolean PIOS_EMULATION_MODE = false;
    public static boolean lastLaunchWasJsp = false;
    private static MIPlugin plugin;
    private static final String MI_NATURE_RELATIVE_ID = "MIProjectNature";
    private static final String PORTAL_NATURE_RELATIVE_ID = "portalProjectNature";
    private static final String SERVICE_NATURE_RELATIVE_ID = "MIServiceProjectNature";
    private static final String CONFIGURATION_PAGE_ID = "com.sap.ip.me.mdk.developmentTools.configuration";
    public static final String SAP_LOGO = "sap_logo";
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;

    public MIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            OpentoolsFactory.init("com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.impl.EclipseOpentoolsFactory");
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public static String getConfigurationPageID() {
        return CONFIGURATION_PAGE_ID;
    }

    public static String getPluginID() {
        return MIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static String getPortalNatureID() {
        return MIPlugin.getPluginID() + "." + PORTAL_NATURE_RELATIVE_ID;
    }

    public static String getMINatureID() {
        return MIPlugin.getPluginID() + "." + MI_NATURE_RELATIVE_ID;
    }

    public static String getServiceNatureID() {
        return MIPlugin.getPluginID() + "." + SERVICE_NATURE_RELATIVE_ID;
    }

    public static String getPluginFolderString() {
        return MIPlugin.getEclipseFolder() + File.separator + PLUGIN_FOLDER + File.separator + PLUGIN_ID + "/";
    }

    public static URL getPluginURL() {
        String folder = MIPlugin.getPluginFolderString();
        folder = folder.replace('\\', '/');
        folder = "file:///" + folder;
        URL url = null;
        try {
            url = new URL(folder);
        }
        catch (MalformedURLException e) {
            JavaPlugin.log((Throwable)e);
        }
        return url;
    }

    public static String getEclipseFolder() {
        return JavaCore.getClasspathVariable((String)"ECLIPSE_HOME").toString();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        try {
            URL url = new URL(this.getDescriptor().getInstallURL(), "icons/SAP_logo.gif");
            reg.put(SAP_LOGO, ImageDescriptor.createFromURL((URL)url));
        }
        catch (MalformedURLException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public static MIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            JavaPlugin.log((Throwable)e);
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    public static List getAllMIProjectNamesInWorkspaceRoot(IWorkspaceRoot root) {
        List portalProjects = MIPlugin.getAllMIProjectsInWorkspaceRoot(root);
        ArrayList<String> retVal = new ArrayList<String>();
        Iterator iterator = portalProjects.iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            retVal.add(iProject.getName());
        }
        return retVal;
    }

    public static String getSelectedProject() {
        String selProject = null;
        try {
            IViewReference[] r = MIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int i = 0;
            while (i < r.length) {
                if (r[i].getId().compareTo("com.sap.ip.me.mdk.developmentTools.view") == 0) {
                    IWorkbenchPage page = r[i].getPage();
                    ISelection sel = page.getSelection();
                    if (!sel.isEmpty()) {
                        try {
                            IStructuredSelection iss = (IStructuredSelection)sel;
                            IJavaElement selectedResource = (IJavaElement)iss.getFirstElement();
                            if (selectedResource != null) {
                                selProject = selectedResource.getJavaProject().getProject().getName();
                            }
                        }
                        catch (RuntimeException e1) {
                            // empty catch block
                        }
                    }
                    return selProject;
                }
                ++i;
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return selProject;
    }

    public static List getAllMIProjectsInWorkspaceRoot(IWorkspaceRoot root) {
        String selProject = MIPlugin.getSelectedProject();
        ArrayList<IProject> retVal = new ArrayList<IProject>();
        try {
            IResource[] children = root.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                IProject iProject = child instanceof IProject ? (IProject)child : (IProject)child.getAdapter(class$org$eclipse$core$resources$IProject == null ? MIPlugin.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
                String tempString = null;
                if (iProject.isOpen()) {
                    IPropertySystem propSystem = OpentoolsFactory.getPropertySystemInstance();
                    try {
                        tempString = propSystem.loadProperty(THIS_PROP_GROUP, "isMDKProject", iProject);
                    }
                    catch (Exception e) {
                        JavaPlugin.log((Throwable)e);
                    }
                }
                boolean mdkproject = false;
                if (tempString != null) {
                    mdkproject = Boolean.valueOf(tempString);
                }
                if (mdkproject) {
                    retVal.add(iProject);
                } else if (iProject != null && iProject.isOpen() && iProject.getNature(MIPlugin.getMINatureID()) != null) {
                    retVal.add(iProject);
                } else if (selProject != null && iProject.getProject().getName().compareTo(selProject) == 0) {
                    retVal.add(iProject);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
        return retVal;
    }

    public static Set getAllFullyQualifiedClassNamesInProject(IProject project) throws JavaModelException {
        HashSet retVal = new HashSet();
        IJavaProject jProject = Eclipse2IDE.getCurrentJavaProject(project);
        IClasspathEntry[] classpath = jProject.getResolvedClasspath(true);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry iClasspathEntry = classpath[i];
            if (iClasspathEntry.getEntryKind() == 3) {
                IPackageFragmentRoot[] packageFragmentRoots = jProject.getPackageFragmentRoots(iClasspathEntry);
                int j = 0;
                while (j < packageFragmentRoots.length) {
                    MIPlugin.recurseIJavaElementAndAddElementNamesToList((IJavaElement)packageFragmentRoots[j], retVal);
                    ++j;
                }
            }
            ++i;
        }
        return retVal;
    }

    private static void recurseIJavaElementAndAddElementNamesToList(IJavaElement javaElement, Collection toAddTo) {
        switch (javaElement.getElementType()) {
            case 5: {
                try {
                    IType[] types = ((ICompilationUnit)javaElement).getAllTypes();
                    int i = 0;
                    while (i < types.length) {
                        IType type = types[i];
                        toAddTo.add(type.getFullyQualifiedName());
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((Throwable)e);
                }
                break;
            }
            case 4: {
                IPackageFragment iPackageFragment = (IPackageFragment)javaElement;
                toAddTo.add(iPackageFragment.getElementName());
                try {
                    IJavaElement[] children = iPackageFragment.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        MIPlugin.recurseIJavaElementAndAddElementNamesToList(children[i], toAddTo);
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((Throwable)e);
                }
                break;
            }
            case 3: {
                try {
                    IJavaElement[] children = ((IPackageFragmentRoot)javaElement).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        MIPlugin.recurseIJavaElementAndAddElementNamesToList(children[i], toAddTo);
                        ++i;
                    }
                    break;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((Throwable)e);
                }
            }
        }
    }

    public static void saveAllDirtyEditorsForProject(IProject project, IProgressMonitor monitor) {
        IWorkbenchWindow[] workbenchWindows = MIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindows.length) {
            IWorkbenchWindow workbenchWindow = workbenchWindows[i];
            IWorkbenchPage[] pages = workbenchWindow.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] dirtyEditors = page.getDirtyEditors();
                int k = 0;
                while (k < dirtyEditors.length) {
                    IEditorPart dirtyEditor = dirtyEditors[k];
                    IFile iFile = (IFile)dirtyEditor.getEditorInput().getAdapter(class$org$eclipse$core$resources$IFile == null ? MIPlugin.class$("org.eclipse.core.resources.IFile") : class$org$eclipse$core$resources$IFile);
                    if (iFile.getProject().equals((Object)project)) {
                        dirtyEditor.doSave(monitor);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void createJavaFileFromXMLTemplateAndOpenIt(IProject project, String fullyQualifiedClassName, String templateLocation, Map templateMap) throws Exception {
        URL pluginInstallURL = MIPlugin.getPluginURL();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        File beanClassFile = ideInstance.createJavaSourceFileInCurrentProject(project, fullyQualifiedClassName, 0);
        FileWriter beanClassWriter = new FileWriter(beanClassFile);
        InputStream templateStream = new URL(pluginInstallURL, templateLocation).openStream();
        Templating.writeTemplateToWriter(templateMap, templateStream, beanClassWriter);
        templateStream.close();
        beanClassWriter.close();
        String classFileAbsolutPath = beanClassFile.getAbsolutePath();
        String[] relBeanClassFileName = AbstractIDE.getFileNameSegmentsForSlashSeparatedFileName(classFileAbsolutPath.substring(projectPath.length(), classFileAbsolutPath.length()));
        ideInstance.openFileInEditor(project, relBeanClassFileName);
    }

    public static void createAnyFileFromXMLTemplateAndOpenIt(IProject project, String fullyQualifiedClassName, String templateLocation, Map templateMap) throws Exception {
        URL pluginInstallURL = MIPlugin.getPluginURL();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        File classFile = ideInstance.createAnyFileInCurrentProject(project, fullyQualifiedClassName, projectPath, 0);
        FileWriter beanClassWriter = new FileWriter(classFile);
        InputStream templateStream = new URL(pluginInstallURL, templateLocation).openStream();
        Templating.writeTemplateToWriter(templateMap, templateStream, beanClassWriter);
        templateStream.close();
        beanClassWriter.close();
        String classFileAbsolutPath = classFile.getAbsolutePath();
        String[] relBeanClassFileName = AbstractIDE.getFileNameSegmentsForSlashSeparatedFileName(classFileAbsolutPath.substring(projectPath.length(), classFileAbsolutPath.length()));
        ideInstance.openFileInEditor(project, relBeanClassFileName);
    }

    public static void createJavaFileFromTemplateAndOpenIt(IProject project, String fullyQualifiedClassName, String templateLocation, Map templateMap) throws Exception {
        URL pluginInstallURL = MIPlugin.getPluginURL();
        String pluginInstall = MIPlugin.getPluginFolderString();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        File beanClassFile = ideInstance.createJavaSourceFileInCurrentProject(project, fullyQualifiedClassName, 0);
        FileWriter beanClassWriter = new FileWriter(beanClassFile);
        File templateStream = new File(pluginInstall, templateLocation);
        TemplatingTemplates.writeTemplatetoFile(templateMap, templateStream, beanClassWriter);
        beanClassWriter.close();
        String classFileAbsolutPath = beanClassFile.getAbsolutePath();
        String[] relBeanClassFileName = AbstractIDE.getFileNameSegmentsForSlashSeparatedFileName(classFileAbsolutPath.substring(projectPath.length(), classFileAbsolutPath.length()));
        ideInstance.openFileInEditor(project, relBeanClassFileName);
    }

    public static void createAnyFileFromTemplateAndOpenIt(IProject project, String fullyQualifiedClassName, String templateLocation, Map templateMap) throws Exception {
        URL pluginInstallURL = MIPlugin.getPluginURL();
        String pluginInstall = MIPlugin.getPluginFolderString();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        File classFile = ideInstance.createAnyFileInCurrentProject(project, fullyQualifiedClassName, projectPath, 0);
        FileWriter beanClassWriter = new FileWriter(classFile);
        File templateStream = new File(pluginInstall, templateLocation);
        TemplatingTemplates.writeTemplatetoFile(templateMap, templateStream, beanClassWriter);
        beanClassWriter.close();
        String classFileAbsolutPath = classFile.getAbsolutePath();
        String[] relBeanClassFileName = AbstractIDE.getFileNameSegmentsForSlashSeparatedFileName(classFileAbsolutPath.substring(projectPath.length(), classFileAbsolutPath.length()));
        ideInstance.openFileInEditor(project, relBeanClassFileName);
    }

    public static void createAnyFileFromTemplate(IProject project, String fullyQualifiedClassName, String templateLocation, Map templateMap) throws Exception {
        URL pluginInstallURL = MIPlugin.getPluginURL();
        String pluginInstall = MIPlugin.getPluginFolderString();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        File classFile = ideInstance.createAnyFileInCurrentProject(project, fullyQualifiedClassName, projectPath, 0);
        FileWriter beanClassWriter = new FileWriter(classFile);
        File templateStream = new File(pluginInstall, templateLocation);
        TemplatingTemplates.writeTemplatetoFile(templateMap, templateStream, beanClassWriter);
        beanClassWriter.close();
    }

    public static void copyFilesToProject(IProject project, String fqFileName, String newFile) throws Exception {
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        Files.copyFile(fqFileName, projectPath + "/" + newFile);
    }

    public static void copyFoldersToProject(IProject project, String fileLocation, String subFolder) throws Exception {
        URL pluginInstallURL = MIPlugin.getPluginURL();
        String pluginInstall = MIPlugin.getPluginFolderString();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        Files.copyFolders(pluginInstall + fileLocation, projectPath + "/" + subFolder);
    }

    public static boolean isPios_Emulation_Mode() {
        PIOS_EMULATION_MODE = false;
        try {
            MDKInstallation mdkinstall = MDKInstallation.getInstance();
            PIOS_EMULATION_MODE = mdkinstall.isPios_Emulation_Mode();
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return PIOS_EMULATION_MODE;
    }

    public static void setPios_Emulation_Mode(boolean b) {
        PIOS_EMULATION_MODE = b;
    }

    public static boolean isLastLaunchWasJsp() {
        return lastLaunchWasJsp;
    }

    public static void setLastLaunchWasJsp(boolean b) {
        lastLaunchWasJsp = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

