/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.wizards.openArchive;

import com.sap.ip.me.mdk.developmentTools.general.api.EP;
import com.sap.ip.me.mdk.developmentTools.general.api.IGUI;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.developmentTools.general.wizards.openArchive.IOpenArchiveWizardPage;
import java.io.File;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class OpenArchiveWizardTemplate {
    public static boolean initalizeWizardPage(Object guiThingForModalDialog, IOpenArchiveWizardPage openArchivePage) {
        try {
            MDKInstallation mdk = MDKInstallation.getInstance();
            if (!mdk.isConfiguredOnce()) {
                OpentoolsFactory.getGuiSystem().invokeConfigurationWizard(guiThingForModalDialog);
            }
            if (mdk.isConfiguredOnce()) {
                IDESettings is = IDESettings.getInstance();
                openArchivePage.setOpenParFolder(is.getOpenParDefaultFolder());
                openArchivePage.setProjectRootRootFolder(is.getProjectRootRootFolder());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            OpentoolsFactory.getGuiSystem().showErrorMessage("Error", "Error in created projectin: initializeWizardPage", e, guiThingForModalDialog);
            return false;
        }
    }

    public static Object finishOpenArchivePage(IOpenArchiveWizardPage _textPage, Object guiThingForModalDialog) {
        File f;
        IGUI guiSystem = OpentoolsFactory.getGuiSystem();
        boolean success = true;
        String fileName = _textPage.getFilePath();
        String projectRootFolderName = _textPage.getProjectRootFolderName();
        String projectName = _textPage.getProjectName();
        Object project = null;
        File zipFile = new File(fileName);
        if (!zipFile.exists() || zipFile.isDirectory()) {
            String errorMessage = "Specified file not found '" + fileName + "'.\n";
            guiSystem.showErrorMessage("Error", errorMessage, new Exception("File does not exist: " + zipFile.getAbsolutePath()), guiThingForModalDialog);
            success = false;
        }
        if ((f = new File(projectRootFolderName, projectName)).exists()) {
            String errorMessage = "Folder " + projectName + " already exists as subfolder of " + projectRootFolderName + ".\nPlease specifiy a different project name or root folder.";
            guiSystem.showErrorMessage("Error", errorMessage, new Exception("Folder already exists: " + zipFile.getAbsolutePath()), guiThingForModalDialog);
            success = false;
        }
        if (success) {
            try {
                IDESettings iset = IDESettings.getInstance();
                iset.setOpenParDefaultFolder(zipFile.getParent());
                iset.setProjectRootRootFolder(projectRootFolderName);
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
            try {
                EP epInstance = OpentoolsFactory.getEPInstance();
                if (fileName.toLowerCase().endsWith(".war") || fileName.toLowerCase().endsWith(".war.bak")) {
                    project = epInstance.createNewMEProjectFromWar(projectRootFolderName, projectName, zipFile);
                    epInstance.getCurrentProfiles(project).updateClasspath();
                } else if ((fileName.toLowerCase().endsWith(".jar") || fileName.toLowerCase().endsWith(".jar.bak")) && (project = epInstance.createNewAWTProjectFromJar(projectRootFolderName, projectName, zipFile)) == null) {
                    throw new Exception("Jar file is not a valid MI AWT application !");
                }
            }
            catch (Throwable t) {
                guiSystem.showErrorMessage("Error", "Error in created project in: finishOpenArchivePage", t, guiThingForModalDialog);
                JavaPlugin.log((Throwable)t);
            }
        }
        return project;
    }
}

