/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.wizards.configurationWizard;

import com.sap.ip.me.mdk.developmentTools.general.api.IGUI;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.developmentTools.general.wizards.configurationWizard.IConfigurationWizardPage;
import com.sap.ip.me.mdk.developmentTools.general.wizards.configurationWizard.IConfigurationWizardStringLiterals;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class ConfigurationWizardTemplate
implements IConfigurationWizardStringLiterals {
    public static void initializeConfigurationPage(IConfigurationWizardPage _textPage) {
        try {
            _textPage.setIrjServerName(MDKInstallation.getInstance().getIrjServerName());
            _textPage.setIrjWebappName(MDKInstallation.getInstance().getIrjWebappName());
            _textPage.setIrjPortAsString(String.valueOf(MDKInstallation.getInstance().getIrjPort()));
        }
        catch (Exception e) {
            OpentoolsFactory.getGuiSystem().showErrorMessage("Error", "An error occurred at startup of the Configuration Wizard", e);
        }
    }

    public static boolean finishConfigurationPage(IConfigurationWizardPage _textPage, Object guiThingForModalDialog) {
        int optionPaneAnswer = 0;
        try {
            MDKInstallation mdkinstall = MDKInstallation.getInstance();
            IGUI gui = OpentoolsFactory.getGuiSystem();
            int port = Integer.parseInt(_textPage.getIrjServerPortAsString());
            String servername = _textPage.getIrjServerName();
            String webappName = _textPage.getIrjWebappName();
            mdkinstall.setIrjPort(port);
            mdkinstall.setIrjServerName(servername);
            mdkinstall.setIrjWebappName(webappName);
            optionPaneAnswer = 0;
            String failureMessage = "Could not find server with a running MDK at http://" + servername + ":" + port + "/" + webappName + "/...\nPossible reason: Invalid server address.\nRetry or check your settings.";
            while (!mdkinstall.isServerReachable() && optionPaneAnswer == 0) {
                optionPaneAnswer = gui.showOptionDialog(guiThingForModalDialog, failureMessage, "Connection failed", 2, IConfigurationWizardStringLiterals.uploadConnectFailureOptions, "Retry");
            }
            mdkinstall.updateIrjWebappFileHome();
            mdkinstall.doSave();
            try {
                mdkinstall.getInstalledServices();
            }
            catch (Throwable e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        catch (Exception e) {
            OpentoolsFactory.getGuiSystem().showErrorMessage("Error", "Configuration finished with an error", e);
        }
        return optionPaneAnswer == 0;
    }
}

