/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.uploader;

import com.sap.ip.me.mdk.developmentTools.general.uploader.PARArchiveUploaderConstants;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PARArchiveUploader
implements PARArchiveUploaderConstants {
    private static final Object syncObject = new Object();

    private static void writePortalThingListToXMLStream(HashMap componentNamesToListOfClasspathEntryFiles, Writer writer, String tagName) throws IOException {
        Set names = componentNamesToListOfClasspathEntryFiles.keySet();
        ArrayList sortedNames = new ArrayList(names);
        Collections.sort(sortedNames, String.CASE_INSENSITIVE_ORDER);
        Iterator compIter = sortedNames.iterator();
        while (compIter.hasNext()) {
            String componentName = (String)compIter.next();
            writer.write("<");
            writer.write(tagName);
            writer.write(" name=\"");
            writer.write(componentName);
            writer.write("\" >");
            Iterator iterator = ((List)componentNamesToListOfClasspathEntryFiles.get(componentName)).iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                writer.write("<jar path=\"");
                writer.write(file.getAbsolutePath().trim());
                writer.write("\" />");
            }
            writer.write("</");
            writer.write(tagName);
            writer.write(">");
        }
    }

    public static HashMap getReferencableComponentNamesToClasspathFileListMap() throws IOException {
        return null;
    }

    public static HashMap getAllServiceNamesToServiceClasspathFileListMap() {
        return null;
    }

    private static List createClasspathFileListOfPortalThingFolder(File thingDir) {
        final ArrayList<File> retValFiles = new ArrayList<File>();
        new File(thingDir, "lib").listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.endsWith(".jar")) {
                    retValFiles.add(new File(dir, name));
                    return false;
                }
                return false;
            }
        });
        File classesFolder = new File(thingDir, "classes");
        if (PARArchiveUploader.containsFolderClasses(classesFolder)) {
            retValFiles.add(classesFolder);
        }
        return retValFiles;
    }

    private static boolean containsFolderClasses(File folder) {
        if (folder == null) {
            return false;
        }
        if (!folder.exists()) {
            return false;
        }
        if (!folder.isDirectory()) {
            return false;
        }
        File[] classFilesInFolder = folder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        });
        if (classFilesInFolder != null && classFilesInFolder.length > 0) {
            return true;
        }
        File[] subdirs = folder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int i = 0;
        while (i < subdirs.length) {
            File subdir = subdirs[i];
            if (PARArchiveUploader.containsFolderClasses(subdir)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

