/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.settings;

import com.sap.ip.me.mdk.developmentTools.general.api.IPropertySystem;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKRequestResult;
import com.sap.ip.me.mdk.developmentTools.general.uploader.PARArchiveUploaderConstants;
import com.sap.ip.me.mdk.util.Files;
import com.sap.ip.me.mdk.util.Stream;
import com.sap.ip.me.mdk.util.Strings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class MDKInstallation
implements PARArchiveUploaderConstants {
    private static final String TOOLSJAR_FILENAME_REL_TO_JAVA_HOME = File.separator + "lib" + File.separator + "tools.jar";
    private static final String SERVLET_API_FILENAME_REL_TO_IRJ_HOME = File.separator + "lib" + File.separator + "servlet.jar";
    private static final String TOMCAT_API_FILENAME_REL_TO_IRJ_HOME = File.separator + "lib" + File.separator + "webserver.jar";
    private static final String JSP_API_FILENAME_REL_TO_IRJ_HOME = File.separator + "lib" + File.separator + "jasper.jar";
    private static final String JAXP_API_FILENAME_REL_TO_IRJ_HOME = File.separator + "lib" + File.separator + "jaxp.jar";
    private static final String CRIMSON_API_FILENAME_REL_TO_IRJ_HOME = File.separator + "lib" + File.separator + "crimson.jar";
    private static final String ME_API_FILENAME_REL_TO_IRJ_HOME = File.separator + "lib" + File.separator + "me2lib.jar";
    private static final String ME_APIG_FILENAME_REL_TO_IRJ_HOME = File.separator + "lib" + File.separator + "MEg.jar";
    private static final String MEL_APIG_FILENAME_REL_TO_IRJ_HOME = File.separator + "webapps" + File.separator + "me" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator + "MEl.jar";
    private static final String MDK_API_FILENAME = File.separator + "MDKExt.jar";
    private static final String MDK_API_FILENAME_REL_TO_ECLIPSE = "plugins" + File.separator + "com.sap.ip.me.mdk.developmentTools" + MDK_API_FILENAME;
    private static final String BOGENERATOR_API_FILENAME_REL_TO_ECLIPSE = "plugins" + File.separator + "com.sap.ip.me.mdk.developmentTools" + File.separator + "BoGenerator.jar";
    private static final String BOGENERATOR_MBSCORE_API_FILENAME_REL_TO_APPL = File.separator + "app-root" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator + "mbscore.jar";
    private static final String LISTOFJARS_FILE_REL_TO_IRJ_HOME = File.separator + "listOfJars.txt";
    private static final String STARTUP_BATFILE_REL_TO_IRJ_HOME = File.separator + "startup.bat";
    private static final String JAVADOC_LOCATION = File.separator + "webapps" + File.separator + "mdk" + File.separator + "content" + File.separator + "javadoc" + File.separator;
    private static final String MICONFIG_FILE_REL_TO_IRJ_HOME = File.separator + "settings" + File.separator + "MobileEngine.config";
    public static final int DEFAULT_IRJ_PORT = 4444;
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final String DEFAULT_WEBAPP_NAME = "me";
    public static final String DEFAULT_INST_FOLDER = "C:" + File.separator + "Program Files" + File.separator + "SAPMobileEngine";
    public static final String STANDARD_ROOT_DIR;
    public static final String DEFAULT_IRJ_HOME;
    public static final String THIS_PROP_GROUP = "com.sap.ip.me.mdk.developmentTools.general.MISettings";
    public static final String PIOS_PROP_GROUP = "com.sap.ip.me.mdk.pios.docgen";
    public static final String IRJ_HOME_PROPERTY_NAME = "IRJ_HOME";
    public static final String IRJ_PORT_PROPERTY_NAME = "IRJ_PORT";
    public static final String INST_FOLDER_ME_TOM_PROPERTY_NAME = "INST_FOLDER_NAME_TOM";
    public static final String INST_FOLDER_ME_AWT_PROPERTY_NAME = "INST_FOLDER_NAME_AWT";
    public static final String IRJ_WEBAPP_NAME_PROPERTY_NAME = "IRJ_WEBAPP_NAME";
    public static final String IRJ_SERVER_NAME_PROPERTY_NAME = "IRJ_SERVER";
    public static final String PIOS_EMULATION_MODE = "emulation_mode";
    public static final String PIOS_EMULATOR_HOME = "emulator_home";
    public static final String PIOS_EMULATOR_CONNECTOR = "emulator_connector";
    public static final String PIOS_ADDITIONAL_CLASSPATH = "additional_classpath";
    private static MDKInstallation singletonInstance;
    private int irjPort;
    private String irjServerName;
    private String irjWebappName;
    private String irjWebAppFileHome;
    private String instFolderMETom = "";
    private String instFolderMEAWT = "";
    private HashMap cookies = new HashMap();

    public static MDKInstallation getInstance() throws Exception {
        if (singletonInstance == null) {
            singletonInstance = new MDKInstallation();
        }
        return singletonInstance;
    }

    public MDKInstallation() throws Exception {
        this.reload();
    }

    public String getMERootURL() {
        return "http://" + this.irjServerName + ":" + this.irjPort + "/" + this.irjWebappName;
    }

    public String getMEBaseURL() {
        return "http://" + this.irjServerName + ":" + this.irjPort + "/";
    }

    public String getIrjRootURL() {
        return "http://" + this.irjServerName + ":" + this.irjPort + "/" + this.irjWebappName;
    }

    public String getIrjWebAppFileHome() {
        this.irjWebAppFileHome = this.getIrjWebappName();
        return this.irjWebAppFileHome;
    }

    public void updateIrjWebappFileHome() throws IOException {
        this.irjWebAppFileHome = this.getIrjWebappName();
    }

    public boolean isConfiguredOnce() {
        boolean is = false;
        try {
            this.reload();
            if (this.instFolderMETom != null && this.instFolderMETom.length() > 1) {
                is = true;
            }
            if (this.instFolderMEAWT != null && this.instFolderMEAWT.length() > 1) {
                is = true;
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return is;
    }

    public boolean isServerReachable() {
        boolean reachable = true;
        try {
            this.pingPDK();
            reachable = true;
        }
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
            reachable = false;
        }
        return reachable;
    }

    public String getServletApiFileName() {
        return this.getInstFolderMETom() + SERVLET_API_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getTomcatApiFileName() {
        return this.getInstFolderMETom() + TOMCAT_API_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getJspApiFileName() {
        return this.getInstFolderMETom() + JSP_API_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getJaxpApiFileName() {
        return this.getInstFolderMETom() + JAXP_API_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getCrimsonApiFileName() {
        return this.getInstFolderMETom() + CRIMSON_API_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getWarServletApiFileName() {
        return this.getInstFolderMETom() + SERVLET_API_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getWarME2libApiFileName() {
        return this.getInstFolderMETom() + ME_API_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getWarMEgApiFileName() {
        return this.getInstFolderMETom() + ME_APIG_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getWarMElApiFileName() {
        return this.getInstFolderMETom() + MEL_APIG_FILENAME_REL_TO_IRJ_HOME;
    }

    public String getMDKApiRelativeFileName() {
        return MDK_API_FILENAME_REL_TO_ECLIPSE;
    }

    public String getMDKApiFileName() {
        return MDK_API_FILENAME;
    }

    public String getMDKApiFullFileName() {
        return "ECLIPSE_HOME" + MDK_API_FILENAME_REL_TO_ECLIPSE;
    }

    public String getBoGeneratorApiFileName() {
        return BOGENERATOR_API_FILENAME_REL_TO_ECLIPSE;
    }

    public String getBoGeneratorMBSCoreApiFileName(Object project) {
        String rootProjectPath = OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project);
        return rootProjectPath + BOGENERATOR_MBSCORE_API_FILENAME_REL_TO_APPL;
    }

    public int getIrjPort() {
        return this.irjPort;
    }

    public String getIrjWebappName() {
        return this.irjWebappName;
    }

    public String getInstFolderMETom() {
        return this.checkInstFolder(this.instFolderMETom);
    }

    public String getInstFolderMEAWT() {
        return this.checkInstFolder(this.instFolderMEAWT);
    }

    public String getJavadocFolder() {
        return this.getInstFolderMETom() + JAVADOC_LOCATION;
    }

    public String checkInstFolder(String folder) {
        String retVal = "";
        if (folder != null && folder.trim().length() > 0) {
            retVal = folder;
        }
        return retVal;
    }

    public String getIrjServerName() {
        return this.irjServerName;
    }

    public List getListofJars(boolean isJSP) {
        String instFolder = this.getInstFolderMEAWT();
        if (isJSP) {
            instFolder = this.getInstFolderMETom();
        }
        ArrayList<String> coreClassPath = new ArrayList<String>();
        coreClassPath.clear();
        String fileContent = "";
        String classpathEntry = null;
        if (Files.doesFileExist(instFolder + LISTOFJARS_FILE_REL_TO_IRJ_HOME)) {
            try {
                fileContent = Files.readFile(instFolder + LISTOFJARS_FILE_REL_TO_IRJ_HOME);
                fileContent = fileContent.replace('\n', ' ');
                fileContent = fileContent.replace('\r', ' ');
                while (fileContent.trim().length() > 1) {
                    if (fileContent.indexOf(";") > 0) {
                        classpathEntry = fileContent.substring(0, fileContent.indexOf(";"));
                        fileContent = fileContent.substring(fileContent.indexOf(";") + 1);
                    } else {
                        classpathEntry = fileContent;
                        fileContent = "";
                    }
                    if (classpathEntry.trim().length() <= 0 || coreClassPath.contains(classpathEntry.trim()) || !Files.doesFileExist(classpathEntry.trim())) continue;
                    coreClassPath.add(classpathEntry.trim());
                }
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        if (Files.doesFileExist(instFolder + STARTUP_BATFILE_REL_TO_IRJ_HOME)) {
            File batFile = new File(instFolder + STARTUP_BATFILE_REL_TO_IRJ_HOME);
            try {
                fileContent = Files.findVariableinBatFile(batFile, "SET _BOOTSTRAP_JARS", false, false);
                if (fileContent != null && (fileContent = fileContent.substring(fileContent.indexOf("=") + 1).trim()).length() > 2) {
                    fileContent = Strings.replace(fileContent, "%ME_HOME%", instFolder);
                    while (fileContent.trim().length() > 1) {
                        if (fileContent.indexOf(";") > 0) {
                            classpathEntry = fileContent.substring(0, fileContent.indexOf(";"));
                            fileContent = fileContent.substring(fileContent.indexOf(";") + 1);
                        } else {
                            classpathEntry = fileContent;
                            fileContent = "";
                        }
                        if (classpathEntry.trim().length() <= 0 || coreClassPath.contains(classpathEntry.trim()) || !Files.doesFileExist(classpathEntry.trim())) continue;
                        coreClassPath.add(classpathEntry.trim());
                    }
                }
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        return coreClassPath;
    }

    public String getListofJarsAsString(boolean isJSP) {
        List coreClassPath = new ArrayList();
        coreClassPath = this.getListofJars(isJSP);
        String classpath = "";
        Iterator iterator = coreClassPath.iterator();
        while (iterator.hasNext()) {
            classpath = classpath + iterator.next().toString().trim() + ";";
        }
        return classpath;
    }

    public String getMIConfigValue(String miHomeFolder, String property, boolean isJSP) {
        String folder = miHomeFolder.replace('\\', '/');
        if (folder.endsWith("/")) {
            folder = folder.substring(0, folder.length() - 1);
        }
        String value = "";
        String fileContent = "";
        if (Files.doesFileExist(folder + MICONFIG_FILE_REL_TO_IRJ_HOME)) {
            try {
                int j;
                fileContent = Files.readFile(folder + MICONFIG_FILE_REL_TO_IRJ_HOME);
                int i = fileContent.indexOf(property);
                if (i > -1 && (j = (value = fileContent.substring(i + property.length() + 1)).indexOf("\n")) > -1) {
                    value = value.substring(0, j);
                    value = value.replace('\r', ' ');
                    value = value.trim();
                }
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        return value;
    }

    public String getMIConfigValue(String property, boolean isJSP) {
        String instFolder = this.getInstFolderMEAWT();
        if (isJSP) {
            instFolder = this.getInstFolderMETom();
        }
        String propValue = null;
        if (instFolder != null && instFolder.trim().length() > 0) {
            propValue = this.getMIConfigValue(instFolder, property, isJSP);
        }
        return propValue;
    }

    public List getInstalledServices() throws IOException {
        return null;
    }

    public void updateInstalledServicesOnDisk() throws IOException {
    }

    private void writeServiceFileToDisk(ByteArrayInputStream bais) throws IOException {
        File serviceListXMLFile = this.getServiceListFile();
        if (!serviceListXMLFile.exists()) {
            serviceListXMLFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(serviceListXMLFile);
        Stream.copyStream(bais, fos);
        fos.close();
    }

    private File getServiceListFile() {
        return new File(OpentoolsFactory.getIDEInstance().getUserDirectory(), "MDKEclipsePluginSettings.xml");
    }

    private MDKRequestResult readServiceListFromDisk() throws IOException {
        File serviceListXMLFile = this.getServiceListFile();
        FileInputStream fis = new FileInputStream(serviceListXMLFile);
        MDKRequestResult result = MDKRequestResult.createResultObject(fis);
        fis.close();
        return result;
    }

    private static String encodePropertiesForURLString(Properties p) {
        String name;
        StringBuffer result = new StringBuffer();
        Enumeration<?> en = p.propertyNames();
        if (en.hasMoreElements()) {
            name = (String)en.nextElement();
            result.append(MDKInstallation.encodeStringForURL(name));
            result.append('=');
            result.append(MDKInstallation.encodeStringForURL((String)((Hashtable)p).get(name)));
        }
        while (en.hasMoreElements()) {
            result.append('&');
            name = (String)en.nextElement();
            result.append(MDKInstallation.encodeStringForURL(name));
            result.append('=');
            result.append(MDKInstallation.encodeStringForURL((String)((Hashtable)p).get(name)));
        }
        return result.toString();
    }

    private static String encodeStringForURL(String string) {
        StringBuffer result = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char now = string.charAt(n);
            if (now == ' ') {
                result.append('+');
            } else {
                result.append('%');
                result.append(Integer.toHexString(now));
            }
            ++n;
        }
        return result.toString();
    }

    public boolean uploadPARArchive(File parArchive) throws IOException {
        return true;
    }

    public void pingPDK() throws IOException {
    }

    private MDKRequestResult sendRequestToUploaderComponent(String eventName, Properties params) throws IOException {
        params.setProperty("event", eventName);
        String urlString = this.getIrjRootURL() + "/servlet/prt/portal/prtroot/com.sapportals.pdk.util.DevelopmentTools.uploader";
        if (!((Hashtable)params).isEmpty()) {
            urlString = urlString + "?" + MDKInstallation.encodePropertiesForURLString(params);
        }
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setInstanceFollowRedirects(false);
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)");
        this.addCookieState(connection);
        BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
        this.updateCookieState(connection);
        return MDKRequestResult.createResultObject(in);
    }

    private void updateCookieState(HttpURLConnection connection) {
        int i = 1;
        String lastHeader = ((URLConnection)connection).getHeaderFieldKey(i);
        while (lastHeader != null) {
            if (lastHeader.trim().equals("Set-Cookie")) {
                String headerValue = ((URLConnection)connection).getHeaderField(i);
                StringTokenizer st = new StringTokenizer(headerValue, "\n\r \t=", false);
                String cookieName = st.nextToken();
                String cookieValue = st.nextToken();
                this.cookies.put(cookieName, cookieValue);
            }
            lastHeader = ((URLConnection)connection).getHeaderFieldKey(++i);
        }
    }

    private void addCookieState(HttpURLConnection connection) {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            Iterator iterator = this.cookies.keySet().iterator();
            StringBuffer sb = new StringBuffer();
            String cookieName = (String)iterator.next();
            String cookieValue = (String)this.cookies.get(cookieName);
            sb.append(cookieName + "=" + cookieValue);
            while (iterator.hasNext()) {
                cookieName = (String)iterator.next();
                cookieValue = (String)this.cookies.get(cookieName);
                sb.append(";" + cookieName + "=" + cookieValue);
            }
            connection.setRequestProperty("Cookie", sb.toString());
        }
    }

    public void loadCookieStateFromFile(File file) throws IOException, ClassNotFoundException {
        FileInputStream is = new FileInputStream(file);
        ObjectInputStream objectReader = new ObjectInputStream(is);
        this.cookies = (HashMap)objectReader.readObject();
        objectReader.close();
    }

    public void writeCookieStateToFile(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        ObjectOutputStream objectWriter = new ObjectOutputStream(os);
        objectWriter.writeObject(this.cookies);
        objectWriter.close();
    }

    public void setIrjPort(int irjPort) {
        this.irjPort = irjPort;
    }

    public void setIrjServerName(String irjServerName) {
        this.irjServerName = irjServerName;
    }

    public void setIrjWebappName(String irjWebappName) {
        this.irjWebappName = irjWebappName;
    }

    public void setInstFolderMETom(String instFolder) {
        this.instFolderMETom = instFolder;
    }

    public void setInstFolderMEAWT(String instFolder) {
        this.instFolderMEAWT = instFolder;
    }

    public void doSave() throws Exception {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        ps.saveProperty(THIS_PROP_GROUP, IRJ_HOME_PROPERTY_NAME, this.irjWebAppFileHome, null);
        ps.saveProperty(THIS_PROP_GROUP, IRJ_PORT_PROPERTY_NAME, String.valueOf(this.irjPort), null);
        ps.saveProperty(THIS_PROP_GROUP, IRJ_WEBAPP_NAME_PROPERTY_NAME, this.irjWebappName, null);
        ps.saveProperty(THIS_PROP_GROUP, IRJ_SERVER_NAME_PROPERTY_NAME, this.irjServerName, null);
        ps.saveProperty(THIS_PROP_GROUP, INST_FOLDER_ME_TOM_PROPERTY_NAME, this.instFolderMETom, null);
        ps.saveProperty(THIS_PROP_GROUP, INST_FOLDER_ME_AWT_PROPERTY_NAME, this.instFolderMEAWT, null);
    }

    public void reload() throws Exception {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        this.irjWebAppFileHome = ps.loadProperty(THIS_PROP_GROUP, IRJ_HOME_PROPERTY_NAME, null);
        this.irjServerName = ps.loadProperty(THIS_PROP_GROUP, IRJ_SERVER_NAME_PROPERTY_NAME, null);
        this.irjWebappName = ps.loadProperty(THIS_PROP_GROUP, IRJ_WEBAPP_NAME_PROPERTY_NAME, null);
        this.instFolderMETom = ps.loadProperty(THIS_PROP_GROUP, INST_FOLDER_ME_TOM_PROPERTY_NAME, null);
        this.instFolderMEAWT = ps.loadProperty(THIS_PROP_GROUP, INST_FOLDER_ME_AWT_PROPERTY_NAME, null);
        String tmpIrjPort = ps.loadProperty(THIS_PROP_GROUP, IRJ_PORT_PROPERTY_NAME, null);
        if (tmpIrjPort == null) {
            this.irjPort = 4444;
        } else {
            try {
                this.irjPort = Integer.parseInt(tmpIrjPort);
            }
            catch (NumberFormatException e) {
                this.irjPort = 4444;
            }
        }
        if (this.irjServerName == null) {
            this.irjServerName = DEFAULT_SERVER_NAME;
        }
        if (this.irjWebAppFileHome == null) {
            this.irjWebAppFileHome = DEFAULT_IRJ_HOME;
        }
        if (this.irjWebappName == null) {
            this.irjWebappName = DEFAULT_WEBAPP_NAME;
        }
    }

    public boolean isPios_Emulation_Mode() throws Exception {
        boolean emulModeB = false;
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String emulMode = ps.loadProperty(PIOS_PROP_GROUP, PIOS_EMULATION_MODE, null);
        if (emulMode != null && emulMode.equalsIgnoreCase("true")) {
            emulModeB = true;
        }
        return emulModeB;
    }

    public String getPios_Emulator_Home() throws Exception {
        String prop = null;
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        prop = ps.loadProperty(PIOS_PROP_GROUP, PIOS_EMULATOR_HOME, null);
        return prop;
    }

    public String getPios_Emulator_Connector() throws Exception {
        String prop = null;
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        prop = ps.loadProperty(PIOS_PROP_GROUP, PIOS_EMULATOR_CONNECTOR, null);
        return prop;
    }

    public String getPios_Classpath_Entry() throws Exception {
        String prop = null;
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        prop = ps.loadProperty(PIOS_PROP_GROUP, PIOS_ADDITIONAL_CLASSPATH, null);
        return prop;
    }

    static {
        File[] roots = File.listRoots();
        String tmp = null;
        int i = 0;
        while (i < roots.length) {
            File root = roots[i];
            if (root.getAbsolutePath().startsWith("c") || root.getAbsolutePath().startsWith("C")) {
                tmp = root.getAbsolutePath();
                break;
            }
            ++i;
        }
        STANDARD_ROOT_DIR = tmp == null ? roots[0].getAbsolutePath() : tmp;
        DEFAULT_IRJ_HOME = DEFAULT_INST_FOLDER + File.separator + "webapps";
    }
}

