/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.settings;

import com.sap.ip.me.mdk.developmentTools.general.api.IPropertySystem;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.util.Strings;
import java.io.File;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.JavaRuntime;

public class IDESettings {
    private static IDESettings singletonInstance = new IDESettings();
    private static final String THIS_PROP_GROUP = "com.sap.ip.me.mdk.developmentTools.general.IDESettings";
    private static final String BO_OPTION_PROPERTY_NAME = "boOption";
    private static final String BO_AUTHOR_PROPERTY_NAME = "boAuthor";
    private static final String BO_METAXML_PROPERTY_NAME = "boMetaXML";
    private static final String BO_WEBAPPLICATIONNAME_PROPERTY_NAME = "bowebAppliName";
    private static final String BO_WEBAPPLICATIONPACKAGENAME_PROPERTY_NAME = "bowebAppliPackName";
    private static final String BO_INTERFACENPACKAGENAME_PROPERTY_NAME = "boInterfacePackName";
    private static final String BO_IMPLEMENTATIONPACKAGENAME_PROPERTY_NAME = "boImplementationPackName";
    private static final String PROJECT_ROOT_ROOT_FOLDER_PROPERTY_NAME = "projectRootFolder";
    private static final String PAR_ARCHIVE_FILE_NAME_PROPERTY_NAME = "parArchive";
    private static final String ZIP_ARCHIVE_SRC_PROPERTY_NAME = "autoZip";
    private static final String COMPILE_JSP_PROPERTY_NAME = "compileJSP";
    private static final String COMPILE_JSP_KEEP_FILES_PROPERTY_NAME = "compileJSPKeepFiles";
    private static final String AUTO_UPLOAD_PROPERTY_NAME = "autoUpload";
    private static final String OPEN_PAR_DEFAULT_FOLDER_PROPERTY_NAME = "defaultOpenParFolder";
    private static final String NEW_PROJECT_CLASS_NAME = "newProjectClassName";
    private static final String NEW_PROJECT_PACKAGE_NAME = "newProjectPackageName";
    private static final String NEW_PROJECT_BEAN_NAME = "newProjectBeanName";
    private static final String NEW_PROJECT_ME_APPLICATION_NAME = "newProjectMeApplicationName";
    private static final String NEW_PROJECT_CONSTANTS_FILE_NAME = "newProjectConstantsFileName";
    private static final String NEW_PROJECT_JSP_FILE_NAME = "newProjectJSPFileName";
    public static final String QUICKSTART_PROFILE_NAME_PROPERTY = "quickstart";
    public static final String QUICKSTART_BROWSER_DELAY = "5";
    public static final String QUICKSTART_PROFILE_BROWSER_CMD_LINE = "browser_cmd";
    public static final String QUICKSTART_PROFILE_TOMCATSTART_CMD_LINE = "tomcatstart_cmd";
    public static final String QUICKSTART_PROFILE_TOMCATSTART_DEBUG_CMD_LINE = "tomcatstartdebug_cmd";
    public static final String QUICKSTART_PROFILE_TOMCATSTOP_CMD_LINE = "tomcatstop_cmd";
    public static final String DEFAULT_FILE_FOR_TOMCAT = "tomcatdef_file";
    public static final String QUICKSTART_TOOLSJAR = "toolsjar_folder";
    public static final String DEFAULT_PROJECT_ROOT_ROOT_FOLDER = MDKInstallation.STANDARD_ROOT_DIR + "SAPmi";
    private static final boolean DEFAULT_AUTO_UPLOAD = false;
    private static final boolean DEFAULT_ZIP_ARCHIVE_SRC = false;
    private static final boolean DEFAULT_COMPILE_JSP = false;
    private static final String DEFAULT_OPEN_PAR_DEFAULT_FOLDER;
    private static final String DEFAULT_BROWSER_CMD_LINE = "cmd /C start iexplore";
    private static final String DEFAULT_STARTTOMCAT_CMD_LINE = "cmd /C start C:\\ME2.1\\Startup.bat";
    private static final String DEFAULT_STOPTOMCAT_CMD_LINE = "cmd /C start C:\\ME2.1\\Shutdown.bat";
    private String defaultFileName;
    private String JREHome;
    private String archiveExtension;
    private boolean jspApplication;
    private String userName;
    private String password;

    public static IDESettings getInstance() {
        return singletonInstance;
    }

    private IDESettings() {
    }

    public String getProjectRootRootFolder() {
        String projectRootRootFolder = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            projectRootRootFolder = ps.loadProperty(THIS_PROP_GROUP, PROJECT_ROOT_ROOT_FOLDER_PROPERTY_NAME, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (projectRootRootFolder == null) {
            projectRootRootFolder = DEFAULT_PROJECT_ROOT_ROOT_FOLDER;
        }
        return projectRootRootFolder;
    }

    public void setProjectRootRootFolder(String projectRootRootFolder) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, PROJECT_ROOT_ROOT_FOLDER_PROPERTY_NAME, projectRootRootFolder, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getNewProjectClassName() {
        String prop = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            prop = ps.loadProperty(THIS_PROP_GROUP, NEW_PROJECT_CLASS_NAME, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (prop == null) {
            prop = "MiProjectClass";
        }
        return prop;
    }

    public void setNewProjectClassName(String className) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, NEW_PROJECT_CLASS_NAME, className, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getNewProjectPackageName() {
        String prop = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            prop = ps.loadProperty(THIS_PROP_GROUP, NEW_PROJECT_PACKAGE_NAME, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (prop == null) {
            prop = "miProjectPackage";
        }
        return prop;
    }

    public void setNewProjectPackageName(String packageName) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, NEW_PROJECT_PACKAGE_NAME, packageName, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getNewProjectConstantsFileName() {
        String prop = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            prop = ps.loadProperty(THIS_PROP_GROUP, NEW_PROJECT_CONSTANTS_FILE_NAME, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (prop == null) {
            prop = "Constants";
        }
        return prop;
    }

    public void setNewProjectConstantsFileName(String constantsFileName) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, NEW_PROJECT_CONSTANTS_FILE_NAME, constantsFileName, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getNewProjectBeanName() {
        String prop = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            prop = ps.loadProperty(THIS_PROP_GROUP, NEW_PROJECT_BEAN_NAME, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (prop == null) {
            prop = "TableViewBean";
        }
        return prop;
    }

    public void setNewProjectBeanName(String beanName) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, NEW_PROJECT_BEAN_NAME, beanName, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getNewProjectJSPFileName() {
        String prop = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            prop = ps.loadProperty(THIS_PROP_GROUP, NEW_PROJECT_JSP_FILE_NAME, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (prop == null) {
            prop = "initial.jsp";
        }
        return prop;
    }

    public void setNewProjectJSPFileName(String fileName) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, NEW_PROJECT_JSP_FILE_NAME, fileName, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getNewProjectMEAppName() {
        String prop = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            prop = ps.loadProperty(THIS_PROP_GROUP, NEW_PROJECT_ME_APPLICATION_NAME, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (prop == null) {
            prop = "MiApplication";
        }
        return prop;
    }

    public void setNewProjectMEAppName(String appName) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, NEW_PROJECT_ME_APPLICATION_NAME, appName, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public boolean isAutoUpload(Object project) {
        boolean autoUpload = false;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            String tmp = ps.loadProperty(THIS_PROP_GROUP, AUTO_UPLOAD_PROPERTY_NAME, project);
            if (tmp != null) {
                autoUpload = tmp.equals("true");
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return autoUpload;
    }

    public void setAutoUpload(boolean autoUpload, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, AUTO_UPLOAD_PROPERTY_NAME, String.valueOf(autoUpload), project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public boolean isZipArchiveSrc(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        boolean zipArchiveSrc = false;
        try {
            String tmp = ps.loadProperty(THIS_PROP_GROUP, ZIP_ARCHIVE_SRC_PROPERTY_NAME, project);
            if (tmp != null) {
                zipArchiveSrc = tmp.equals("true");
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return zipArchiveSrc;
    }

    public void setZipArchiveSrc(boolean zipArchiveSrc, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, ZIP_ARCHIVE_SRC_PROPERTY_NAME, String.valueOf(zipArchiveSrc), project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public boolean isCompileJSP(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        boolean compile = false;
        try {
            String tmp = ps.loadProperty(THIS_PROP_GROUP, COMPILE_JSP_PROPERTY_NAME, project);
            if (tmp != null) {
                compile = tmp.equals("true");
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return compile;
    }

    public void setCompileJSP(boolean compile, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, COMPILE_JSP_PROPERTY_NAME, String.valueOf(compile), project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public boolean isCompileJSPKeepFiles(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        boolean compileKeep = false;
        try {
            String tmp = ps.loadProperty(THIS_PROP_GROUP, COMPILE_JSP_KEEP_FILES_PROPERTY_NAME, project);
            if (tmp != null) {
                compileKeep = tmp.equals("true");
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return compileKeep;
    }

    public void setCompileJSPKeepFiles(boolean compile, Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, COMPILE_JSP_KEEP_FILES_PROPERTY_NAME, String.valueOf(compile), project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getDefault_WarFile(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String getDefault_WarFile = null;
        try {
            getDefault_WarFile = ps.loadProperty(THIS_PROP_GROUP, DEFAULT_FILE_FOR_TOMCAT, project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return getDefault_WarFile;
    }

    public String getArchiveName(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String parArchiveName = null;
        try {
            parArchiveName = ps.loadProperty(THIS_PROP_GROUP, PAR_ARCHIVE_FILE_NAME_PROPERTY_NAME, project);
            if (parArchiveName == null) {
                parArchiveName = OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project) + File.separator + OpentoolsFactory.getIDEInstance().getProjectName(project);
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (parArchiveName == null) {
            parArchiveName = "";
        }
        return parArchiveName;
    }

    public String getWarArchiveName(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String parArchiveName = null;
        try {
            parArchiveName = ps.loadProperty(THIS_PROP_GROUP, PAR_ARCHIVE_FILE_NAME_PROPERTY_NAME, project);
            if (parArchiveName == null) {
                MDKInstallation pdkinstall = MDKInstallation.getInstance();
                parArchiveName = pdkinstall.getInstFolderMETom() + File.separatorChar + "webapps" + File.separatorChar + OpentoolsFactory.getIDEInstance().getProjectName(project);
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (parArchiveName == null) {
            parArchiveName = "";
        }
        return parArchiveName;
    }

    public String getParShortName(Object project) {
        String parArchiveName = this.getArchiveName(project);
        try {
            int lastDotIndex;
            int lastSlashIndex = parArchiveName.lastIndexOf(File.separatorChar);
            if (lastSlashIndex < 0) {
                lastSlashIndex = 0;
            }
            if ((lastDotIndex = parArchiveName.lastIndexOf(46)) < lastSlashIndex) {
                lastDotIndex = parArchiveName.length();
            }
            return parArchiveName.substring(lastSlashIndex + 1, lastDotIndex);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
            return "";
        }
    }

    public void setWarArchiveName(Object project, String parArchiveName) {
        if (Strings.endsWithIgnoreCase(parArchiveName, ".par") || Strings.endsWithIgnoreCase(parArchiveName, ".zar")) {
            parArchiveName = parArchiveName.substring(0, parArchiveName.length() - 4);
        }
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, PAR_ARCHIVE_FILE_NAME_PROPERTY_NAME, parArchiveName, project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getOpenParDefaultFolder() {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String openParDefaultFolder = null;
        try {
            openParDefaultFolder = ps.loadProperty(THIS_PROP_GROUP, OPEN_PAR_DEFAULT_FOLDER_PROPERTY_NAME, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (openParDefaultFolder == null) {
            openParDefaultFolder = DEFAULT_OPEN_PAR_DEFAULT_FOLDER;
        }
        return openParDefaultFolder;
    }

    public void setOpenParDefaultFolder(String openParDefaultFolder) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, OPEN_PAR_DEFAULT_FOLDER_PROPERTY_NAME, openParDefaultFolder, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public void setQuickstartProfileName(Object project, String profileName) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_NAME_PROPERTY, profileName, project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getQuickstartProfileName(Object project) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        String profileName = null;
        try {
            profileName = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_NAME_PROPERTY, project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return profileName;
    }

    public String getInvokeBrowserCmd() {
        String cmd = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            cmd = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_BROWSER_CMD_LINE, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (cmd == null) {
            cmd = DEFAULT_BROWSER_CMD_LINE;
        }
        if (cmd.length() < 1) {
            cmd = DEFAULT_BROWSER_CMD_LINE;
        }
        return cmd;
    }

    public void setInvokeBrowserCmd(String cmdString) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_BROWSER_CMD_LINE, cmdString, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getInvokeStartTomcatCmd() {
        String cmd = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            cmd = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_TOMCATSTART_CMD_LINE, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (cmd == null) {
            cmd = DEFAULT_STARTTOMCAT_CMD_LINE;
        }
        return cmd;
    }

    public void setInvokeStartTomcatCmd(String cmdString) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_TOMCATSTART_CMD_LINE, cmdString, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getInvokeStartTomcatDebugCmd() {
        String cmd = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            cmd = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_TOMCATSTART_DEBUG_CMD_LINE, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (cmd == null) {
            cmd = DEFAULT_STARTTOMCAT_CMD_LINE;
        }
        return cmd;
    }

    public void setInvokeStartTomcatDebugCmd(String cmdString) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_TOMCATSTART_DEBUG_CMD_LINE, cmdString, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getInvokeStopTomcatCmd() {
        String cmd = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            cmd = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_TOMCATSTOP_CMD_LINE, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (cmd == null) {
            cmd = DEFAULT_STOPTOMCAT_CMD_LINE;
        }
        return cmd;
    }

    public void setInvokeStopTomcatCmd(String cmdString) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_PROFILE_TOMCATSTOP_CMD_LINE, cmdString, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getToolsjar() {
        String cmd = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            cmd = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_TOOLSJAR, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (cmd == null) {
            cmd = JavaRuntime.getDefaultVMInstall().getInstallLocation().toString();
            if (Strings.endsWithIgnoreCase(cmd, "jre")) {
                cmd = cmd.substring(0, cmd.length() - 4);
            }
            cmd = cmd + "\\lib\\tools.jar";
        }
        return cmd;
    }

    public void setToolsjar(String string) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_TOOLSJAR, string, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getBrowserDelay() {
        String cmd = null;
        try {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            cmd = ps.loadProperty(THIS_PROP_GROUP, QUICKSTART_BROWSER_DELAY, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        if (cmd == null) {
            cmd = QUICKSTART_BROWSER_DELAY;
        }
        return cmd;
    }

    public void setBrowserDelay(String cmdString) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        int bd = 0;
        String delay = cmdString;
        try {
            bd = Integer.valueOf(cmdString);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
            delay = QUICKSTART_BROWSER_DELAY;
        }
        if (bd < 0) {
            delay = QUICKSTART_BROWSER_DELAY;
        }
        try {
            ps.saveProperty(THIS_PROP_GROUP, QUICKSTART_BROWSER_DELAY, delay, null);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public void setDefault_WarFile(Object project, String def_file) {
        IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
        try {
            ps.saveProperty(THIS_PROP_GROUP, DEFAULT_FILE_FOR_TOMCAT, def_file, project);
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public String getArchiveExtension() {
        return this.archiveExtension;
    }

    public void setArchiveExtension(String archiveExtension) {
        this.archiveExtension = archiveExtension;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isJspApplication() {
        return this.jspApplication;
    }

    public void setJspApplication(boolean jspApplication) {
        this.jspApplication = jspApplication;
    }

    public String getPropertyByName(Object project, String property, String defString) {
        String prop = null;
        if (project != null) {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            try {
                prop = ps.loadProperty(THIS_PROP_GROUP, property, project);
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        if (prop == null) {
            prop = defString;
        }
        return prop;
    }

    public void setPropertyByName(Object project, String property, String value) {
        if (project != null) {
            IPropertySystem ps = OpentoolsFactory.getPropertySystemInstance();
            try {
                ps.saveProperty(THIS_PROP_GROUP, property, value, project);
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    public String getBoAuthor(Object project) {
        return this.getPropertyByName(project, BO_AUTHOR_PROPERTY_NAME, "SAP");
    }

    public String getBoImplPackName(Object project) {
        return this.getPropertyByName(project, BO_IMPLEMENTATIONPACKAGENAME_PROPERTY_NAME, "com.sap.ip.me.mdk.boimplementation");
    }

    public String getBoInterfacePackName(Object project) {
        return this.getPropertyByName(project, BO_INTERFACENPACKAGENAME_PROPERTY_NAME, "com.sap.ip.me.mdk.bointerface");
    }

    public String getBoMetaXML(Object project) {
        return this.getPropertyByName(project, BO_METAXML_PROPERTY_NAME, "");
    }

    public String getBoOption(Object project) {
        return this.getPropertyByName(project, BO_OPTION_PROPERTY_NAME, "-a");
    }

    public String getBoWebAppliName(Object project) {
        return this.getPropertyByName(project, BO_WEBAPPLICATIONNAME_PROPERTY_NAME, "SmartSyncProject");
    }

    public String getBoWebAppliPackName(Object project) {
        return this.getPropertyByName(project, BO_WEBAPPLICATIONPACKAGENAME_PROPERTY_NAME, "com.sap.ip.me.mdk.web");
    }

    public void setBoAuthor(Object project, String author) {
        this.setPropertyByName(project, BO_AUTHOR_PROPERTY_NAME, author);
    }

    public void setBoImplPackName(Object project, String string) {
        this.setPropertyByName(project, BO_IMPLEMENTATIONPACKAGENAME_PROPERTY_NAME, string);
    }

    public void setBoInterfacePackName(Object project, String string) {
        this.setPropertyByName(project, BO_INTERFACENPACKAGENAME_PROPERTY_NAME, string);
    }

    public void setBoMetaXML(Object project, String string) {
        this.setPropertyByName(project, BO_METAXML_PROPERTY_NAME, string);
    }

    public void setBoOption(Object project, String string) {
        this.setPropertyByName(project, BO_OPTION_PROPERTY_NAME, string);
    }

    public void setBoWebAppliName(Object project, String string) {
        this.setPropertyByName(project, BO_WEBAPPLICATIONNAME_PROPERTY_NAME, string);
    }

    public void setBoWebAppliPackName(Object project, String string) {
        this.setPropertyByName(project, BO_WEBAPPLICATIONPACKAGENAME_PROPERTY_NAME, string);
    }

    static {
        String defaultOpenPARDefaultFolder = null;
        DEFAULT_OPEN_PAR_DEFAULT_FOLDER = defaultOpenPARDefaultFolder = DEFAULT_PROJECT_ROOT_ROOT_FOLDER;
    }
}

