/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.gui.swt;

import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.gui.Labeled;
import com.sap.ip.me.mdk.developmentTools.general.gui.LabeledThingsGroup;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledPackageBrowsableTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.LabeledTextField;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.Validateable;
import com.sap.ip.me.mdk.util.JavaIdentifier;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SpecifyClassAndPackageComposite
extends Composite
implements Labeled,
Validateable {
    private LabeledTextField classNameField;
    private LabeledPackageBrowsableTextField packageNameField;
    private Object project;
    private Set forbiddenClassNames = new HashSet();
    private boolean isEmptyPackageNameAllowed = true;

    public SpecifyClassAndPackageComposite(Composite parent, int style, Object project) {
        super(parent, style);
        this.project = project;
        try {
            this.init();
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private void init() throws Exception {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.classNameField = new LabeledTextField(this, 0, "&Class name:");
        this.classNameField.setToolTipText("The name of the application class you want to create");
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        IFolder[] sourceFolders = new IFolder[ideInstance.getSourcePathCount(this.project)];
        int i = 0;
        while (i < sourceFolders.length) {
            File sourceFolderNow = ideInstance.getSrcPath(this.project, i);
            String relativePath = sourceFolderNow.getAbsolutePath().substring(ideInstance.getCurrentProjectFolder(this.project).length());
            sourceFolders[i] = ((IProject)this.project).getFolder((IPath)new Path(relativePath));
            ++i;
        }
        this.packageNameField = new LabeledPackageBrowsableTextField(this, 0, "P&ackage name:", sourceFolders, null);
        this.packageNameField.setToolTipText("The name of the package the class will reside in");
        super.setLayoutData((Object)new GridData(768));
        this.alignLabels();
    }

    private void alignLabels() {
        LabeledThingsGroup labelGroup = new LabeledThingsGroup();
        labelGroup.add(this.classNameField);
        labelGroup.add(this.packageNameField);
        labelGroup.alignTextFields();
    }

    public void setEmptyPackageNameAllowed(boolean emptyPackageNameAllowed) {
        this.isEmptyPackageNameAllowed = emptyPackageNameAllowed;
    }

    public void setClassLabel(String label) {
        this.classNameField.setLabelText(label);
        this.alignLabels();
    }

    public void setClassToolTip(String toolTip) {
        this.classNameField.setToolTipText(toolTip);
    }

    public void setPackageLabel(String label) {
        this.packageNameField.setLabelText(label);
        this.alignLabels();
    }

    public void setPackageToolTip(String toolTip) {
        this.packageNameField.setToolTipText(toolTip);
    }

    public String getClassName() {
        return this.classNameField.getValue();
    }

    public String getPackageName() {
        return this.packageNameField.getValue();
    }

    public void setClassName(String className) {
        this.classNameField.setValue(className);
    }

    public String getFullyQualifiedClassName() {
        String packageName = this.getPackageName();
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageName = packageName.trim()).equals("")) {
            packageName = packageName + ".";
        }
        return packageName + this.getClassName();
    }

    public String validate() {
        if (!this.isClassNameValid()) {
            return this.classNameField.getLabelText() + " must contain a valid Java class name.";
        }
        if (!this.isPackageNameValid()) {
            if (this.packageNameField.getValue() == null || this.packageNameField.getValue().trim().equals("")) {
                return this.packageNameField.getLabelText() + " cannot be empty.";
            }
            return this.packageNameField.getLabelText() + " must contain a valid package name.";
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName();
        if (this.forbiddenClassNames.contains(fullyQualifiedClassName)) {
            return fullyQualifiedClassName + " already exists in the project";
        }
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
        this.classNameField.getTextField().addModifyListener(listener);
        this.packageNameField.getTextField().addModifyListener(listener);
    }

    public boolean isClassNameValid() {
        return JavaIdentifier.isValidJavaIdentifier(this.getClassName());
    }

    public boolean isPackageNameValid() {
        if (!this.isEmptyPackageNameAllowed && (this.packageNameField.getValue() == null || this.packageNameField.getValue().trim().equals(""))) {
            return false;
        }
        return JavaIdentifier.isValidOrEmptyPackageName(this.packageNameField.getValue());
    }

    public boolean isValid() {
        return this.isPackageNameValid() && this.isClassNameValid();
    }

    public void setLabelWidth(int width) {
        this.classNameField.setLabelWidth(width);
        this.packageNameField.setLabelWidth(width);
    }

    public int getMinimumLabelWidth() {
        return Math.max(this.classNameField.getMinimumLabelWidth(), this.packageNameField.getMinimumLabelWidth());
    }

    public void setForbiddenClassNames(Set classNames) {
        this.forbiddenClassNames = classNames == null ? new HashSet() : classNames;
    }
}

