/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.gui.swt;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SmallLabel
extends Canvas {
    private String text = "";
    private Font font;
    private Color foreground;
    private Color background;
    private int fontHeight;
    private Point stringExtent;

    public SmallLabel(Composite composite, int i) {
        super(composite, i);
        Display display = this.getParent().getDisplay();
        this.font = display.getSystemFont();
        this.fontHeight = this.font.getFontData()[0].getHeight();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                SmallLabel.this.prepareGC(gc);
                if (SmallLabel.this.stringExtent == null) {
                    SmallLabel.this.stringExtent = gc.stringExtent(SmallLabel.this.text);
                }
                gc.drawText(SmallLabel.this.text, 0, 0);
            }
        });
    }

    private void prepareGC(GC gc) {
        if (this.font != null) {
            gc.setFont(this.font);
        }
        if (this.foreground != null) {
            gc.setForeground(this.foreground);
        }
        if (this.background != null) {
            gc.setBackground(this.background);
        }
    }

    public Point computeSize(int i, int i1, boolean b) {
        if (this.stringExtent == null) {
            GC gc = new GC((Drawable)this.getShell());
            this.prepareGC(gc);
            this.stringExtent = gc.stringExtent(this.text);
            gc.dispose();
        }
        return this.stringExtent;
    }

    public void setText(String text) {
        this.stringExtent = null;
        this.text = text;
    }

    public void setFont(Font font) {
        this.stringExtent = null;
        this.fontHeight = font.getFontData()[0].getHeight();
        this.font = font;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBackground() {
        return this.background;
    }
}

