/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.gui.swt;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

class PackageTreeLabelProvider
implements ILabelProvider {
    private String[] sourceNames;
    private IFolder[] sourcePaths;
    final HashSet foldersAsSet;
    final Image packageImage;
    final Image folderImage;

    public void disposeImages() {
        if (this.packageImage != null) {
            this.packageImage.dispose();
        }
        if (this.folderImage != null) {
            this.folderImage.dispose();
        }
    }

    protected void finalize() throws Throwable {
        this.disposeImages();
    }

    public PackageTreeLabelProvider(String[] sourceNames, IFolder[] sourcePaths) {
        this.sourceNames = sourceNames;
        this.sourcePaths = sourcePaths;
        this.foldersAsSet = new HashSet<IFolder>(Arrays.asList(sourcePaths));
        this.packageImage = JavaPluginImages.DESC_OBJS_PACKAGE.createImage();
        this.folderImage = JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT.createImage();
    }

    public Image getImage(Object element) {
        if (this.foldersAsSet.contains(element)) {
            return this.folderImage;
        }
        return this.packageImage;
    }

    public String getText(Object element) {
        if (element instanceof IFolder) {
            if (this.foldersAsSet.contains(element)) {
                int i = 0;
                while (i < this.sourcePaths.length && !this.sourcePaths[i].equals(element)) {
                    ++i;
                }
                return this.sourceNames[i];
            }
            IFolder iFolder = (IFolder)element;
            return iFolder.getName();
        }
        return "komisch " + element.getClass().getName();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.disposeImages();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

