/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.gui.swt;

import com.sap.ip.me.mdk.developmentTools.general.gui.swt.PackageInputDialog;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.PackageTreeContentProvider;
import com.sap.ip.me.mdk.developmentTools.general.gui.swt.PackageTreeLabelProvider;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class PackageBrowseDialog
extends Dialog {
    IFolder[] sourcePaths;
    String[] sourcePathsNames;
    private HashSet sourcePathsSet;
    Tree tree;
    TreeViewer treeViewer;
    private IFolder selectedFolder;
    private static final String INVALID_PACKAGE_NAME_MESSAGE = "Name must be a valid Java package name fragment";
    private int selectedFolderIndex = -1;

    public PackageBrowseDialog(Shell parentShell, IFolder[] sourcePaths, String[] sourcePathsNames) {
        super(parentShell);
        this.setShellStyle(48);
        this.sourcePaths = sourcePaths;
        this.sourcePathsNames = sourcePathsNames;
        this.sourcePathsSet = new HashSet<IFolder>(Arrays.asList(sourcePaths));
    }

    public PackageBrowseDialog(Shell parent, IFolder[] sourcePaths) {
        this(parent, sourcePaths, null);
    }

    private static String[] createSourcePathNamesFromFileNames(IFolder[] files) {
        String[] retVal = new String[files.length];
        int i = 0;
        while (i < files.length) {
            retVal[i] = files[i].getProjectRelativePath().toString();
            ++i;
        }
        return retVal;
    }

    public PackageBrowseDialog(Shell parent) {
        this(parent, null);
    }

    public void setSourcePaths(IFolder[] sourcePaths) {
        if (sourcePaths == null) {
            throw new IllegalArgumentException("Null is not supported here");
        }
        if (this.sourcePathsNames.length != sourcePaths.length) {
            throw new ArrayIndexOutOfBoundsException("The size of the arrays does not match: " + sourcePaths.length + " against " + this.sourcePathsNames.length + " names");
        }
        this.sourcePaths = sourcePaths;
    }

    public void setSourcePathsNames(String[] sourcePathsNames) {
        if (sourcePathsNames == null) {
            throw new IllegalArgumentException("Null is not supported here");
        }
        if (sourcePathsNames.length != this.sourcePaths.length) {
            throw new ArrayIndexOutOfBoundsException("The size of the arrays does not match: " + this.sourcePaths.length + " against " + sourcePathsNames.length + " names");
        }
        this.sourcePathsNames = sourcePathsNames;
    }

    protected Control createDialogArea(Composite parent) {
        Composite retVal = new Composite(parent, 0);
        if (this.sourcePathsNames == null) {
            this.sourcePathsNames = PackageBrowseDialog.createSourcePathNamesFromFileNames(this.sourcePaths);
        }
        retVal.setLayout((Layout)new GridLayout(1, true));
        Label text = new Label(retVal, 0);
        text.setText("Please select a package of your choice");
        text.setLayoutData((Object)new GridData(546));
        this.tree = new Tree(retVal, 4);
        this.treeViewer = new TreeViewer(this.tree);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 400;
        this.tree.setLayoutData((Object)layoutData);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PackageTreeLabelProvider(this.sourcePathsNames, this.sourcePaths));
        this.treeViewer.setContentProvider((IContentProvider)new PackageTreeContentProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.sourcePaths);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PackageBrowseDialog.this.handleSelectionChanged(event);
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (PackageBrowseDialog.this.selectedFolder != null) {
                    manager.add((IAction)new Action(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public String getText() {
                            return "add package here";
                        }

                        public void runWithEvent(Event event) {
                            PackageBrowseDialog.access$300(2.access$200(this.this$1));
                        }
                    });
                }
            }

            static /* synthetic */ PackageBrowseDialog access$200(2 x0) {
                return x0.PackageBrowseDialog.this;
            }
        });
        this.tree.setMenu(menuManager.createContextMenu((Control)this.tree));
        return retVal;
    }

    private void handleAddPackageHere() {
        String[] packName = this.getSelectedPackage();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < packName.length) {
            sb.append(packName[i]);
            sb.append('.');
            ++i;
        }
        PackageInputDialog inputDialog = new PackageInputDialog(this.getShell(), sb.toString(), "");
        if (inputDialog.open() == 0) {
            String packageNameFragment = inputDialog.getValue();
            StringTokenizer packageNameTok = new StringTokenizer(packageNameFragment, " .");
            IFolder currentFolder = this.selectedFolder;
            try {
                while (packageNameTok.hasMoreTokens()) {
                    String fragment = packageNameTok.nextToken();
                    if ((currentFolder = currentFolder.getFolder(fragment)).exists()) continue;
                    currentFolder.create(true, true, null);
                }
                this.treeViewer.refresh((Object)this.selectedFolder);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)currentFolder), true);
            }
            catch (CoreException e) {
                String message = "An error occured creating subpackage " + packageNameFragment + " .";
                ErrorDialog ed = new ErrorDialog(this.getShell(), "Error", message, (IStatus)new Status(2, MIPlugin.getPluginID(), 0, message, (Throwable)e), 0);
                ed.open();
            }
        }
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IFolder selectedFolder;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.selectedFolder = selectedFolder = (IFolder)structuredSelection.getFirstElement();
        }
    }

    public int getSelectedFolderIndex() {
        return this.selectedFolderIndex;
    }

    public IFolder getSelectedRootFolder() {
        if (this.getSelectedFolderIndex() == -1) {
            return null;
        }
        return this.sourcePaths[this.getSelectedFolderIndex()];
    }

    public String[] getSelectedPackage() {
        if (this.selectedFolder == null) {
            return null;
        }
        ArrayList<String> packageNames = new ArrayList<String>();
        IFolder folderNow = this.selectedFolder;
        while (!this.sourcePathsSet.contains(folderNow)) {
            packageNames.add(0, folderNow.getName());
            folderNow = folderNow.getParent();
        }
        return packageNames.toArray(new String[packageNames.size()]);
    }

    static /* synthetic */ void access$300(PackageBrowseDialog x0) {
        x0.handleAddPackageHere();
    }
}

