/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.gui.swt;

import com.sap.ip.me.mdk.developmentTools.general.gui.Labeled;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LabeledBrowsableTextField
extends Composite
implements Labeled {
    private String labelText;
    private Label label;
    private Text textField;
    private Button browseButton;
    private int fileSelectionMode;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    private int dialogFlags = 8196;
    private String[] filterNames;
    private String[] filterExtensions;
    private String filterPath;
    private String initalDirectory;

    public LabeledBrowsableTextField(Composite composite, int style, String labelText) {
        super(composite, style);
        this.labelText = labelText;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        super.setLayout((Layout)layout);
        GridData gd = new GridData(32);
        this.label = new Label((Composite)this, 0);
        this.label.setText(labelText);
        this.label.setLayoutData((Object)gd);
        gd = new GridData(768);
        this.textField = new Text((Composite)this, 2052);
        this.textField.setLayoutData((Object)gd);
        gd = new GridData(128);
        this.browseButton = new Button((Composite)this, 8);
        this.browseButton.setText("...");
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabeledBrowsableTextField.this.handleBrowse();
            }
        });
        super.setLayoutData((Object)new GridData(768));
    }

    protected void handleBrowse() {
        String fileName = null;
        if (this.fileSelectionMode == 0) {
            FileDialog fd = new FileDialog(this.getShell(), this.dialogFlags);
            fd.setFilterExtensions(this.filterExtensions);
            fd.setFilterNames(this.filterNames);
            fd.setFilterPath(this.filterPath);
            fd.setFileName(this.initalDirectory);
            fileName = fd.open();
        }
        if (this.fileSelectionMode == 1) {
            DirectoryDialog dd = new DirectoryDialog(this.getShell(), this.dialogFlags);
            dd.setFilterPath(this.filterPath);
            fileName = dd.open();
        }
        if (fileName != null) {
            this.textField.setText(fileName);
        }
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public void setDialogFlags(int dialogFlags) {
        this.dialogFlags = dialogFlags;
    }

    public void setInitalDirectory(String initalDirectory) {
        this.initalDirectory = initalDirectory;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setLabelWidth(int width) {
        ((GridData)this.label.getLayoutData()).widthHint = width;
    }

    public int getMinimumLabelWidth() {
        return this.label.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.textField.setText(value);
    }

    public Text getTextField() {
        return this.textField;
    }

    public void setLabelText(String text) {
        this.label.setText(text);
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public void addModifyListener(ModifyListener listener) {
        this.textField.addModifyListener(listener);
    }
}

