/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general.gui.swt;

import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import java.io.File;
import java.io.FileFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

class FullDirectoryInputAndLabelProvider
implements ITreeContentProvider,
ILabelProvider {
    private FileFilter filter;
    final Image folderImage = MIPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    final Image fileImage = MIPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FullDirectoryInputAndLabelProvider(FileFilter filter) {
        this.filter = filter;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] files;
        File file;
        if (parentElement == null) {
            return new File[0];
        }
        if (parentElement instanceof File && (file = (File)parentElement).isDirectory() && (files = file.listFiles(this.filter)) != null) {
            return files;
        }
        return new File[0];
    }

    public Object getParent(Object element) {
        if (element instanceof File) {
            return ((File)element).getParentFile();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element != null) {
            return this.getChildren(element).length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        File file;
        if (inputElement instanceof File && (file = (File)inputElement).isDirectory()) {
            return file.listFiles(this.filter);
        }
        return File.listRoots();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            if (file.isDirectory()) {
                return this.folderImage;
            }
            if (file.getParentFile() != null) {
                return this.fileImage;
            }
            return this.folderImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            String name = file.getName();
            if (name.equals("")) {
                name = file.getAbsolutePath();
            }
            return name;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

