/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general;

import com.sap.ip.me.mdk.developmentTools.general.AbstractCustomProfileAttribute;
import com.sap.ip.me.mdk.developmentTools.general.AbstractProfile;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class CustomProfileAttribute
extends AbstractCustomProfileAttribute {
    private String name = "";
    private String value = "";
    private String personalization = "none";
    private String inheritance = "non-final";
    private String plainDescription = "";
    private String description = "";
    private AbstractProfile myProfile;
    private Properties customCustomAttributes;

    public CustomProfileAttribute(AbstractProfile parent) {
        this.myProfile = parent;
    }

    private CustomProfileAttribute() {
    }

    public CustomProfileAttribute(String name, AbstractProfile myProfile) {
        this.name = name;
        this.myProfile = myProfile;
    }

    public String getName() {
        return this.name;
    }

    void setProfile(AbstractProfile parent) {
        this.myProfile = parent;
    }

    public String getValue() {
        return this.value;
    }

    public String getPersonalization() {
        return this.personalization;
    }

    public String getInheritance() {
        return this.inheritance;
    }

    public String getPlainDescription() {
        return this.plainDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        name = name.trim();
        if ((name = name.replace(' ', '_')).equals(this.name) || name.equals("")) {
            return;
        }
        Set mySiblings = this.myProfile.getCustomAttributes();
        Iterator iterator = mySiblings.iterator();
        while (iterator.hasNext()) {
            CustomProfileAttribute attribute = (CustomProfileAttribute)iterator.next();
            if (!attribute.getName().equals(name)) continue;
            return;
        }
        this.name = name;
    }

    public void setValue(String value) {
        value = value.replace('\n', ' ');
        this.value = value = value.replace('\r', ' ');
    }

    public void setPersonalization(String personalization) {
        if (personalization == null) {
            return;
        }
        if ((personalization = personalization.trim()).equals("dialog")) {
            this.personalization = "dialog";
        }
        if (personalization.equals("no dialog")) {
            this.personalization = "no dialog";
        }
        if (personalization.equals("none")) {
            this.personalization = "none";
        }
    }

    public void setInheritance(String inheritance) {
        if (inheritance == null) {
            return;
        }
        if ((inheritance = inheritance.trim()).equals("final")) {
            this.inheritance = "final";
        }
        if (inheritance.equals("non-final")) {
            this.inheritance = "non-final";
        }
    }

    public void setPlainDescription(String plainDescription) {
        plainDescription = plainDescription.replace('\n', ' ');
        this.plainDescription = plainDescription = plainDescription.replace('\r', ' ');
    }

    public Properties getCustomCustomAttributes() {
        return this.customCustomAttributes;
    }

    protected void setCustomCustomAttributes(Properties customCustomAttributes) {
        this.customCustomAttributes = customCustomAttributes;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        try {
            CustomProfileAttribute toComp = (CustomProfileAttribute)o;
            return toComp.getName().equals(this.name);
        }
        catch (ClassCastException cce) {
            JavaPlugin.log((Throwable)cce);
            return false;
        }
    }

    public AbstractCustomProfileAttribute deepClone() {
        CustomProfileAttribute clone = new CustomProfileAttribute();
        clone.name = this.name;
        clone.value = this.value;
        clone.personalization = this.personalization;
        clone.inheritance = this.inheritance;
        clone.plainDescription = this.plainDescription;
        clone.description = this.description;
        if (this.customCustomAttributes != null) {
            clone.customCustomAttributes = (Properties)((Hashtable)this.customCustomAttributes).clone();
        }
        return clone;
    }
}

