/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.general;

import com.sap.ip.me.mdk.developmentTools.general.AbstractProfile;
import com.sap.ip.me.mdk.developmentTools.general.Service;
import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.api.StringBasedFileFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public abstract class AbstractProfiles {
    final Object project;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Map allServicesByName = new HashMap();
    private List completeServicesList;
    private List completeComponentList;
    private HashMap completeComponentSet = new HashMap();
    private HashMap completeServiceSet = new HashMap();

    public AbstractProfiles(Object project) {
        this.project = project;
    }

    public abstract Iterator getProfilesIterator();

    public abstract List getProfiles();

    public abstract Set getReferencedServices() throws Exception;

    public abstract Set getReferencedComponents() throws Exception;

    public abstract AbstractProfile addProfile(String var1) throws Exception;

    public abstract void addProfile(AbstractProfile var1) throws Exception;

    public abstract boolean removeProfile(String var1);

    public abstract int getProfilesCount();

    public abstract void doSave() throws Exception;

    public abstract AbstractProfile getProfileByName(String var1);

    public abstract boolean isSharingAccess();

    public abstract void setSharingAccess(boolean var1);

    private void initServicesAndSharingReferences() throws Exception {
    }

    private void addDeclaredServicesToHashMap(Set thisProfilesReferencedServiceNames, HashMap completeServiceSet, boolean isAComponent) {
        Iterator iterator = thisProfilesReferencedServiceNames.iterator();
        while (iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            Service serviceNow = (Service)completeServiceSet.get(serviceName);
            if (serviceNow == null) {
                serviceNow = new Service(serviceName, "Unknown", isAComponent);
                completeServiceSet.put(serviceName, serviceNow);
            }
            this.allServicesByName.put(serviceName, serviceNow);
        }
    }

    public List getCompleteServicesList() throws Exception {
        if (this.completeServicesList == null) {
            this.initServicesAndSharingReferences();
        }
        return this.completeServicesList;
    }

    public List getCompleteComponentList() throws Exception {
        if (this.completeComponentList == null) {
            this.initServicesAndSharingReferences();
        }
        return this.completeComponentList;
    }

    public void updateClasspathIfServiceOrComponentReferencesChanged() throws Exception {
        if (this.completeComponentList != null) {
            this.updateClasspath();
        }
    }

    public void updateClasspath() throws Exception {
        if (this.completeComponentList == null) {
            this.initServicesAndSharingReferences();
        }
        ArrayList neededJarFiles = new ArrayList();
        Iterator iterator = this.getReferencedComponents().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Service now = (Service)this.completeComponentSet.get(name);
            if (now == null) continue;
            neededJarFiles.addAll(now.getJarFiles());
        }
        Iterator iterator2 = this.getReferencedServices().iterator();
        while (iterator2.hasNext()) {
            String name = (String)iterator2.next();
            Service now = (Service)this.completeServiceSet.get(name);
            if (now == null) continue;
            neededJarFiles.addAll(now.getJarFiles());
        }
        OpentoolsFactory.getIDEInstance().adjustProjectClassPathTo(this.project, neededJarFiles, "referenced", false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    public static Collection getDescriptionKeysPossibilities(Object project, String activeResourceBundleName) throws IOException {
        ArrayList possibilities = null;
        StringBasedFileFilter recursionFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments[0].equals("private") && segments.length == 1) {
                    return true;
                }
                return segments.length > 1 && segments[1].equals("classes");
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                return segments.length > 2 && segments[0].equals("private") && segments[1].equals("classes") && segments[segments.length - 1].endsWith(".properties");
            }
        };
        IDE ide = OpentoolsFactory.getIDEInstance();
        List allFileNamesSegmentArrays = ide.getAllFilesInProject(project, acceptFilter, recursionFilter);
        Properties allKeys = new Properties();
        Iterator iterator = allFileNamesSegmentArrays.iterator();
        while (iterator.hasNext()) {
            String[] segments = (String[])iterator.next();
            if (!segments[segments.length - 1].startsWith(activeResourceBundleName)) continue;
            try {
                File f = ide.getFileObjectFor(project, segments);
                allKeys.load(new FileInputStream(f));
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        possibilities = new ArrayList(((Hashtable)allKeys).keySet());
        return possibilities;
    }

    public void ensureServiceIsReferenced(String serviceName) throws Exception {
        List completeServicesList = this.getCompleteServicesList();
        Iterator iterator = completeServicesList.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (!service.getName().equals(serviceName)) continue;
            this.getReferencedServices().add(serviceName);
            return;
        }
        throw new NoSuchElementException("Service " + serviceName + " not found in the list of available services");
    }

    public void ensureComponentIsReferenced(String componentName) throws Exception {
        List completeComponentsList = this.getCompleteComponentList();
        Iterator iterator = completeComponentsList.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (!service.getName().equals(componentName)) continue;
            this.getReferencedComponents().add(componentName);
            return;
        }
        throw new NoSuchElementException("Component " + componentName + " not found in the list of available services");
    }

    public Set getProfileNames() {
        HashSet<String> profileNames = new HashSet<String>();
        List profiles = this.getProfiles();
        Iterator iterator = profiles.iterator();
        while (iterator.hasNext()) {
            profileNames.add(((AbstractProfile)iterator.next()).getName());
        }
        return profileNames;
    }
}

