/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.developmentTools.ePSpecific;

import com.sap.ip.me.mdk.developmentTools.general.AbstractProfiles;
import com.sap.ip.me.mdk.developmentTools.general.Profiles;
import com.sap.ip.me.mdk.developmentTools.general.api.EP;
import com.sap.ip.me.mdk.developmentTools.general.api.FileNotExistException;
import com.sap.ip.me.mdk.developmentTools.general.api.IDE;
import com.sap.ip.me.mdk.developmentTools.general.api.OpentoolsFactory;
import com.sap.ip.me.mdk.developmentTools.general.api.StringBasedFileFilter;
import com.sap.ip.me.mdk.developmentTools.general.settings.IDESettings;
import com.sap.ip.me.mdk.developmentTools.general.settings.MDKInstallation;
import com.sap.ip.me.mdk.developmentTools.ideSpecific.eclipse.MIPlugin;
import com.sap.ip.me.mdk.util.Files;
import com.sap.ip.me.mdk.util.Stream;
import com.sap.ip.me.mdk.util.Strings;
import com.sap.ip.me.mdk.util.Templating;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaUI;

public class ME21
implements EP {
    public static final String IPORTAL_COMPONENT_FQ_NAME = "com.sap.ip.me.mdk.prt.component.IPortalComponent";
    public static final String SERVLET_INTERFACE_FQ_NAME = "javax.servlet.Servlet";
    public static final String ME_APPLICATION_NAME = "ME_APPLICATION_NAME";
    public static final String MI_APPLICATION_NAME = "MI_APPLICATION_NAME";
    public static final String MIPROJECT_TEMPLATE_ROOTFOLDER = "projecttemplates";
    public static final String MIPROJECT_JSPTEMPLATE = "jsp";
    public static final String MIPROJECT_AWTTEMPLATE = "awt";
    public static final String MIPROJECT_SMARTSYNCJSPTEMPLATE = "jsp/smartsync";
    public static final String WEBAPPS_FOLDER = "/webapps/";
    public static final String APPL_WEBINF = "WEB-INF";
    public static final String SRCLIB_FOLDER = "srclib";
    public static final String WAR_SRC_FOLDER = "src";
    public static final String SRC_FOLDER = "java";
    public static final String APPL_FOLDER = "app-root";
    public static final String APPL_FOLDER_DEST = "app-root/";
    public static final String APPL_FOLDER_WARFILE = "";
    public static final String PROPERTIES_FOLDER = "properties";
    public static final String CLASSES_FOLDER = "classes";
    public static final String SRC_LIB_FOLDER = "srclib/";
    public static final String APPL_LIB_FOLDER = "WEB-INF/lib/";
    public static final String APPL_SRCLIB = "WEB-INF/srclib/";
    public static final String APPL_CLASSES = "WEB-INF/classes";
    List portalComponentPossibilites;
    List jspPossibilites;
    List servletPossibilites;
    public static final FileFilter acceptDirAndDotJavasFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".java") || pathname.isDirectory();
        }
    };
    public static final FileFilter acceptDirAndDotJSPFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".jsp") || pathname.isDirectory();
        }
    };
    public static final FileFilter acceptDirAndDotJavasAndPropertiesFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".java") || pathname.getAbsolutePath().endsWith(".properties") || pathname.isDirectory();
        }
    };
    private static final StringBasedFileFilter reject_privateClassesSrcSrclib = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            boolean classes = false;
            boolean result = false;
            if (segments.length == 3 && isDir && segments[0].equals(ME21.APPL_FOLDER)) {
                boolean bl = classes = segments[1].equals(ME21.APPL_WEBINF) || segments[2].equals(ME21.CLASSES_FOLDER);
            }
            if (segments.length == 2 && isDir && segments[0].equals(ME21.APPL_FOLDER)) {
                boolean srclib = segments[1].equals(ME21.SRCLIB_FOLDER);
                boolean srcfolder = segments[1].equals(ME21.SRC_FOLDER);
                boolean properties = segments[1].equals(ME21.PROPERTIES_FOLDER);
                return !srclib && !classes && !srcfolder && !properties;
            }
            return false;
        }
    };
    private static final StringBasedFileFilter exceptPropertiesClasses = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            if (segments[0].equals(ME21.APPL_FOLDER)) {
                if (segments.length > 1) {
                    if (segments[1].equals(ME21.APPL_WEBINF)) {
                        if (segments.length > 1) {
                            return !segments[2].equals(ME21.PROPERTIES_FOLDER) && !segments[2].equals(ME21.CLASSES_FOLDER);
                        }
                        return true;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
    };
    private static final StringBasedFileFilter withPropertiesClasses = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            if (segments[0].equals(ME21.APPL_FOLDER)) {
                if (segments.length > 1) {
                    if (segments[1].equals(ME21.APPL_WEBINF)) {
                        if (segments.length > 1) {
                            if (segments[2].equals(ME21.PROPERTIES_FOLDER) || segments[2].equals(ME21.CLASSES_FOLDER)) {
                                return true;
                            }
                            return true;
                        }
                        return true;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
    };
    private static final StringBasedFileFilter onlyProperties = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            if (segments[0].equals(ME21.APPL_FOLDER)) {
                if (segments.length > 1) {
                    if (segments[1].equals(ME21.APPL_WEBINF)) {
                        if (segments.length > 1) {
                            return segments[2].equals(ME21.PROPERTIES_FOLDER);
                        }
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static final StringBasedFileFilter onlyPropertiesunderSRC_FOLDER = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            return segments[0].equals(ME21.SRC_FOLDER) && segments[segments.length - 1].endsWith(".properties");
        }
    };
    private static final StringBasedFileFilter recurseToPrivateFilter = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            return segments.length == 1 && segments[0].equals(ME21.APPL_FOLDER);
        }
    };
    private static final StringBasedFileFilter recurseToPropertiesFilter = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            return segments.length == 1 && segments[0].equals(ME21.APPL_FOLDER);
        }
    };
    private static final StringBasedFileFilter rejectSrcSrclibCoreSrclibApiClases = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            if (segments.length == 2 && isDir && segments[0].equals(ME21.APPL_FOLDER)) {
                String subFolderName = segments[1];
                return !subFolderName.equals("srclibCore") && !segments[1].equals("srclibApi") && !segments[1].equals(ME21.CLASSES_FOLDER) && !segments[1].equals(ME21.WAR_SRC_FOLDER);
            }
            return false;
        }
    };
    private static final StringBasedFileFilter rejectDotJavasAcceptDirs = new StringBasedFileFilter(){

        public boolean accept(String[] segments, boolean isDir) throws IOException {
            if (isDir) {
                return true;
            }
            if (segments.length > 0) {
                return !segments[segments.length - 1].endsWith(".java");
            }
            return true;
        }
    };
    public static final String[] PRIVATE_RESOURCE_PATH = new String[]{"private"};
    public static final String[] PUBLIC_RESOURCE_PATH = new String[]{"public"};
    public static final String[] POSSIBLE_JSP_SCOPES = new String[]{"application", "session", "request", "page"};

    public static final String findMEProjectName(File file, String[] extension, String searchString) {
        String meAppl = null;
        try {
            int found;
            meAppl = Files.findTextinFile(file, extension, searchString);
            if (meAppl != null && (found = meAppl.indexOf("\"")) > 0) {
                int foundend = meAppl.indexOf("\"", found + 1);
                meAppl = meAppl.substring(found + 1, foundend);
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        return meAppl;
    }

    public File createMIProjectFileAndFolderStructure(String projectRootRootFolder, String projectName) throws IOException {
        File projectFolder = new File(projectRootRootFolder, projectName);
        File privateFolder = new File(projectFolder, SRC_FOLDER);
        File publicFolder = new File(projectFolder, APPL_FOLDER);
        File priwebinfFolder = new File(publicFolder, APPL_WEBINF);
        File priLibFolder = new File(priwebinfFolder, "lib");
        projectFolder.mkdirs();
        publicFolder.mkdir();
        privateFolder.mkdir();
        priwebinfFolder.mkdir();
        priLibFolder.mkdir();
        return projectFolder;
    }

    public File createMIProjectExtendedFolderStructure(Object project, String projectRootRootFolder, String projectName) throws IOException {
        File projectFolder = new File(projectRootRootFolder, projectName);
        File privateFolder = new File(projectFolder, SRC_FOLDER);
        File publicFolder = new File(projectFolder, APPL_FOLDER);
        File pubMimesFolder = new File(publicFolder, "mimes");
        File pubCssFolder = new File(publicFolder, "css");
        pubMimesFolder.mkdir();
        pubCssFolder.mkdir();
        return projectFolder;
    }

    public File createAWTProjectFileStructure(String projectRootRootFolder, String projectName) throws IOException {
        File projectFolder = new File(projectRootRootFolder, projectName);
        File privateFolder = new File(projectFolder, SRC_FOLDER);
        projectFolder.mkdirs();
        privateFolder.mkdir();
        return projectFolder;
    }

    public List getServletPossibilites(Object project) {
        this.reInitServletPossibilities(project);
        return this.servletPossibilites;
    }

    public List getJspPossibilites(Object project) {
        this.reInitJSPPossibilities(project);
        return this.jspPossibilites;
    }

    public String getWebXml(Object project) {
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        IDESettings iset = IDESettings.getInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        return new File(projectPath, "app-root/WEB-INF/web.xml").toString();
    }

    public String getWebincXml(Object project) {
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        IDESettings iset = IDESettings.getInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        return new File(projectPath, "app-root/WEB-INF/web.xml").toString();
    }

    public List getPortalComponentPossibilites(Object project) {
        this.reInitPortalComponentPossibilities(project);
        return this.portalComponentPossibilites;
    }

    public void resetPortalComponentPossibilities() {
        this.portalComponentPossibilites = null;
    }

    public void resetCaches() {
        this.resetJSPPossibilities();
        this.resetPortalComponentPossibilities();
        this.resetServletPossibilites();
    }

    private void reInitPortalComponentPossibilities(Object project) {
        this.portalComponentPossibilites = OpentoolsFactory.getIDEInstance().getAllNonAbstractClassesDerivedFromInCurrentProject(project, IPORTAL_COMPONENT_FQ_NAME);
    }

    public void resetServletPossibilites() {
        this.servletPossibilites = null;
    }

    private void reInitServletPossibilities(Object project) {
        this.servletPossibilites = OpentoolsFactory.getIDEInstance().getAllNonAbstractClassesDerivedFromInCurrentProject(project, SERVLET_INTERFACE_FQ_NAME);
    }

    public void resetJSPPossibilities() {
        this.jspPossibilites = null;
    }

    private void reInitJSPPossibilities(Object project) {
        StringBasedFileFilter recursionFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments.length == 0) {
                    return true;
                }
                return isDir && segments[0].equals(ME21.APPL_FOLDER);
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                boolean retVal = !isDir && segments.length > 1 && segments[0].equals(ME21.APPL_FOLDER) && segments[segments.length - 1].substring(segments[segments.length - 1].length() - 4).equalsIgnoreCase(".jsp");
                return retVal;
            }
        };
        try {
            this.jspPossibilites = OpentoolsFactory.getIDEInstance().getAllFilesInProject(project, acceptFilter, recursionFilter);
        }
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    public Set getResourceBundleNames(Object project) {
        HashSet<String> retVal = new HashSet<String>();
        StringBasedFileFilter recursionFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments[0].equals(ME21.APPL_FOLDER)) {
                    if (segments.length > 1) {
                        if (segments[1].equals(ME21.APPL_WEBINF)) {
                            if (segments.length > 1) {
                                return segments[2].equals(ME21.CLASSES_FOLDER);
                            }
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                return segments.length > 2 && segments[0].equals(ME21.APPL_FOLDER) && segments[1].equals(ME21.APPL_WEBINF) && segments[2].equals(ME21.CLASSES_FOLDER) && segments[segments.length - 1].endsWith(".properties");
            }
        };
        try {
            List possibleResourceFiles = OpentoolsFactory.getIDEInstance().getAllFilesInProject(project, acceptFilter, recursionFilter);
            Iterator iterator = possibleResourceFiles.iterator();
            while (iterator.hasNext()) {
                String[] segments = (String[])iterator.next();
                StringBuffer sb = new StringBuffer();
                String shortFileName = segments[segments.length - 1];
                int indexOfUnderscore = shortFileName.indexOf("_");
                if (indexOfUnderscore > -1) {
                    segments[segments.length - 1] = shortFileName.substring(0, indexOfUnderscore);
                }
                sb.append(segments[2]);
                int i = 3;
                while (i < segments.length) {
                    sb.append("/");
                    sb.append(segments[i]);
                    ++i;
                }
                retVal.add(sb.toString());
            }
        }
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
        }
        return retVal;
    }

    public void doCoreClassPathSettings(Object project, boolean isJSP, boolean isSmartSync) throws Exception {
        List<String> coreClassPath = new ArrayList();
        MDKInstallation mdk = MDKInstallation.getInstance();
        URL url = new URL("file:/" + mdk.getJavadocFolder());
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        IDESettings iset = IDESettings.getInstance();
        String projectPath = ideInstance.getCurrentProjectFolder(project);
        Path projectLocation = new Path(mdk.getWarMEgApiFileName());
        JavaUI.setLibraryJavadocLocation((IPath)projectLocation, (URL)url);
        MDKInstallation mdkinst = MDKInstallation.getInstance();
        coreClassPath = mdkinst.getListofJars(isJSP);
        boolean noJarListFile = coreClassPath.isEmpty();
        coreClassPath.add(MIPlugin.getEclipseFolder() + File.separator + mdk.getMDKApiRelativeFileName());
        if (isJSP) {
            coreClassPath.add(iset.getToolsjar());
        }
        if (noJarListFile) {
            coreClassPath.clear();
            if (isJSP) {
                coreClassPath.add(mdkinst.getWarServletApiFileName());
                coreClassPath.add(mdkinst.getWarMEgApiFileName());
                coreClassPath.add(mdkinst.getWarMElApiFileName());
                coreClassPath.add(mdkinst.getTomcatApiFileName());
                coreClassPath.add(mdkinst.getJspApiFileName());
                coreClassPath.add(MIPlugin.getEclipseFolder() + File.separator + mdk.getMDKApiRelativeFileName());
                coreClassPath.add(iset.getToolsjar());
            } else {
                coreClassPath.add(mdkinst.getWarMEgApiFileName());
                coreClassPath.add(mdkinst.getWarMElApiFileName());
                coreClassPath.add(MIPlugin.getEclipseFolder() + File.separator + mdk.getMDKApiRelativeFileName());
            }
        }
        StringBasedFileFilter recFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments[0].equals(ME21.APPL_FOLDER)) {
                    if (segments.length == 1) {
                        return true;
                    }
                    if (segments.length == 2) {
                        if (segments[1].equals(ME21.APPL_WEBINF)) {
                            return true;
                        }
                    } else {
                        return segments[2].equals("lib");
                    }
                }
                return false;
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments.length < 4) {
                    return false;
                }
                return segments[0].equals(ME21.APPL_FOLDER) && segments[1].equals(ME21.APPL_WEBINF) && segments[2].equals("lib") && segments[3].endsWith(".jar");
            }
        };
        List libJarFiles = OpentoolsFactory.getIDEInstance().getAllFilesInProject(project, acceptFilter, recFilter);
        Iterator it = libJarFiles.iterator();
        while (it.hasNext()) {
            String[] segments = (String[])it.next();
            coreClassPath.add((String)((Object)OpentoolsFactory.getIDEInstance().getFileObjectFor(project, segments)));
        }
        OpentoolsFactory.getIDEInstance().adjustProjectClassPathTo(project, coreClassPath, "core", false);
    }

    public AbstractProfiles getCurrentProfiles(Object project) throws Exception {
        IDE ide = OpentoolsFactory.getIDEInstance();
        StringBasedFileFilter recFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments[0].equals("private")) {
                    if (segments.length == 1) {
                        return true;
                    }
                    if (segments[1].equals("profiles")) {
                        return segments.length == 2;
                    }
                    return false;
                }
                return false;
            }
        };
        StringBasedFileFilter acceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                if (segments.length != 3) {
                    return false;
                }
                return segments[0].equals("private") && segments[1].equals("profiles") && segments[2].endsWith(".properties");
            }
        };
        List allProfileFileNameSegments = ide.getAllFilesInProject(project, acceptFilter, recFilter);
        File[] profileFilesAr = new File[allProfileFileNameSegments.size()];
        int i = 0;
        while (i < allProfileFileNameSegments.size()) {
            profileFilesAr[i] = ide.getFileObjectFor(project, (String[])allProfileFileNameSegments.get(i));
            ++i;
        }
        return new Profiles(project, profileFilesAr);
    }

    public boolean isComponentProject(Object project) {
        try {
            return this.isPossibleComponentRootFolder(new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project)));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isPossibleComponentRootFolder(File folder) {
        return Files.doesFileExist(folder.toString() + File.separatorChar + APPL_FOLDER + File.separatorChar + APPL_WEBINF + File.separatorChar + "web.xml");
    }

    public boolean isJSPProject(Object project) {
        try {
            return this.isPossibleJSPFolder(new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project)));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isJSPProjectDeployed(MDKInstallation mdk, String webapp) {
        return Files.isFolder(mdk.getInstFolderMETom() + WEBAPPS_FOLDER + webapp);
    }

    public boolean isPossibleJSPFolder(File folder) {
        return new File(folder, "app-root/WEB-INF/web.xml").exists();
    }

    public boolean isSmartSyncProject(Object project) {
        try {
            return this.isPossibleSmartSyncRootFolder(new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project)));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isPossibleSmartSyncRootFolder(File folder) {
        return Files.doesFileExist(folder.toString() + File.separatorChar + APPL_FOLDER + File.separatorChar + APPL_WEBINF + File.separatorChar + "core.configure");
    }

    public boolean hasResourceBundles(Object project) {
        try {
            return this.isPossibleResourceBundleFolder(new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project)));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isPossibleResourceBundleFolder(File folder) {
        return new File(folder, "app-root/properties/*.properties").exists();
    }

    public boolean isServiceProject(Object project) {
        try {
            return OpentoolsFactory.getIDEInstance().getFileObjectFor(project, new String[]{"config", "service.xml"}).exists();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void createNewMEJSPBasicsInProject(Object project, String pname, String classname, String cFileName, String jspName, String meApplicationName, String beanName) throws Exception {
        String packagename = pname;
        if (packagename.endsWith(".")) {
            packagename = packagename.substring(0, packagename.length() - 2);
        }
        String constantFileName = cFileName.toLowerCase();
        boolean hasExt = false;
        if (constantFileName.endsWith(".java")) {
            hasExt = true;
        }
        constantFileName = cFileName;
        if (hasExt) {
            constantFileName = cFileName.substring(0, cFileName.length() - 6);
        }
        String fqJSPFileName = null;
        String jspFileName = jspName.toLowerCase();
        hasExt = false;
        if (jspFileName.endsWith(".jsp")) {
            hasExt = true;
        }
        jspFileName = jspName;
        if (!(jspFileName = jspFileName.replace('\\', '/')).startsWith("/")) {
            jspFileName = "/" + jspFileName;
        }
        if (!hasExt) {
            jspFileName = jspFileName + ".jsp";
        }
        fqJSPFileName = "/app-root" + jspFileName;
        String fqClassName = null;
        String fqConstantsName = null;
        String packageDeclaration = APPL_FOLDER_WARFILE;
        String beanfqName = APPL_FOLDER_WARFILE;
        if (packagename.trim().length() > 0) {
            fqClassName = packagename + "." + classname;
            fqConstantsName = packagename + "." + constantFileName;
            packageDeclaration = "package " + packagename;
            beanfqName = packagename + ".bean." + beanName;
        } else {
            fqClassName = classname;
            beanfqName = "bean." + beanName;
        }
        HashMap<String, String> varNamesToValues = new HashMap<String, String>();
        varNamesToValues.put("package-declaration", "package " + packagename);
        varNamesToValues.put("package-name", packagename);
        varNamesToValues.put("class-name", classname);
        varNamesToValues.put("fq-class-name", fqClassName);
        varNamesToValues.put("mi-application-name", meApplicationName);
        varNamesToValues.put("constants-file-name", constantFileName);
        varNamesToValues.put("bean-name", beanName);
        varNamesToValues.put("bean-fqname", beanfqName);
        varNamesToValues.put("jsp-file-name", jspFileName);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, fqClassName, "projecttemplates/jsp/MainClass.template", varNamesToValues);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, fqConstantsName, "projecttemplates/jsp/ProjectConstants.template", varNamesToValues);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, beanfqName, "projecttemplates/jsp/ProjectBean.template", varNamesToValues);
        MIPlugin.createAnyFileFromTemplate((IProject)project, fqJSPFileName, "projecttemplates/jsp/JSP.template", varNamesToValues);
        MIPlugin.createAnyFileFromTemplate((IProject)project, "app-root/WEB-INF/web.xml", "projecttemplates/jsp/Projectwebxml.template", varNamesToValues);
    }

    public void createNewMEAWTBasicsInProject(Object project, String pname, String classname, String cFileName, String meApplicationName) throws Exception {
        String packagename = pname;
        if (packagename.endsWith(".")) {
            packagename = packagename.substring(0, packagename.length() - 2);
        }
        String constantFileName = cFileName.toLowerCase();
        boolean hasExt = false;
        if (constantFileName.endsWith(".java")) {
            hasExt = true;
        }
        constantFileName = cFileName;
        if (hasExt) {
            constantFileName = cFileName.substring(0, cFileName.length() - 6);
        }
        String fqClassName = null;
        String fqConstantsName = null;
        String packageDeclaration = APPL_FOLDER_WARFILE;
        if (packagename.trim().length() > 0) {
            fqClassName = packagename + "." + classname;
            fqConstantsName = packagename + "." + constantFileName;
            packageDeclaration = "package " + packagename;
        } else {
            fqClassName = classname;
        }
        HashMap<String, String> varNamesToValues = new HashMap<String, String>();
        varNamesToValues.put("package-declaration", "package " + packagename);
        varNamesToValues.put("package-name", packagename);
        varNamesToValues.put("class-name", classname);
        varNamesToValues.put("fq-class-name", fqClassName);
        varNamesToValues.put("mi-application-name", meApplicationName);
        varNamesToValues.put("constants-file-name", constantFileName);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, fqClassName, "projecttemplates/awt/MainClass.template", varNamesToValues);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, fqConstantsName, "projecttemplates/awt/ProjectConstants.template", varNamesToValues);
        MIPlugin.createAnyFileFromTemplate((IProject)project, "app-root/META-INF/MANIFEST.MF", "projecttemplates/awt/Manifest.template", varNamesToValues);
        MIPlugin.createAnyFileFromTemplate((IProject)project, "app-root/META-INF/SAP_MANIFEST.MF", "projecttemplates/awt/SAPManifest.template", varNamesToValues);
    }

    public void createNewMEJSPSmartSyncProject(Object project, String pname, String xmlfile, String classname, String cFileName, String meApplicationName, String beanName) throws Exception {
        String packagename = pname;
        if (packagename.endsWith(".")) {
            packagename = packagename.substring(0, packagename.length() - 2);
        }
        String constantFileName = cFileName.toLowerCase();
        boolean hasExt = false;
        if (constantFileName.endsWith(".java")) {
            hasExt = true;
        }
        constantFileName = cFileName;
        if (hasExt) {
            constantFileName = cFileName.substring(0, cFileName.length() - 6);
        }
        String jspFolderName = "/app-root/jsp/";
        String jspFile_1 = "detail_syncboinstance";
        String jspFile_2 = "overview_syncboinstances";
        String jspFile_3 = "overview_syncbonames";
        String fqJSPFilename_1 = jspFolderName + jspFile_1 + ".jsp";
        String fqJSPFilename_2 = jspFolderName + jspFile_2 + ".jsp";
        String fqJSPFilename_3 = jspFolderName + jspFile_3 + ".jsp";
        String fqClassName = null;
        String fqConstantsName = null;
        String packageDeclaration = APPL_FOLDER_WARFILE;
        String beanfqName = APPL_FOLDER_WARFILE;
        String dbAccessPackage = APPL_FOLDER_WARFILE;
        if (packagename.trim().length() > 0) {
            fqClassName = packagename + "." + classname;
            fqConstantsName = packagename + "." + constantFileName;
            packageDeclaration = "package " + packagename;
            beanfqName = packagename + ".bean." + beanName;
            dbAccessPackage = packagename + ".dataaccess.";
        } else {
            fqClassName = classname;
            beanfqName = "bean." + beanName;
            dbAccessPackage = "dataaccess.";
        }
        HashMap<String, String> varNamesToValues = new HashMap<String, String>();
        varNamesToValues.put("package-declaration", "package " + packagename);
        varNamesToValues.put("package-name", packagename);
        varNamesToValues.put("class-name", classname);
        varNamesToValues.put("fq-class-name", fqClassName);
        varNamesToValues.put("mi-application-name", meApplicationName);
        varNamesToValues.put("constants-file-name", constantFileName);
        varNamesToValues.put("bean-name", beanName);
        varNamesToValues.put("bean-fqname", beanfqName);
        varNamesToValues.put("jsp-file-name_1", fqJSPFilename_1);
        varNamesToValues.put("jsp-file-name_2", fqJSPFilename_2);
        varNamesToValues.put("jsp-file-name_3", fqJSPFilename_3);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, fqClassName, "projecttemplates/jsp/smartsync/MainClass.template", varNamesToValues);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, fqConstantsName, "projecttemplates/jsp/smartsync/ProjectConstants.template", varNamesToValues);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, beanfqName, "projecttemplates/jsp/smartsync/ProjectBean.template", varNamesToValues);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, dbAccessPackage + "SmartSyncDBAccess", "projecttemplates/jsp/smartsync/SmartSyncDBAccess.template", varNamesToValues);
        MIPlugin.createJavaFileFromTemplateAndOpenIt((IProject)project, dbAccessPackage + "TableContentProvider", "projecttemplates/jsp/smartsync/TableContentProvider.template", varNamesToValues);
        MIPlugin.createAnyFileFromTemplate((IProject)project, fqJSPFilename_1, "projecttemplates/jsp/smartsync/" + jspFile_1 + "_jsp.template", varNamesToValues);
        MIPlugin.createAnyFileFromTemplate((IProject)project, fqJSPFilename_2, "projecttemplates/jsp/smartsync/" + jspFile_2 + "_jsp.template", varNamesToValues);
        MIPlugin.createAnyFileFromTemplate((IProject)project, fqJSPFilename_3, "projecttemplates/jsp/smartsync/" + jspFile_3 + "_jsp.template", varNamesToValues);
        MIPlugin.createAnyFileFromTemplate((IProject)project, "app-root/WEB-INF/web.xml", "projecttemplates/jsp/smartsync/Projectwebxml.template", varNamesToValues);
        MIPlugin.copyFilesToProject((IProject)project, xmlfile, APPL_FOLDER_DEST + Files.getFileName(xmlfile));
        MIPlugin.copyFoldersToProject((IProject)project, "projecttemplates/jsp/css", "app-root/css");
        MIPlugin.copyFoldersToProject((IProject)project, "projecttemplates/jsp/mimes", "app-root/mimes");
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        ideInstance.updateProjectFromFilesSystem(project, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
    }

    public void createServiceClassInCurrentProject(Object project, String packageS, String className, int aPIOrNot) throws Exception {
        if (packageS != null && !packageS.trim().equals(APPL_FOLDER_WARFILE)) {
            packageS = packageS.trim();
            while (packageS.endsWith(".")) {
                packageS = packageS.substring(0, packageS.length() - 1);
            }
            while (packageS.startsWith(".")) {
                packageS = packageS.substring(1, packageS.length());
            }
        }
        String fullyQualifiedClassName = packageS + "." + className.trim();
        String packageDeclaration = APPL_FOLDER_WARFILE;
        if (packageS != null && !packageS.trim().equals(APPL_FOLDER_WARFILE)) {
            packageDeclaration = "package " + packageS + ";\n";
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("package-declaration", packageDeclaration);
        values.put("class-name", className);
        InputStream template = null;
        template = aPIOrNot == 0 ? this.getClass().getResourceAsStream("ApiServiceTemplate.xml") : this.getClass().getResourceAsStream("CoreServiceTemplate.xml");
        File javaSourceFile = OpentoolsFactory.getIDEInstance().createJavaSourceFileInCurrentProject(project, fullyQualifiedClassName, aPIOrNot);
        FileWriter sourceWrite = new FileWriter(javaSourceFile);
        Templating.writeTemplateToWriter(values, template, sourceWrite);
        sourceWrite.close();
    }

    public Object createNewMEProjectFromWar(String projectRootFolderName, String projectName, File parFile) throws Exception {
        Object project = this.createNewMIProjectBasicFunctions(projectRootFolderName, projectName);
        IDE ide = OpentoolsFactory.getIDEInstance();
        this.unpackWarArchive(project, parFile);
        ide.updateProjectFromFilesSystem(project, new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                return segments.length != 3 || !segments[0].equals(ME21.APPL_FOLDER) || !segments[1].equals(ME21.APPL_WEBINF) || !segments[2].equals("lib") || !segments[3].endsWith(".jar");
            }
        });
        this.doCoreClassPathSettings(project, true, false);
        AbstractProfiles currentProfiles = this.getCurrentProfiles(project);
        currentProfiles.updateClasspath();
        return project;
    }

    public Object createNewMIProjectBasicFunctions(String projectRootRootFolder, String projectName) throws Exception {
        File projectFolder = new File(projectRootRootFolder, projectName);
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        Object project = ideInstance.prepareNewProject(projectFolder, new String[]{SRC_FOLDER}, new String[]{APPL_FOLDER, APPL_WEBINF, CLASSES_FOLDER});
        this.createMIProjectFileAndFolderStructure(projectRootRootFolder, projectName);
        ideInstance.updateProjectFromFilesSystem(project, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        return project;
    }

    public Object createNewIViewProject(String projectRootRootFolder, String projectName) throws Exception {
        Object project = this.createNewMIProjectBasicFunctions(projectRootRootFolder, projectName);
        this.doCoreClassPathSettings(project, true, false);
        return project;
    }

    public Object createNewSmartSyncProject(String projectRootRootFolder, String projectName, boolean extended) throws Exception {
        Object project = this.createNewMIProjectBasicFunctions(projectRootRootFolder, projectName);
        if (extended) {
            this.createMIProjectExtendedFolderStructure(project, projectRootRootFolder, projectName);
        }
        this.doCoreClassPathSettings(project, true, true);
        return project;
    }

    public Object createNewAWTProject(String projectRootPath, String projectName) throws Exception {
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        File projectFolder = this.createAWTProjectFileStructure(projectRootPath, projectName);
        Object project = ideInstance.prepareNewProject(projectFolder, new String[]{SRC_FOLDER}, new String[]{CLASSES_FOLDER});
        ideInstance.updateProjectFromFilesSystem(project, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        this.doCoreClassPathSettings(project, false, false);
        return project;
    }

    public File createNewAWTProjectFromJar(String projectRootPath, String projectName, File jarFile) throws Exception {
        File projectFolder = null;
        if (this.isValidAWTJarArchive(jarFile)) {
            Object project = this.createNewAWTProject(projectRootPath, projectName);
            projectFolder = new File(OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project));
            this.unpackJarArchive(project, jarFile);
            OpentoolsFactory.getIDEInstance().updateProjectFromFilesSystem(project, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        }
        return projectFolder;
    }

    protected void createZipFileOfZipNameToInputStreamHashMap(File zipFile, HashMap zipNameToInputStream, HashMap zipEmptyFoldersToInputStream, boolean compileJSP) throws IOException {
        zipFile.getParentFile().mkdirs();
        if (!zipFile.exists()) {
            zipFile.createNewFile();
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        Set entryNames = zipNameToInputStream.keySet();
        Iterator iterator = entryNames.iterator();
        while (iterator.hasNext()) {
            String entryName = (String)iterator.next();
            ZipEntry entry = new ZipEntry(entryName);
            if (compileJSP && entry.toString().endsWith(".jsp")) continue;
            zos.putNextEntry(entry);
            Stream.copyStream((InputStream)zipNameToInputStream.get(entryName), zos);
            zos.closeEntry();
        }
        if (zipEmptyFoldersToInputStream != null) {
            entryNames = zipEmptyFoldersToInputStream.keySet();
            Iterator iterator2 = entryNames.iterator();
            while (iterator2.hasNext()) {
                String entryName = (String)iterator2.next();
                ZipEntry entry = new ZipEntry(entryName);
                zos.putNextEntry(entry);
                zos.closeEntry();
            }
        }
        zos.close();
    }

    protected void addDirectoryToZipFileRecursively(String zipEntryNamePrefix, File directory, ZipOutputStream zipFile, FileFilter filter) throws IOException {
        zipEntryNamePrefix = zipEntryNamePrefix == null || zipEntryNamePrefix.trim().equals(APPL_FOLDER_WARFILE) ? APPL_FOLDER_WARFILE : zipEntryNamePrefix + "/";
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getAbsolutePath().endsWith(".dependency") || pathname.isDirectory();
            }
        });
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = zipEntryNamePrefix + file.getName();
            if (file.isDirectory()) {
                this.addDirectoryToZipFileRecursively(name, file, zipFile, filter);
            } else {
                if (filter.accept(file)) {
                    ZipEntry newEntry = new ZipEntry(name);
                    newEntry.setSize(file.length());
                    zipFile.putNextEntry(newEntry);
                    Stream.copyStream(new FileInputStream(file), zipFile);
                }
                zipFile.closeEntry();
            }
            ++i;
        }
    }

    public void unpackWarArchive(Object project, File zipFile) throws Exception {
        int lastSlash;
        IDE ide = OpentoolsFactory.getIDEInstance();
        String targetProjectFolderString = ide.getCurrentProjectFolder(project);
        File srcPath = ide.getSrcPath(project, 0);
        File publicFolder = new File(targetProjectFolderString, APPL_FOLDER);
        String pureProjectName = zipFile.toString();
        if (pureProjectName.endsWith(".war")) {
            pureProjectName = pureProjectName.substring(0, pureProjectName.length() - 4);
        }
        if ((lastSlash = pureProjectName.lastIndexOf(47)) < 0) {
            lastSlash = pureProjectName.lastIndexOf(92);
        }
        if (lastSlash > 0) {
            pureProjectName = pureProjectName.substring(lastSlash + 1);
        }
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String entryName = entry.getName();
            if (entry.isDirectory() || entryName.equalsIgnoreCase(APPL_LIB_FOLDER + pureProjectName + ".jar")) continue;
            if (Strings.startsWithIgnoreCase(entryName, APPL_FOLDER_DEST)) {
                Stream.writeStreamToFile(targetProjectFolderString + "/" + APPL_FOLDER_DEST + entryName, zip.getInputStream(entry));
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "private/")) {
                Stream.writeStreamToFile(targetProjectFolderString + "/" + APPL_FOLDER_DEST + entryName, zip.getInputStream(entry));
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, APPL_SRCLIB) && Strings.countCharOccurence(entryName, '/') == 2 && (entryName.endsWith(".src.zip") || entryName.endsWith(".src.jar"))) {
                this.extractZipEntryThatIsAZip(zip, entry, srcPath);
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, APPL_SRCLIB) && Strings.countCharOccurence(entryName, '/') == 2 && (entryName.endsWith(".jsp.zip") || entryName.endsWith(".jsp.jar"))) {
                this.extractZipEntryThatIsAZip(zip, entry, publicFolder);
                continue;
            }
            if (entryName.endsWith(".properties")) continue;
            Stream.writeStreamToFile(targetProjectFolderString + "/" + APPL_FOLDER_DEST + entryName, zip.getInputStream(entry));
        }
        zip.close();
    }

    public void unpackParArchive(Object project, File zipFile) throws Exception {
        IDE ide = OpentoolsFactory.getIDEInstance();
        String targetProjectFolderString = ide.getCurrentProjectFolder(project);
        File srcPath = ide.getSrcPath(project, 0);
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            String entryName;
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory() || (entryName = entry.getName()).equalsIgnoreCase("META-INF/Manifest.mf")) continue;
            if (Strings.startsWithIgnoreCase(entryName, "public/")) {
                Stream.writeStreamToFile(targetProjectFolderString + "/" + entryName, zip.getInputStream(entry));
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "private/srclib/") && Strings.countCharOccurence(entryName, '/') == 2 && (entryName.endsWith(".src.zip") || entryName.endsWith(".src.jar"))) {
                this.extractZipEntryThatIsAZip(zip, entry, srcPath);
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "private/")) {
                Stream.writeStreamToFile(targetProjectFolderString + "/" + entryName, zip.getInputStream(entry));
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, SRC_LIB_FOLDER) && Strings.countCharOccurence(entryName, '/') == 2 && (entryName.endsWith(".src.zip") || entryName.endsWith(".src.jar"))) {
                this.extractZipEntryThatIsAZip(zip, entry, srcPath);
                continue;
            }
            if (this.isAPrivateResource(entryName)) {
                Stream.writeStreamToFile(targetProjectFolderString + "/" + entryName, zip.getInputStream(entry));
                continue;
            }
            Stream.writeStreamToFile(targetProjectFolderString + "/" + entryName, zip.getInputStream(entry));
        }
        zip.close();
    }

    private void extractZipEntryThatIsAZip(ZipFile zip, ZipEntry entry, File targetFolder) throws IOException {
        File tmpZipFile = File.createTempFile("TEMPFILE", "SUFFIX");
        Stream.copyAndCloseStream(zip.getInputStream(entry), new FileOutputStream(tmpZipFile));
        this.unpackZipArchive(targetFolder, tmpZipFile);
        tmpZipFile.delete();
    }

    public void unpackZipArchive(File targetFolder, File zFile) throws IOException {
        ZipFile zipFile = new ZipFile(zFile);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            String entryName;
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory()) continue;
            String fileName = entryName = entry.getName();
            fileName = fileName.replace('/', File.separatorChar);
            File f = new File(targetFolder, fileName);
            try {
                f.getParentFile().mkdirs();
            }
            catch (Exception e) {
                JavaPlugin.log((Throwable)e);
            }
            if (!f.exists()) {
                f.createNewFile();
            }
            Stream.copyStream(zipFile.getInputStream(entry), new FileOutputStream(f));
        }
        zipFile.close();
    }

    protected boolean isAPrivateResource(String name) {
        return Strings.startsWithIgnoreCase(name, "xml/") || Strings.startsWithIgnoreCase(name, "xsl/") || Strings.startsWithIgnoreCase(name, "properties/") || Strings.startsWithIgnoreCase(name, "profiles/") || Strings.startsWithIgnoreCase(name, "lib/") || Strings.startsWithIgnoreCase(name, SRC_LIB_FOLDER) || Strings.startsWithIgnoreCase(name, "classes/") || Strings.startsWithIgnoreCase(name, "taglib") || Strings.startsWithIgnoreCase(name, "config/") || Strings.startsWithIgnoreCase(name, "meta-inf/") || Strings.startsWithIgnoreCase(name, "pagelet/") || Strings.startsWithIgnoreCase(name, "jsp/");
    }

    public boolean uploadParFile(File parFile) throws Exception {
        MDKInstallation pdkInst = MDKInstallation.getInstance();
        return pdkInst.uploadPARArchive(parFile);
    }

    protected boolean isCoreClass(Object project, File aPathname) throws Exception {
        if (aPathname.isDirectory()) {
            return false;
        }
        File srcCoreDirectory = OpentoolsFactory.getIDEInstance().getSrcPath(project, 1);
        String parameterName = aPathname.getName();
        StringTokenizer parameterPatern = new StringTokenizer(parameterName, ".");
        String patern = parameterPatern.nextToken();
        StringTokenizer parameterPatern2 = new StringTokenizer(patern, "$");
        String finalPatern = parameterPatern2.nextToken();
        finalPatern = finalPatern + ".java";
        boolean result = this.isContained(srcCoreDirectory, finalPatern);
        return result;
    }

    private boolean isContained(File aSource, String aPatern) {
        boolean temp = false;
        if (aSource.isDirectory()) {
            File[] theFiles = aSource.listFiles();
            int i = 0;
            while (i < theFiles.length) {
                if (temp) {
                    return true;
                }
                temp = this.isContained(theFiles[i], aPatern);
                ++i;
            }
        } else if (aSource.getName().toString().equals(aPatern)) {
            return true;
        }
        return temp;
    }

    protected void addVisibleFilesToInputStreamMapRecursively(final Object project, final String[] parentDir, final String zipPrefix, final HashMap zipNameToInputStreamMap, final StringBasedFileFilter acceptFilter) throws IOException {
        if (parentDir == null) {
            return;
        }
        final IDE ideInstance = OpentoolsFactory.getIDEInstance();
        StringBasedFileFilter recursionFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                int i = 0;
                while (i < segments.length && i < parentDir.length) {
                    if (!segments[i].equals(parentDir[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
        StringBasedFileFilter fullAcceptAcceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) throws IOException {
                if (isDir) {
                    return false;
                }
                if (acceptFilter.accept(segments, isDir)) {
                    File f;
                    if (segments.length < parentDir.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < parentDir.length) {
                        if (!parentDir[i].equals(segments[i])) {
                            return false;
                        }
                        ++i;
                    }
                    StringBuffer fileName = new StringBuffer(zipPrefix);
                    int i2 = parentDir.length;
                    while (i2 < segments.length) {
                        fileName.append("/");
                        fileName.append(segments[i2]);
                        ++i2;
                    }
                    if (fileName.charAt(0) == '/') {
                        fileName.deleteCharAt(0);
                    }
                    if (!(f = ideInstance.getFileObjectFor(project, segments)).exists()) {
                        throw new FileNotExistException(f, segments, project);
                    }
                    zipNameToInputStreamMap.put(fileName.toString(), new FileInputStream(f));
                }
                return false;
            }
        };
        ideInstance.getAllFilesInProject(project, fullAcceptAcceptFilter, recursionFilter);
    }

    protected void addEmptyFoldersToInputStreamMapRecursively(Object project, final String[] parentDir, final String zipPrefix, final HashMap zipNameToInputStreamMap, StringBasedFileFilter acceptFilter) throws IOException {
        if (parentDir == null) {
            return;
        }
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        StringBasedFileFilter recursionFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) {
                int i = 0;
                while (i < segments.length && i < parentDir.length) {
                    if (!segments[i].equals(parentDir[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
        StringBasedFileFilter fullAcceptAcceptFilter = new StringBasedFileFilter(){

            public boolean accept(String[] segments, boolean isDir) throws IOException {
                StringBuffer fileName = new StringBuffer(zipPrefix);
                int i = parentDir.length;
                while (i < segments.length) {
                    fileName.append("/");
                    fileName.append(segments[i]);
                    ++i;
                }
                fileName.append("/");
                if (fileName.charAt(0) == '/') {
                    fileName.deleteCharAt(0);
                }
                zipNameToInputStreamMap.put(fileName.toString(), null);
                return false;
            }
        };
        ideInstance.getEmptyFoldersInProject(project, fullAcceptAcceptFilter, recursionFilter);
    }

    public void makeWarArchiveFromProject(Object project, String parName, File target, boolean createSrcLibJar, boolean resourceBundlesInJar, boolean classesInJar, boolean compiledJSP) throws IOException, Exception, Exception {
        ZipOutputStream srcZos;
        File srcJarFile;
        HashMap<String, FileInputStream> zipEntryNamesToInputStreams = new HashMap<String, FileInputStream>();
        HashMap zipEntryEmptyFoldersToInputStreams = new HashMap();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        File classesDirectory = ideInstance.getOutPath(project, 0);
        File srcDirectory = ideInstance.getFileObjectFor(project, new String[]{SRC_FOLDER});
        boolean fileInZip = classesInJar;
        if (classesDirectory.exists() && classesDirectory.isDirectory()) {
            File parClassJarFile = File.createTempFile(parName + "TMP", "jar");
            parClassJarFile.deleteOnExit();
            ZipOutputStream classesZos = new ZipOutputStream(new FileOutputStream(parClassJarFile));
            this.addDirectoryToZipFileRecursively(APPL_FOLDER_WARFILE, classesDirectory, classesZos, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".class") || pathname.isDirectory();
                }
            });
            if (resourceBundlesInJar) {
                this.addDirectoryToZipFileRecursively(APPL_FOLDER_WARFILE, srcDirectory, classesZos, new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getAbsolutePath().endsWith(".properties") || pathname.isDirectory();
                    }
                });
            }
            try {
                classesZos.close();
            }
            catch (IOException e) {
                fileInZip = false;
            }
            if (fileInZip) {
                zipEntryNamesToInputStreams.put(APPL_LIB_FOLDER + parName + ".jar", new FileInputStream(parClassJarFile));
            }
        }
        if (createSrcLibJar) {
            fileInZip = true;
            srcJarFile = File.createTempFile(parName + "TMP", "src.zip");
            srcJarFile.deleteOnExit();
            srcZos = new ZipOutputStream(new FileOutputStream(srcJarFile));
            int i = 0;
            while (i < ideInstance.getSourcePathCount(project)) {
                srcDirectory = ideInstance.getSrcPath(project, i);
                this.addDirectoryToZipFileRecursively(APPL_FOLDER_WARFILE, srcDirectory, srcZos, acceptDirAndDotJavasAndPropertiesFilter);
                ++i;
            }
            try {
                srcZos.close();
            }
            catch (IOException e) {
                fileInZip = false;
            }
            if (fileInZip) {
                zipEntryNamesToInputStreams.put(APPL_SRCLIB + parName + ".src.zip", new FileInputStream(srcJarFile));
            }
        }
        if (compiledJSP && createSrcLibJar) {
            fileInZip = true;
            srcJarFile = File.createTempFile(parName + "TMP", "jsp.zip");
            srcJarFile.deleteOnExit();
            srcZos = new ZipOutputStream(new FileOutputStream(srcJarFile));
            srcDirectory = ideInstance.getFileObjectFor(project, new String[]{APPL_FOLDER});
            this.addDirectoryToZipFileRecursively(APPL_FOLDER_WARFILE, srcDirectory, srcZos, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".jsp") || pathname.isDirectory();
                }
            });
            try {
                srcZos.close();
            }
            catch (IOException e) {
                fileInZip = false;
            }
            if (fileInZip) {
                zipEntryNamesToInputStreams.put(APPL_SRCLIB + parName + ".jsp.zip", new FileInputStream(srcJarFile));
            }
        }
        if (classesInJar) {
            this.addVisibleFilesToInputStreamMapRecursively(project, new String[]{APPL_FOLDER}, APPL_FOLDER_WARFILE, zipEntryNamesToInputStreams, exceptPropertiesClasses);
            this.addEmptyFoldersToInputStreamMapRecursively(project, new String[]{APPL_FOLDER}, APPL_FOLDER_WARFILE, zipEntryEmptyFoldersToInputStreams, exceptPropertiesClasses);
        } else {
            this.addVisibleFilesToInputStreamMapRecursively(project, new String[]{APPL_FOLDER}, APPL_FOLDER_WARFILE, zipEntryNamesToInputStreams, withPropertiesClasses);
            this.addEmptyFoldersToInputStreamMapRecursively(project, new String[]{APPL_FOLDER}, APPL_FOLDER_WARFILE, zipEntryEmptyFoldersToInputStreams, withPropertiesClasses);
        }
        List folderNames = ideInstance.getAllFilesInProject(project, reject_privateClassesSrcSrclib, recurseToPrivateFilter);
        if (!resourceBundlesInJar) {
            this.addVisibleFilesToInputStreamMapRecursively(project, new String[]{SRC_FOLDER}, APPL_CLASSES, zipEntryNamesToInputStreams, onlyPropertiesunderSRC_FOLDER);
        }
        this.createZipFileOfZipNameToInputStreamHashMap(target, zipEntryNamesToInputStreams, zipEntryEmptyFoldersToInputStreams, compiledJSP);
    }

    public void makexParArchiveFromProject(Object project, String parName, File target, boolean createSrcLibJar) throws IOException, Exception, Exception {
        HashMap<String, FileInputStream> zipEntryNamesToInputStreams = new HashMap<String, FileInputStream>();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        File classesDirectory = ideInstance.getOutPath(project, 0);
        if (classesDirectory.exists() && classesDirectory.isDirectory()) {
            File parClassJarFile = File.createTempFile(parName + "TMP", "jar");
            parClassJarFile.deleteOnExit();
            ZipOutputStream classesZos = new ZipOutputStream(new FileOutputStream(parClassJarFile));
            this.addDirectoryToZipFileRecursively(APPL_FOLDER_WARFILE, classesDirectory, classesZos, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".class") || pathname.isDirectory();
                }
            });
            try {
                classesZos.close();
            }
            catch (IOException e) {
                JavaPlugin.log((Throwable)e);
            }
            zipEntryNamesToInputStreams.put(APPL_LIB_FOLDER + parName + ".jar", new FileInputStream(parClassJarFile));
        }
        if (createSrcLibJar) {
            File srcJarFile = File.createTempFile(parName + "TMP", "src.zip");
            srcJarFile.deleteOnExit();
            ZipOutputStream srcZos = new ZipOutputStream(new FileOutputStream(srcJarFile));
            int i = 0;
            while (i < ideInstance.getSourcePathCount(project)) {
                File srcDirectory = ideInstance.getSrcPath(project, i);
                this.addDirectoryToZipFileRecursively(APPL_FOLDER_WARFILE, srcDirectory, srcZos, acceptDirAndDotJavasFilter);
                ++i;
            }
            srcZos.close();
            zipEntryNamesToInputStreams.put(APPL_SRCLIB + parName + ".src.zip", new FileInputStream(srcJarFile));
        }
        this.addVisibleFilesToInputStreamMapRecursively(project, new String[]{WAR_SRC_FOLDER}, APPL_CLASSES, zipEntryNamesToInputStreams, rejectDotJavasAcceptDirs);
        this.addVisibleFilesToInputStreamMapRecursively(project, new String[]{"public"}, "public", zipEntryNamesToInputStreams, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        List folderNames = ideInstance.getAllFilesInProject(project, reject_privateClassesSrcSrclib, recurseToPrivateFilter);
        Iterator iterator = folderNames.iterator();
        while (iterator.hasNext()) {
            String[] folderOfPrivate = (String[])iterator.next();
            this.addVisibleFilesToInputStreamMapRecursively(project, folderOfPrivate, "private/" + folderOfPrivate[1], zipEntryNamesToInputStreams, StringBasedFileFilter.ACCEPT_EVERYTHING_FILE_FILTER);
        }
        this.createZipFileOfZipNameToInputStreamHashMap(target, zipEntryNamesToInputStreams, null, false);
    }

    public void makeJarArchiveFromProject(Object project, String parName, File target, boolean createSrcLibJar) throws Exception {
        HashMap<String, FileInputStream> zipEntryNamesToInputStreams = new HashMap<String, FileInputStream>();
        IDE ideInstance = OpentoolsFactory.getIDEInstance();
        String classesDirectoryS = ideInstance.getOutPathRelative(project, 0);
        if (createSrcLibJar) {
            File srcJarFile = File.createTempFile(parName + "TMP", "src.zip");
            srcJarFile.deleteOnExit();
            ZipOutputStream srcZos = new ZipOutputStream(new FileOutputStream(srcJarFile));
            int i = 0;
            while (i < ideInstance.getSourcePathCount(project)) {
                File srcDirectory = ideInstance.getSrcPath(project, i);
                this.addDirectoryToZipFileRecursively(APPL_FOLDER_WARFILE, srcDirectory, srcZos, acceptDirAndDotJavasAndPropertiesFilter);
                ++i;
            }
            srcZos.close();
            zipEntryNamesToInputStreams.put(SRC_LIB_FOLDER + parName + ".src.zip", new FileInputStream(srcJarFile));
        }
        this.addVisibleFilesToInputStreamMapRecursively(project, new String[]{classesDirectoryS}, APPL_FOLDER_WARFILE, zipEntryNamesToInputStreams, rejectDotJavasAcceptDirs);
        this.addVisibleFilesToInputStreamMapRecursively(project, new String[]{APPL_FOLDER}, APPL_FOLDER_WARFILE, zipEntryNamesToInputStreams, rejectDotJavasAcceptDirs);
        this.createZipFileOfZipNameToInputStreamHashMap(target, zipEntryNamesToInputStreams, null, false);
    }

    public boolean isValidAWTJarArchive(File jarFile) throws Exception {
        int lastDotIndex;
        IDE ide = OpentoolsFactory.getIDEInstance();
        boolean jarIsAWT = false;
        String zarName = jarFile.getName();
        if (zarName.endsWith(".bak")) {
            zarName = zarName.substring(0, zarName.length() - 4);
        }
        if (zarName.endsWith(".jar")) {
            zarName = zarName.substring(0, zarName.length() - 4);
        }
        String nameOfJar = (lastDotIndex = zarName.lastIndexOf(46)) != -1 ? zarName.substring(lastDotIndex + 1) : zarName;
        ZipFile zip = new ZipFile(jarFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String entryName = entry.getName();
            if (!Strings.startsWithIgnoreCase(entryName, SRCLIB_FOLDER) || !entryName.endsWith(".src.zip") && !entryName.endsWith(".src.jar")) continue;
            jarIsAWT = true;
        }
        zip.close();
        return jarIsAWT;
    }

    public void unpackJarArchive(Object project, File jarFile) throws Exception {
        String projectFolderName = OpentoolsFactory.getIDEInstance().getCurrentProjectFolder(project);
        IDE ide = OpentoolsFactory.getIDEInstance();
        String jarName = jarFile.getName();
        if (jarName.endsWith(".bak")) {
            jarName = jarName.substring(0, jarName.length() - 4);
        }
        if (jarName.endsWith(".jar")) {
            jarName = jarName.substring(0, jarName.length() - 4);
        }
        File apiSrcPath = ide.getSrcPath(project, 0);
        int lastDotIndex = jarName.lastIndexOf(46);
        String nameOfJar = lastDotIndex != -1 ? jarName.substring(lastDotIndex + 1) : jarName;
        ZipFile zip = new ZipFile(jarFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String entryName = entry.getName();
            if (entry.isDirectory() || entryName.endsWith(".class")) continue;
            if (Strings.startsWithIgnoreCase(entryName, "private/lib")) {
                if (entryName.endsWith(nameOfJar + ".jar")) continue;
                Stream.writeStreamToFile(projectFolderName + "/" + entryName.substring(7), zip.getInputStream(entry));
                continue;
            }
            if (Strings.startsWithIgnoreCase(entryName, "lib") && entryName.endsWith(nameOfJar + ".jar")) continue;
            if (Strings.startsWithIgnoreCase(entryName, SRC_LIB_FOLDER) && (entryName.endsWith(".src.zip") || entryName.endsWith(".src.jar"))) {
                this.extractZipEntryThatIsAZip(zip, entry, apiSrcPath);
                continue;
            }
            Stream.writeStreamToFile(projectFolderName + "/" + APPL_FOLDER_DEST + entryName, zip.getInputStream(entry));
        }
        zip.close();
    }

    public String[] getPrivateResourcePath() {
        return PRIVATE_RESOURCE_PATH;
    }

    public String[] getPublicResourcePath() {
        return PUBLIC_RESOURCE_PATH;
    }

    public String[] getPossibleJSPScopes() {
        return POSSIBLE_JSP_SCOPES;
    }
}

