/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.parser.helpers.Attribute;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

final class AttributeSorterCA
implements Comparator {
    private int capacity;
    private Vector attributes = null;
    private Integer[] ordinals;
    private Integer[] permutation;
    private CharArray[] sortKeys = null;

    AttributeSorterCA(int initialCapacity) {
        this.ordinals = new Integer[initialCapacity];
        this.permutation = new Integer[initialCapacity];
        int i = 0;
        while (i < initialCapacity) {
            this.ordinals[i] = new Integer(i);
            ++i;
        }
        this.sortKeys = new CharArray[initialCapacity];
        this.capacity = initialCapacity;
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            Integer[] oldOrdinals = this.ordinals;
            this.ordinals = new Integer[n];
            this.permutation = new Integer[n];
            this.sortKeys = new CharArray[n];
            System.arraycopy(oldOrdinals, 0, this.ordinals, 0, this.capacity);
            int i = this.capacity;
            while (i < n) {
                this.ordinals[i] = new Integer(i);
                ++i;
            }
            this.capacity = n;
        }
    }

    void process(Vector attributes, boolean performSort, boolean useLocalNamesAsKeys) {
        this.attributes = attributes;
        int n = attributes.size();
        this.ensureCapacity(n);
        System.arraycopy(this.ordinals, 0, this.permutation, 0, n);
        if (performSort) {
            if (useLocalNamesAsKeys) {
                int i = 0;
                while (i < n) {
                    Attribute attribute = (Attribute)attributes.get(i);
                    CharArray k = attribute.crLocalName;
                    this.sortKeys[i] = k == null || k.equals(CharArray.EMPTY) ? attribute.crRawName : k;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < n) {
                    Attribute attribute = (Attribute)attributes.get(i);
                    this.sortKeys[i] = attribute.crRawName;
                    ++i;
                }
            }
            Arrays.sort(this.permutation, 0, n, this);
        }
    }

    CharArray getURI(int index) {
        return ((Attribute)this.attributes.get((int)index)).crUri;
    }

    CharArray getLocalName(int index) {
        return ((Attribute)this.attributes.get((int)index)).crLocalName;
    }

    CharArray getQName(int index) {
        return ((Attribute)this.attributes.get((int)index)).crRawName;
    }

    CharArray getValue(int index) {
        return ((Attribute)this.attributes.get((int)index)).crValue;
    }

    public int compare(Object a, Object b) {
        int ia = (Integer)a;
        int ib = (Integer)b;
        CharArray sa = this.sortKeys[ia];
        CharArray sb = this.sortKeys[ib];
        return sa.compareTo(sb);
    }
}

