/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.dom.TextImpl;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.XSLApplyTemplates;
import com.sap.engine.lib.xsl.xslt.XSLAttribute;
import com.sap.engine.lib.xsl.xslt.XSLCallTemplate;
import com.sap.engine.lib.xsl.xslt.XSLChoose;
import com.sap.engine.lib.xsl.xslt.XSLComment;
import com.sap.engine.lib.xsl.xslt.XSLCopy;
import com.sap.engine.lib.xsl.xslt.XSLCopyOf;
import com.sap.engine.lib.xsl.xslt.XSLDocument;
import com.sap.engine.lib.xsl.xslt.XSLElement;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLFallback;
import com.sap.engine.lib.xsl.xslt.XSLForEach;
import com.sap.engine.lib.xsl.xslt.XSLIf;
import com.sap.engine.lib.xsl.xslt.XSLMessage;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLNumber;
import com.sap.engine.lib.xsl.xslt.XSLOtherwise;
import com.sap.engine.lib.xsl.xslt.XSLParam;
import com.sap.engine.lib.xsl.xslt.XSLProcessingInstruction;
import com.sap.engine.lib.xsl.xslt.XSLResult;
import com.sap.engine.lib.xsl.xslt.XSLSort;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import com.sap.engine.lib.xsl.xslt.XSLText;
import com.sap.engine.lib.xsl.xslt.XSLValueOf;
import com.sap.engine.lib.xsl.xslt.XSLVariable;
import com.sap.engine.lib.xsl.xslt.XSLWhen;
import com.sap.engine.lib.xsl.xslt.XSLWithParam;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XSLContentNode
extends XSLNode {
    public XSLContentNode(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLContentNode(XSLStylesheet owner, XSLNode parent, Node content) throws XSLException {
        super(owner, parent, content);
        if (content != null) {
            this.scanContent(content);
        }
    }

    public void init(Element el) throws XSLException {
    }

    public void scanContent(Node cont) throws XSLException {
        NodeList nl = cont.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            this.scanNode(nl.item(i));
            ++i;
        }
    }

    public void scanNode(Node node) throws XSLException {
        switch (node.getNodeType()) {
            case 3: {
                if (((TextImpl)node).isWhiteSpace()) break;
                this.append(new XSLText(this.owner, (XSLNode)this, ((Text)node).getData()));
                break;
            }
            case 1: {
                Element el = (Element)node;
                this.owner.getNamespaceHandler().findNamespaceNodes(el, this.owner.getNamespaceManager());
                this.owner.getNamespaceHandler().levelUp();
                if (el.getNamespaceURI() != null && el.getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform")) {
                    String name = el.getLocalName();
                    if (name == null) {
                        name = el.getNodeName();
                    }
                    if (name.equals("apply-templates")) {
                        this.append(new XSLApplyTemplates(this.owner, (XSLNode)this, el));
                    } else if (name.equals("value-of")) {
                        this.append(new XSLValueOf(this.owner, (XSLNode)this, el));
                    } else if (name.equals("element")) {
                        this.append(new XSLElement(this.owner, (XSLNode)this, el));
                    } else if (name.equals("call-template")) {
                        this.append(new XSLCallTemplate(this.owner, (XSLNode)this, el));
                    } else if (name.equals("choose")) {
                        this.append(new XSLChoose(this.owner, (XSLNode)this, el));
                    } else if (name.equals("comment")) {
                        this.append(new XSLComment(this.owner, (XSLNode)this, el));
                    } else if (name.equals("copy")) {
                        this.append(new XSLCopy(this.owner, (XSLNode)this, el));
                    } else if (name.equals("copy-of")) {
                        this.append(new XSLCopyOf(this.owner, (XSLNode)this, el));
                    } else if (name.equals("fallback")) {
                        this.append(new XSLFallback(this.owner, (XSLNode)this, el));
                    } else if (name.equals("for-each")) {
                        this.append(new XSLForEach(this.owner, (XSLNode)this, el));
                    } else if (name.equals("if")) {
                        this.append(new XSLIf(this.owner, (XSLNode)this, el));
                    } else if (name.equals("message")) {
                        this.append(new XSLMessage(this.owner, (XSLNode)this, el));
                    } else if (name.equals("otherwise")) {
                        this.append(new XSLOtherwise(this.owner, (XSLNode)this, el));
                    } else if (name.equals("param")) {
                        this.append(new XSLParam(this.owner, (XSLNode)this, el));
                    } else if (name.equals("processing-instruction")) {
                        this.append(new XSLProcessingInstruction(this.owner, (XSLNode)this, el));
                    } else if (name.equals("sort")) {
                        this.append(new XSLSort(this.owner, (XSLNode)this, el));
                    } else if (name.equals("text")) {
                        this.append(new XSLText(this.owner, (XSLNode)this, el));
                    } else if (name.equals("variable")) {
                        this.append(new XSLVariable(this.owner, (XSLNode)this, el));
                    } else if (name.equals("when")) {
                        this.append(new XSLWhen(this.owner, (XSLNode)this, el));
                    } else if (name.equals("with-param")) {
                        this.append(new XSLWithParam(this.owner, (XSLNode)this, el));
                    } else if (name.equals("attribute")) {
                        this.append(new XSLAttribute(this.owner, (XSLNode)this, el));
                    } else if (name.equals("number")) {
                        this.append(new XSLNumber(this.owner, this, el));
                    } else if (name.equals("document")) {
                        this.append(new XSLDocument(this.owner, (XSLNode)this, el));
                    } else if (name.equals("result")) {
                        this.append(new XSLResult(this.owner, (XSLNode)this, el));
                    }
                } else {
                    this.append(new XSLElement(this.owner, (XSLNode)this, el));
                }
                try {
                    this.owner.getNamespaceHandler().levelDown();
                    break;
                }
                catch (Exception e) {
                    throw new XSLException("Error whileprocessing namespaces for node '" + el.getNodeName() + "'", e);
                }
            }
            case 8: {
                break;
            }
            case 7: {
                break;
            }
            case 4: {
                this.append(new XSLText(this.owner, this, ((Text)node).getData(), false));
                break;
            }
            default: {
                throw new XSLException("Not Supported: " + node.getNodeName());
            }
        }
    }

    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        this.processFromFirst(xcont, node);
    }

    public void print(String ind) {
        System.out.println(ind + "#XSLContentNode: child:");
        if (this.getFirst() != null) {
            this.getFirst().print(ind + "  ");
        }
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }
}

