/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import java.util.Arrays;
import java.util.Comparator;
import org.xml.sax.Attributes;

class AttributeSorter
implements Comparator {
    private Attributes attributes = null;
    private Integer[] ordinals;
    private Integer[] permutation;
    private boolean useNamespaces;

    AttributeSorter(int n) {
        this.ordinals = new Integer[n];
        this.permutation = new Integer[n];
        int i = 0;
        while (i < n) {
            this.ordinals[i] = new Integer(i);
            ++i;
        }
    }

    void process(Attributes attributes, boolean useNamespaces) {
        this.attributes = attributes;
        this.useNamespaces = useNamespaces;
        int n = attributes.getLength();
        if (n > this.ordinals.length) {
            int oldCapacity = this.ordinals.length;
            Integer[] ordinalsOld = this.ordinals;
            this.ordinals = new Integer[n];
            this.permutation = new Integer[n];
            System.arraycopy(ordinalsOld, 0, this.ordinals, 0, oldCapacity);
            int i = oldCapacity;
            while (i < n) {
                this.ordinals[i] = new Integer(i);
                ++i;
            }
        }
        System.arraycopy(this.ordinals, 0, this.permutation, 0, n);
        Arrays.sort(this.permutation, 0, n, this);
    }

    String getURI(int index) {
        return this.attributes.getURI(this.permutation[index]);
    }

    String getLocalName(int index) {
        return this.attributes.getLocalName(this.permutation[index]);
    }

    String getQName(int index) {
        return this.attributes.getQName(this.permutation[index]);
    }

    String getValue(int index) {
        return this.attributes.getValue(this.permutation[index]);
    }

    public int compare(Object a, Object b) {
        String sb;
        String sa;
        int ia = (Integer)a;
        int ib = (Integer)b;
        if (this.useNamespaces) {
            sa = this.attributes.getLocalName(ia);
            sb = this.attributes.getLocalName(ib);
        } else {
            sa = this.attributes.getQName(ia);
            sb = this.attributes.getQName(ib);
        }
        return sa.compareTo(sb);
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

