/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.aliases;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.aliases.KeyAliasResolver;
import java.security.Key;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class KeyAliasResolverImpl
implements KeyAliasResolver {
    private static final String NAME = "Key Alias Resolver Implementation v0.1";
    protected Vector keyAliasResolvers = new Vector();

    public Key getKey(String alias) throws SignatureException {
        Iterator it = ((AbstractList)this.keyAliasResolvers).iterator();
        while (it.hasNext()) {
            KeyAliasResolver temp = (KeyAliasResolver)it.next();
            try {
                if (!temp.contains(alias)) continue;
                return temp.getKey(alias);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    public Enumeration getKeyAliases() throws SignatureException {
        return null;
    }

    public void removeKey(String alias) throws SignatureException {
        Iterator it = ((AbstractList)this.keyAliasResolvers).iterator();
        while (it.hasNext()) {
            KeyAliasResolver temp = (KeyAliasResolver)it.next();
            try {
                if (!temp.contains(alias)) continue;
                temp.removeKey(alias);
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void addKey(String alias, Key key) throws SignatureException {
        throw new SignatureException("Use inner resolvers for this operation");
    }

    public boolean contains(String alias) throws SignatureException {
        Iterator it = ((AbstractList)this.keyAliasResolvers).iterator();
        while (it.hasNext()) {
            KeyAliasResolver temp = (KeyAliasResolver)it.next();
            try {
                if (!temp.contains(alias)) continue;
                return true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    public String getName() {
        return NAME;
    }

    public void addKeyAliasResolver(KeyAliasResolver kar) {
        this.keyAliasResolvers.addElement(kar);
    }

    public void insertKeyAliasResolverAt(KeyAliasResolver kar, int pos) {
        this.keyAliasResolvers.insertElementAt(kar, pos);
    }

    public void removeKeyAliasResolver(int pos) {
        this.keyAliasResolvers.removeElementAt(pos);
    }

    public int countKeyAliasResolvers() {
        return this.keyAliasResolvers.size();
    }

    public Vector getKeyAliasResolverVector() {
        return this.keyAliasResolvers;
    }

    public Key getKey(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        return this.getKey(name);
    }

    public void removeKey(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        this.removeKey(name);
    }

    public void addKey(Object alias, Key key) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        this.addKey(name, key);
    }

    public boolean contains(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        return this.contains(name);
    }
}

