/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.pool;

import com.sap.engine.lib.xml.parser.helpers.Attribute;

public final class AttributePool {
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private Attribute[] arrayOfObjects;
    private Attribute temp;

    public AttributePool(int initSize, int step) {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new Attribute[this.initialSize];
        int i = 0;
        while (i < this.initialSize) {
            this.arrayOfObjects[i] = new Attribute();
            ++i;
        }
        this.pos = this.initialSize - 1;
    }

    public Attribute getObject() {
        if (this.pos < 0) {
            this.autoResize();
        }
        return this.arrayOfObjects[this.pos--];
    }

    public void releaseObject(Attribute obj) {
        if (this.pos < this.arrayOfObjects.length - 1) {
            ++this.pos;
            this.arrayOfObjects[this.pos] = obj;
        }
    }

    private void autoResize() {
        Attribute[] tempArr = new Attribute[this.arrayOfObjects.length + this.resizeStep];
        int i = 0;
        while (i < this.resizeStep) {
            tempArr[i] = new Attribute();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.arrayOfObjects.length) {
            tempArr[i2 + this.resizeStep] = this.arrayOfObjects[i2];
            ++i2;
        }
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
    }
}

