/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.dtd;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import com.sap.engine.lib.xml.parser.dtd.XMLValidator;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.util.Vector;

final class Model {
    XMLValidator validator;
    char[] model;
    int modelLength;
    int index;
    static final char END_OF_MODEL = '\uffff';

    Model(XMLValidator validator, CharArray modelCA) {
        this.validator = validator;
        this.model = modelCA == null ? new char[]{} : modelCA.getChars();
        this.modelLength = this.model.length;
        this.index = 0;
    }

    char currentChar() {
        return this.index < this.modelLength ? this.model[this.index] : (char)'\uffff';
    }

    void nextChar() {
        ++this.index;
    }

    boolean finished() {
        return this.index >= this.modelLength;
    }

    void confirm(String s) throws ValidationException {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != this.currentChar()) {
                throw new ValidationException(this.validator, "The string '" + s + "' was expected. " + this);
            }
            ++this.index;
            ++i;
        }
    }

    void confirm(CharArray ca) throws ValidationException {
        int l = ca.getSize();
        char[] a = ca.getChars();
        int i = 0;
        while (i < l) {
            if (a[i] != this.currentChar()) {
                throw new ValidationException(this.validator, "The string '" + ca + "' was expected. " + this);
            }
            ++this.index;
            ++i;
        }
    }

    void confirmEndOfModel() throws ValidationException {
        if (!this.finished()) {
            throw new ValidationException(this.validator, "End of model expected. " + this);
        }
    }

    void skipOptionalWhitespace() {
        while (Symbols.isWhitespace(this.currentChar())) {
            ++this.index;
        }
    }

    CharArray getName() throws ValidationException {
        char ch = this.currentChar();
        if (!Symbols.isInitialNameChar(ch)) {
            throw new ValidationException(this.validator, "Name expected. " + this);
        }
        CharArray ret = new CharArray();
        ret.append(ch);
        ++this.index;
        while (Symbols.isNameChar(ch = this.currentChar())) {
            ret.append(ch);
            ++this.index;
        }
        return ret;
    }

    Vector getNames() throws ValidationException {
        Vector<CharArray> v = new Vector<CharArray>();
        v.addElement(this.getName());
        while (true) {
            this.skipOptionalWhitespace();
            if (!Symbols.isInitialNameChar(this.currentChar())) break;
            v.addElement(this.getName());
        }
        return v;
    }

    Vector getNames(char separator) throws ValidationException {
        Vector<CharArray> v = new Vector<CharArray>();
        while (true) {
            this.skipOptionalWhitespace();
            v.addElement(this.getName());
            this.skipOptionalWhitespace();
            if (this.currentChar() != separator) break;
            ++this.index;
        }
        return v;
    }

    CharArray getNmToken() throws ValidationException {
        char ch = this.currentChar();
        if (!Symbols.isNameChar(ch)) {
            throw new ValidationException(this.validator, "NmToken expected. " + this);
        }
        CharArray ret = new CharArray();
        ret.append(ch);
        ++this.index;
        while (Symbols.isNameChar(ch = this.currentChar())) {
            ret.append(ch);
            ++this.index;
        }
        return ret;
    }

    Vector getNmTokens() throws ValidationException {
        Vector<CharArray> v = new Vector<CharArray>();
        v.addElement(this.getNmToken());
        while (true) {
            this.skipOptionalWhitespace();
            if (!Symbols.isNameChar(this.currentChar())) break;
            v.addElement(this.getNmToken());
        }
        return v;
    }

    Vector getNmTokens(char separator) throws ValidationException {
        Vector<CharArray> v = new Vector<CharArray>();
        while (true) {
            this.skipOptionalWhitespace();
            v.addElement(this.getNmToken());
            this.skipOptionalWhitespace();
            if (this.currentChar() != separator) break;
            ++this.index;
        }
        return v;
    }

    public String toString() {
        return "(value='" + new String(this.model) + "', index=" + this.index + ")";
    }
}

