/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary.transformers;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.parser.binary.BinaryXmlReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BinToDomTransformer {
    public static void main(String[] args) {
        new BinToDomTransformer().transform(args[0], args[1]);
    }

    public void transform(String path, String target) {
        try {
            BinaryXmlReader reader = new BinaryXmlReader(new FileInputStream(path));
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            Document doc = builder.newDocument();
            DocumentFragment root = doc.createDocumentFragment();
            doc.appendChild(root);
            this.readElement(reader, doc, root);
            TransformerFactory transformFactory = TransformerFactory.newInstance();
            Transformer transformer = transformFactory.newTransformer();
            DOMResult domResult = new DOMResult();
            FileOutputStream outStream = new FileOutputStream(target);
            transformer.transform(new DOMSource(root), new StreamResult(outStream));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readElement(BinaryXmlReader reader, Document doc, Node node) {
        try {
            while (reader.read()) {
                short type = reader.getNodeType();
                if (type == 1 || type == 9) {
                    if (reader.isStartElement) {
                        Element child = doc.createElement(reader.getQName());
                        node.appendChild(child);
                        this.readElement(reader, doc, child);
                        continue;
                    }
                    return;
                }
                if (type == 3) {
                    Text text = doc.createTextNode(reader.getNodeValue());
                    node.appendChild(text);
                    continue;
                }
                if (type == 8) {
                    Comment comment = doc.createComment(reader.getNodeValue());
                    node.appendChild(comment);
                    continue;
                }
                if (type != 2) continue;
                Attr attribute = doc.createAttribute(reader.getQName());
                attribute.setNodeValue(reader.getNodeValue());
                node.getAttributes().setNamedItem(attribute);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

