/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary;

import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.binary.common.MappingData;
import com.sap.engine.lib.xml.parser.binary.exceptions.XmlBinaryException;
import com.sap.engine.lib.xml.parser.binary.handlers.BinaryNamespaceHandler;
import com.sap.engine.lib.xml.parser.binary.pools.MappingDataPool;
import com.sap.engine.lib.xml.parser.binary.util.HashMapObjectObject;
import com.sap.engine.lib.xml.parser.binary.util.Stack;
import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;
import com.sap.engine.lib.xml.parser.pool.CharArrayPool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BinaryXmlReader {
    protected InputStream stream;
    protected CharArray dataBuffer;
    protected HashMapObjectObject bufferData;
    protected CharArrayPool dataPool;
    protected MappingDataPool mappingPool;
    protected CharArray[] dataTable = new CharArray[65536];
    protected BinaryNamespaceHandler nsHandler;
    private Stack nodeLocalNames;
    private Stack nodeMappings;
    private Stack attribsToApply;
    public boolean isStartElement;
    protected short nodeType;
    protected CharArray prefix;
    protected CharArray nsURI;
    protected CharArray localName;
    protected CharArray nodeValue;
    protected final CharArray textLocalName = new CharArray("#text");
    protected final CharArray commentLocalName = new CharArray("#comment");
    private byte entryType;
    private int currentID;
    private EncodingHandler encodingHandler = new EncodingHandler();
    private Encoding encoding = this.encodingHandler.getEncoding(new CharArray("UTF-8"));

    public BinaryXmlReader(InputStream input) {
        this.stream = new BufferedInputStream(input);
        this.init();
    }

    public void init() {
        this.dataBuffer = new CharArray(500, 500);
        this.bufferData = new HashMapObjectObject();
        this.dataPool = new CharArrayPool(100, 100);
        this.mappingPool = new MappingDataPool(100, 100);
        this.nsHandler = new BinaryNamespaceHandler();
        this.nodeLocalNames = new Stack();
        this.nodeMappings = new Stack();
        this.attribsToApply = new Stack();
        this.currentID = 1;
    }

    public void clear() {
        this.dataBuffer.clear();
        this.dataPool.release();
        this.mappingPool.release();
        this.nsHandler.clear();
        this.nodeLocalNames.clear();
        this.nodeMappings.clear();
        this.attribsToApply.clear();
        this.clearDataTable();
    }

    public void reuse(InputStream input) {
        this.stream = new BufferedInputStream(input);
        this.dataBuffer.setSize(0);
        this.dataPool.releaseAllObjects();
        this.mappingPool.releaseAllObjects();
        this.nsHandler.reuse();
        this.nodeLocalNames.clear();
        this.nodeMappings.clear();
        this.attribsToApply.clear();
        this.currentID = 1;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String lookupPrefix(String nsURI) {
        CharArray uri = this.dataPool.getObject();
        uri.set(nsURI);
        return this.bufferData(this.nsHandler.getPrefix(uri));
    }

    public CharArray lookupPrefix(CharArray nsURI) {
        return this.nsHandler.getPrefix(nsURI);
    }

    public boolean read() throws Exception {
        boolean result = false;
        if (!this.attribsToApply.isEmpty() && this.isStartElement) {
            result = true;
            MappingData mapping = (MappingData)this.attribsToApply.pop();
            if (mapping.prefix != null) {
                this.prefix = XMLParserConstants.caXMLNS;
                this.localName = mapping.prefix;
            } else {
                this.prefix = null;
                this.localName = XMLParserConstants.caXMLNS;
            }
            this.nsURI = XMLParserConstants.crXMLNSNamespace;
            this.nodeValue = mapping.uri;
            this.nodeType = (short)2;
            return result;
        }
        this.entryType = (byte)-1;
        try {
            this.entryType = (byte)this.stream.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.entryType < 128) {
            switch (this.entryType) {
                case 1: {
                    this.nodeType = 1;
                    this.isStartElement = true;
                    this.readElementEntry();
                    result = true;
                    break;
                }
                case 2: {
                    this.nodeType = 1;
                    this.isStartElement = false;
                    this.readEndElementEntry();
                    result = true;
                    break;
                }
                case 3: {
                    this.nodeType = (short)2;
                    this.readAttributeEntry();
                    result = true;
                    break;
                }
                case 4: {
                    this.nodeType = (short)3;
                    this.isStartElement = false;
                    this.readStringEntry();
                    result = true;
                    break;
                }
                case 5: {
                    this.nodeType = (short)8;
                    this.isStartElement = false;
                    this.readCommentEntry();
                    result = true;
                    break;
                }
                case 6: {
                    this.nodeType = (short)-1;
                    this.readRegisterEntry();
                    result = true;
                    break;
                }
                case 7: {
                    this.nodeType = (short)-1;
                    this.readPrefixMappingEntry();
                    result = true;
                    break;
                }
                case 8: {
                    this.nodeType = (short)-1;
                    this.readEndPrefixMappingEntry();
                    result = true;
                    break;
                }
                case -1: {
                    this.nodeType = (short)-1;
                    result = false;
                    break;
                }
                default: {
                    this.nodeType = (short)-1;
                    this.skipContent();
                    result = true;
                    break;
                }
            }
        } else {
            this.stream.skip(this.readEncodedID());
        }
        return result;
    }

    protected void readNodeValue() throws IOException {
        this.nodeValue = this.dataPool.getObject();
        int size = this.dataBuffer.getSize();
        int length = 0;
        int ch = -1;
        while ((ch = this.stream.read()) != 0 && ch != 255) {
            if ((ch = this.encoding.process((byte)ch)) == -2) continue;
            this.dataBuffer.append((char)ch);
            ++length;
        }
        this.nodeValue.substring(this.dataBuffer, size, size + length);
    }

    protected void skipContent() throws IOException {
        int data = -1;
        while ((data = this.stream.read()) != -1) {
            if (data == 255) break;
        }
    }

    protected int readEncodedID() throws IOException {
        int result = -1;
        int data = -1;
        while ((data = this.stream.read()) != 255) {
            if ((data = this.encoding.process((byte)data)) == -2) continue;
            result = data;
            break;
        }
        return result;
    }

    protected void readElementEntry() throws IOException {
        int localNameID = this.readEncodedID();
        int mappingID = this.readEncodedID();
        this.prefix = null;
        this.nsURI = null;
        this.localName = this.getData(localNameID);
        MappingData mapping = this.mappingPool.getObject(null, null);
        if (mappingID != 1) {
            mapping = this.nsHandler.getMappingData(mappingID);
            this.prefix = mapping.prefix;
            this.nsURI = mapping.uri;
        }
        this.nodeValue = null;
        this.nodeMappings.push(mapping);
        this.nodeLocalNames.push(this.localName);
    }

    protected void readEndElementEntry() throws IOException {
        this.prefix = null;
        this.nsURI = null;
        this.localName = null;
        this.nodeValue = null;
        if (!this.nodeMappings.isEmpty()) {
            MappingData mapping = (MappingData)this.nodeMappings.pop();
            this.prefix = mapping.prefix;
            this.nsURI = mapping.uri;
            this.localName = (CharArray)this.nodeLocalNames.pop();
        }
    }

    protected void readAttributeEntry() throws IOException {
        int localNameID = this.readEncodedID();
        int mappingID = this.readEncodedID();
        this.prefix = null;
        this.nsURI = null;
        this.localName = this.getData(localNameID);
        this.readNodeValue();
        MappingData mapping = null;
        if (mappingID != 1) {
            mapping = this.nsHandler.getMappingData(mappingID);
            this.prefix = mapping.prefix;
            this.nsURI = mapping.uri;
        }
    }

    protected void readStringEntry() throws IOException {
        this.prefix = null;
        this.nsURI = null;
        this.localName = this.textLocalName;
        this.readNodeValue();
    }

    protected void readCommentEntry() throws IOException {
        this.prefix = null;
        this.nsURI = null;
        this.localName = this.commentLocalName;
        this.readNodeValue();
    }

    protected void readRegisterEntry() throws IOException {
        int id = this.readEncodedID();
        this.readNodeValue();
        this.addTableID(id, this.nodeValue);
        this.prefix = null;
        this.nsURI = null;
        this.localName = null;
        this.nodeValue = null;
    }

    protected void readPrefixMappingEntry() throws IOException, XmlBinaryException {
        int mappingID = this.readEncodedID();
        int prefixID = this.readEncodedID();
        int uriID = this.readEncodedID();
        this.prefix = this.getData(prefixID);
        this.nsURI = this.getData(uriID);
        if (this.prefix.equals(this.nsHandler.defaultPrefixName)) {
            this.prefix = null;
            this.nsHandler.addDefault(this.nsURI, mappingID);
        } else {
            this.nsHandler.add(this.prefix, this.nsURI, mappingID);
        }
        this.attribsToApply.push(this.mappingPool.getObject(this.prefix, this.nsURI));
        this.prefix = null;
        this.nsURI = null;
        this.localName = null;
        this.nodeValue = null;
    }

    protected void readEndPrefixMappingEntry() throws IOException {
        int mappingID = this.readEncodedID();
        this.nsHandler.removeMappingID(mappingID);
        this.prefix = null;
        this.nsURI = null;
        this.localName = null;
        this.nodeValue = null;
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public String getLocalName() {
        return this.localName != null ? this.bufferData(this.localName) : null;
    }

    public CharArray getLocalName0() {
        return this.localName;
    }

    public String getQName() {
        String result = null;
        if (this.localName != null) {
            result = this.prefix != null ? this.bufferData(this.prefix) + ":" + this.bufferData(this.localName) : this.bufferData(this.localName);
        }
        return result;
    }

    public CharArray getQName0() {
        CharArray result = null;
        if (this.localName != null) {
            if (this.prefix != null) {
                result = this.dataPool.getObject();
                result.append(this.prefix);
                result.append(":");
                result.append(this.localName);
            } else {
                result = this.localName;
            }
        }
        return result;
    }

    public String getPrefix() {
        return this.prefix != null ? this.bufferData(this.prefix) : null;
    }

    public CharArray getPrefix0() {
        return this.prefix;
    }

    public String getNamespaceURI() {
        return this.nsURI != null ? this.bufferData(this.nsURI) : null;
    }

    public CharArray getNamespaceURI0() {
        return this.nsURI;
    }

    public String getNodeValue() {
        return this.nodeValue != null ? this.bufferData(this.nodeValue) : null;
    }

    public CharArray getNodeValue0() {
        return this.nodeValue;
    }

    protected int addTableData(CharArray data) throws Exception {
        if (this.currentID < 65535) {
            ++this.currentID;
            this.dataTable[this.currentID] = data;
        } else {
            this.currentID = 2;
            this.dataTable[this.currentID] = data;
        }
        return this.currentID;
    }

    protected void addTableID(int id, CharArray data) throws IllegalArgumentException {
        if (id >= 65535) {
            throw new IllegalArgumentException("Invalid ID! ID must be between 2 and 65535.");
        }
        this.currentID = id;
        this.dataTable[id] = data;
    }

    protected CharArray getData(int id) {
        if (id > this.currentID) {
            this.dataTable[id] = null;
        }
        return this.dataTable[id];
    }

    protected void clearDataTable() {
        int i = 0;
        while (i < this.dataTable.length) {
            this.dataTable[i] = null;
            ++i;
        }
    }

    protected String bufferData(CharArray data) {
        String result = null;
        result = (String)this.bufferData.get(data);
        if (result == null) {
            result = data.getStringFast();
            this.bufferData.put(data, result);
        }
        return result;
    }
}

