/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.CharArrayStack;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.Reference;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xsl.xslt.InternalAttribute;
import com.sap.engine.lib.xsl.xslt.InternalAttributeList;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

public final class ActiveXMLParser
extends EmptyDocHandler
implements XMLParserConstants,
XMLTokenReader {
    public static final int NEWBORN = -1;
    public static final int INITIAL = 0;
    public static final int START = 1;
    public static final int END = 2;
    public static final int CHARS = 3;
    public static final int PI = 4;
    public static final int COMMENT = 5;
    public static final int EOF = 6;
    private boolean shouldFakeEnd = false;
    private boolean normalize = false;
    private boolean wasEnd = false;
    private int attributeCount = 0;
    private boolean textDeclAllowed = true;
    private boolean endOfRootReached = false;
    private InputStream xmlInputStream = null;
    private InputSource xmlInputSource = null;
    private Reader xmlReader = null;
    private int currentState = -1;
    private XMLParser parser = null;
    private DocHandler docHandler = null;
    private Hashtable prefixMapping;
    private CharArray uri = null;
    private CharArray localName = null;
    private CharArray qName = null;
    private static final char XPATH_SEPARATOR = '/';
    private boolean append = false;
    private CharArray charData = new CharArray();
    private CharArray commentData = new CharArray();
    private InternalAttributeList attribs = new InternalAttributeList();
    private boolean firstElementPassed = false;
    private int depthReached = 0;
    private String location;
    private boolean hasDTD = false;

    public ActiveXMLParser(InputSource xmlInputSource) {
        this();
        this.xmlInputSource = xmlInputSource;
    }

    public ActiveXMLParser(XMLParser parser) {
        this();
        this.parser = parser;
    }

    public ActiveXMLParser(InputStream xmlInputStream) {
        this();
        this.xmlInputStream = xmlInputStream;
    }

    public ActiveXMLParser(Reader xmlReader) {
        this();
        this.xmlReader = xmlReader;
    }

    public ActiveXMLParser() {
        this.prefixMapping = new Hashtable();
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void reuse(InputStream stream) {
        this.xmlInputStream = stream;
        this.xmlInputSource = null;
    }

    public void init(InputStream stream) {
        this.reuse(stream);
    }

    public void setDocHandler(DocHandler docHandler) {
        this.docHandler = docHandler;
    }

    public int begin() throws ParserException {
        try {
            this.parser = this.getParser();
            this.firstElementPassed = false;
            this.shouldFakeEnd = false;
            this.endOfRootReached = false;
            if (this.xmlInputSource == null) {
                if (this.xmlReader != null) {
                    this.xmlInputSource = new InputSource(this.xmlReader);
                }
                if (this.xmlInputStream != null) {
                    this.xmlInputSource = new InputSource(this.xmlInputStream);
                }
            }
            this.parser.activeParse(this.xmlInputSource, this);
            this.currentState = 0;
            this.prefixMapping.clear();
            return this.currentState;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public int next() throws ParserException {
        try {
            if (this.wasEnd) {
                this.charData.clear();
            }
            if (this.endOfRootReached) {
                this.parser.scanS();
            }
            if (this.shouldFakeEnd) {
                this.shouldFakeEnd = false;
                this.currentState = 2;
                return 2;
            }
            if (this.parser.getDocFinished()) {
                this.currentState = 6;
                this.parser.finalizeActiveParse();
                return 6;
            }
            int i = this.parser.checkMarkup();
            switch (i) {
                case 2: {
                    this.parser.scanPI(this.textDeclAllowed);
                    this.textDeclAllowed = false;
                    return 4;
                }
                case 3: {
                    this.parser.scanElement();
                    return 1;
                }
                case 1: {
                    this.parser.scanComment();
                    return 5;
                }
                case 8: {
                    this.parser.scanCharData();
                    return 3;
                }
                case 10: {
                    this.parser.scanEndTag();
                    if (this.depthReached < 1) {
                        this.endOfRootReached = true;
                        this.parser.finalizeActiveScan();
                    }
                    return 2;
                }
                case 16: {
                    this.parser.handleContentReference(false);
                    return 3;
                }
                case 17: {
                    this.parser.scanDTD();
                    return this.next();
                }
                case 9: {
                    this.parser.scanCDSect();
                    return 3;
                }
            }
            throw new ParserException(" Unrecognized case: " + i, -1, 0);
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.startElementStart(uri, localName, qname);
        }
        this.uri = uri;
        this.localName = localName;
        this.qName = qname;
        this.attributeCount = 0;
        this.attribs.clear();
        this.charData.clear();
        ++this.depthReached;
        this.wasEnd = false;
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.addAttribute(uri, prefix, localName, qname, type, value);
        }
        this.attribs.addAttribute(uri, prefix, qname, localName, value);
    }

    public void startElementEnd(boolean isEmpty) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.startElementEnd(isEmpty);
        }
        this.currentState = 1;
        if (isEmpty) {
            this.shouldFakeEnd = true;
        }
    }

    public void endElement(CharArray uri, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.endElement(uri, localName, qname, isEmpty);
        }
        this.uri = uri;
        this.localName = localName;
        this.qName = qname;
        if (!isEmpty) {
            this.currentState = 2;
        }
        this.wasEnd = true;
        --this.depthReached;
    }

    public void startDocument() throws Exception {
        if (this.docHandler != null) {
            this.docHandler.startDocument();
        }
        this.currentState = 0;
    }

    public void endDocument() throws Exception {
        if (this.docHandler != null) {
            this.docHandler.endDocument();
        }
        this.currentState = 6;
    }

    public void charData(CharArray carr, boolean bDisableOutputEscaping) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.charData(carr, bDisableOutputEscaping);
        }
        if (this.append || this.normalize) {
            this.charData.append(carr);
        } else {
            this.charData = carr;
        }
        this.currentState = 3;
    }

    public void onXMLDecl(String version, String encoding, String ssdecl) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onXMLDecl(version, encoding, ssdecl);
        }
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onPI(target, data);
        }
    }

    public void onComment(CharArray text) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onComment(text);
        }
        this.commentData = text;
        this.currentState = 5;
    }

    public void onCDSect(CharArray text) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onCDSect(text);
        }
    }

    public void onDTDElement(CharArray name, CharArray model) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onDTDElement(name, model);
        }
    }

    public void onDTDAttListStart(CharArray name) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onDTDAttListStart(name);
        }
    }

    public void onDTDAttListItem(CharArray name, CharArray attname, String type, String defDecl, CharArray vAttValue, String note) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onDTDAttListItem(name, attname, type, defDecl, vAttValue, note);
        }
    }

    public void onDTDAttListEnd() throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onDTDAttListEnd();
        }
    }

    public void onDTDEntity(Entity entity) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onDTDEntity(entity);
        }
    }

    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onDTDNotation(name, pub, sys);
        }
    }

    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
        this.hasDTD = true;
        if (this.docHandler != null) {
            this.docHandler.startDTD(name, pub, sys);
        }
    }

    public void endDTD() throws Exception {
        if (this.docHandler != null) {
            this.docHandler.endDTD();
        }
    }

    public void onContentReference(Reference ref) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.onContentReference(ref);
        }
    }

    public void end() throws ParserException {
        if (this.currentState != 6) {
            throw new ParserException("EOF not reached yet!", 0, 0);
        }
        try {
            this.parser.finalizeActiveParse();
        }
        catch (Exception e) {
            throw new ParserException(e.toString(), 0, 0);
        }
        this.location = null;
        this.hasDTD = false;
    }

    public boolean hasDTD() {
        return this.hasDTD;
    }

    public int getState() {
        return this.currentState;
    }

    public String getQName() {
        return this.qName.toString();
    }

    public CharArray getQNameCharArray() {
        return this.qName;
    }

    public String getLocalName() {
        return this.localName.toString();
    }

    public CharArray getLocalNameCharArray() {
        return this.localName;
    }

    public String getURI() {
        return this.uri.toString();
    }

    public CharArray getURICharArray() {
        return new CharArray(this.uri);
    }

    public Attributes getAttributes() {
        if (this.currentState != 1) {
            return null;
        }
        AttributesImpl attr = new AttributesImpl();
        int i = 0;
        while (i < this.attribs.size()) {
            InternalAttribute ia = this.attribs.get(i);
            attr.addAttribute(ia.uri == null ? null : ia.uri.toString(), ia.localName == null ? null : ia.localName.toString(), ia.qname == null ? null : ia.qname.toString(), null, ia.value == null ? null : ia.value.toString());
            ++i;
        }
        return attr;
    }

    public InternalAttributeList getInternalAttributeList() {
        return this.attribs;
    }

    public String getValue() {
        if (this.currentState == 5) {
            return this.commentData.toString();
        }
        return this.charData.toString();
    }

    public CharArray getValueCharArray() {
        return this.charData;
    }

    public boolean isWhitespace() {
        return this.charData.isWhitespace();
    }

    public Element getDOMRepresentation(Document document) throws ParserException {
        if (this.getState() != 1) {
            return null;
        }
        Element element = document.createElementNS(this.getURI(), this.getQName());
        Enumeration enumeration = this.prefixMapping.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Stack mappings = (Stack)this.prefixMapping.get(key);
            String namespace = (String)mappings.peek();
            if (namespace.length() == 0) continue;
            if (key.length() == 0) {
                element.setAttribute("xmlns", namespace);
                continue;
            }
            element.setAttribute("xmlns:" + key, namespace);
        }
        Attributes attrs = this.getAttributes();
        int attrsLeght = attrs.getLength();
        int i = 0;
        while (i < attrsLeght) {
            String attribUri = attrs.getURI(i);
            String attribQName = attrs.getQName(i);
            String attribValue = attrs.getValue(i);
            if (!attribUri.equals("http://www.w3.org/2000/xmlns/") && !DOM.qnameToLocalName(attribQName).equals("xmlns")) {
                element.setAttributeNS(attribUri, attribQName, attribValue);
            }
            ++i;
        }
        while (true) {
            int code = this.next();
            switch (code) {
                case 5: {
                    element.appendChild(element.getOwnerDocument().createComment(this.getValue()));
                    break;
                }
                case 3: {
                    element.appendChild(element.getOwnerDocument().createTextNode(this.getValue()));
                    break;
                }
                case 1: {
                    element.appendChild(this.getDOMRepresentation(document));
                    break;
                }
                case 2: {
                    return element;
                }
                case 6: {
                    throw new ParserException("Unexpexted EOF.", 0, 0);
                }
            }
        }
    }

    public int moveToNextElementStart() throws ParserException {
        int code;
        do {
            if ((code = this.next()) != 1) continue;
            return 1;
        } while (code != 6);
        return 6;
    }

    public void startPrefixMapping(CharArray prefix, CharArray uri) throws Exception {
        if (this.docHandler != null) {
            this.docHandler.startPrefixMapping(new CharArray(prefix), new CharArray(uri));
        }
        String stringPrefix = prefix.toString();
        String stringURI = uri.toString();
        Stack<String> mappings = (Stack<String>)this.prefixMapping.get(stringPrefix);
        if (mappings == null) {
            mappings = new Stack<String>();
            this.prefixMapping.put(stringPrefix, mappings);
        }
        mappings.add(stringURI);
    }

    public void endPrefixMapping(CharArray prefix) throws Exception {
        String stringPrefix;
        Stack mappings;
        if (this.docHandler != null) {
            this.docHandler.endPrefixMapping(new CharArray(prefix));
        }
        if ((mappings = (Stack)this.prefixMapping.get(stringPrefix = prefix.toString())) != null) {
            mappings.pop();
            if (mappings.isEmpty()) {
                this.prefixMapping.remove(stringPrefix);
            }
        }
    }

    public String getURI(String prefix) {
        Stack mappings = (Stack)this.prefixMapping.get(prefix);
        if (mappings != null) {
            return (String)mappings.peek();
        }
        return null;
    }

    public XMLParser getParser() throws ParserException {
        if (this.parser == null) {
            this.parser = new XMLParser();
            this.parser.setSoapProcessing(true);
            this.parser.setNamespaces(true);
        }
        return this.parser;
    }

    public void setParser(XMLParser parser) {
        this.parser = parser;
    }

    public String getPrefixMapping(String prefix) {
        return this.getURI(prefix);
    }

    public void passChars() throws ParserException {
        while (this.currentState != 1 && this.currentState == 3) {
            this.next();
        }
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean getNormalize() {
        return this.normalize;
    }

    public static void main(String[] args) throws Exception {
        ActiveXMLParser parser = new ActiveXMLParser(new FileInputStream("D:/develop/schema_test/jaxp/normalize.xml"));
        parser.begin();
        int code = -1;
        while ((code = parser.next()) != 6) {
            if (code != 1) continue;
            while ((code = parser.next()) != 2) {
                if (code != 3) continue;
                System.out.println("element : " + parser.getLocalName() + " value : |" + parser.getValue() + "|");
            }
        }
    }

    public CharArray getValuePassCharsCA() throws ParserException {
        this.append = true;
        while (this.currentState == 3) {
            this.next();
        }
        this.append = false;
        return this.charData;
    }

    public String getValuePassChars() throws ParserException {
        this.append = true;
        while (this.currentState == 3) {
            this.next();
        }
        this.append = false;
        return this.charData.toString();
    }

    public String getParentElement() {
        CharArrayStack stack = this.parser.getElementStack();
        if (this.currentState == 1) {
            CharArray current = new CharArray(stack.getTop());
            stack.matchTop(new CharArray(current));
            if (stack.isEmpty()) {
                stack.put(current);
                return null;
            }
            char[] top = stack.getTop();
            stack.put(current);
            return new String(top);
        }
        if (stack.isEmpty()) {
            return null;
        }
        return new String(stack.getTop());
    }

    public int getCurrentLevel() {
        return 0;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver(resolver);
    }
}

