/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.DOMImplementationImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.lib.xml.dom.NodeListImplEmpty;
import com.sap.engine.lib.xml.util.DOMSerializer;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Base
implements Node,
Serializable {
    protected Document ownerDocument = null;
    private Hashtable augmentationMappings;
    private Node nextSibling;
    private Node previousSibling;
    private static DOMSerializer serializer = new DOMSerializer();

    protected Base() {
    }

    public String toXPath() {
        return DOMImplementationImpl.toXPath(this);
    }

    public String toXPathWithLocation() {
        return DOMImplementationImpl.toXPathWithLocation(this);
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node appendChild(Node newChild) {
        throw new DOMException(3, "Attempt to append a child to " + Base.nameOfNodeWithArticle(this) + " node.");
    }

    public NodeList getChildNodes() {
        return NodeListImplEmpty.getInstance();
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public void setNextSibling(Node nextSibling) {
        this.nextSibling = nextSibling;
    }

    public String getNodeValue() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(Node previousSibling) {
        this.previousSibling = previousSibling;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        throw new DOMException(3, "Attempt to insert a child to " + Base.nameOfNodeWithArticle(this) + " node.");
    }

    public final boolean isSupported(String feature, String version) {
        return DOMImplementationImpl.hasFeatureStatic(feature, version);
    }

    public final boolean supports(String feature, String version) {
        return this.isSupported(feature, version);
    }

    public Node removeChild(Node oldChild) {
        throw new DOMException(8, "Attempt to remove a child from " + Base.nameOfNodeWithArticle(this) + " node.");
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        throw new DOMException(3, "Attempt to replace a child from " + Base.nameOfNodeWithArticle(this) + " node.");
    }

    public void setPrefix(String prefix) {
        throw new DOMException(14, "Prefix cannot be set to " + Base.nameOfNodeWithArticle(this) + " node.");
    }

    public void setNodeValue(String value) {
    }

    protected final Document getOwnerDocument_internal() {
        return null;
    }

    protected void setParent(NodeImpl parent) {
    }

    public final Document getOwnerDocument() {
        if (this.getNodeType() == 9) {
            return null;
        }
        return this.ownerDocument;
    }

    protected final void setOwnerDocument(Document doc) {
        this.ownerDocument = doc;
    }

    public void normalize() {
    }

    public static synchronized String serializeNode(Node n) {
        try {
            if (n.getNodeType() == 9 || n.getNodeType() == 1) {
                StringWriter wr = new StringWriter();
                serializer.write(n, wr);
                wr.close();
                return wr.toString();
            }
            return "--Only Element and Document Nodes can be serilized in serializeNode--";
        }
        catch (Exception e) {
            return "--Exception during serialization: " + e.toString();
        }
    }

    public void setOwner(Document doc, boolean deep) {
        this.setOwnerDocument(doc);
        if (deep) {
            NodeList nl = this.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                ((Base)nl.item(i)).setOwner(doc, deep);
                ++i;
            }
            if (this.getNodeType() == 1) {
                NamedNodeMap map = ((Element)((Object)this)).getAttributes();
                int i2 = 0;
                while (i2 < map.getLength()) {
                    ((AttrImpl)map.item(i2)).setOwnerDocument(doc);
                    ++i2;
                }
            }
        }
    }

    public void setAugmentation(String augmentationProperty, Object augmentationObj) {
        if (this.augmentationMappings == null) {
            this.augmentationMappings = new Hashtable();
        }
        if (augmentationObj != null) {
            this.augmentationMappings.put(augmentationProperty, augmentationObj);
        }
    }

    public Object getAugmentation(String augmentationProperty) {
        return this.augmentationMappings == null ? null : this.augmentationMappings.get(augmentationProperty);
    }

    public String getAugmentationPropsAsString() {
        return this.augmentationMappings == null ? "" : this.augmentationMappings.toString();
    }

    public boolean hasAugmentation(String augmentationProperty) {
        return this.augmentationMappings == null ? false : this.augmentationMappings.containsKey(augmentationProperty);
    }

    public static boolean areNamespaceURIEqual(String n1, String n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null && n2 != null) {
            return false;
        }
        if (n1 != null && n2 == null) {
            return false;
        }
        return n1.equals(n2);
    }

    protected static final String nameOfNode(Node node) {
        if (node == null) {
            return "null";
        }
        short t = node.getNodeType();
        switch (t) {
            case 1: {
                return "element";
            }
            case 2: {
                return "attribute";
            }
            case 3: {
                return "text";
            }
            case 4: {
                return "CDATA section";
            }
            case 5: {
                return "entity reference";
            }
            case 6: {
                return "entity";
            }
            case 7: {
                return "processing instruction";
            }
            case 8: {
                return "comment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "document type";
            }
            case 11: {
                return "document fragment";
            }
            case 12: {
                return "notation";
            }
        }
        return "???";
    }

    protected static final String nameOfNodeWithArticle(Node node) {
        if (node == null) {
            return "null";
        }
        String s = Base.nameOfNode(node);
        if ("aoeiu".indexOf(s.charAt(0)) != -1) {
            return "an " + s;
        }
        return "a " + s;
    }

    protected static boolean isWhiteSpaceChar(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    protected static void checkCompatibleOwnerDocuments(Node a, Node b) {
        Document da = a.getOwnerDocument();
        Document db = b.getOwnerDocument();
        if (da != null && db != null && da != db) {
            throw new DOMException(4, "Attempt to use a node in another document without importing it first");
        }
    }

    public abstract short getNodeType();

    public abstract String getNodeName();

    public abstract Node cloneNode(boolean var1);

    static {
        serializer.setOutputProperty("omit-xml-declaration", "yes");
    }
}

