/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.validator.ValidationContext;
import com.sap.engine.lib.schema.validator.identity.AbstractIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.FieldsStructure;
import com.sap.engine.lib.schema.validator.identity.KeyIdentityConstraintDefinitionValidator;

class KeyrefIdentityConstraintDefinitionValidator
extends AbstractIdentityConstraintDefinitionValidator {
    private KeyIdentityConstraintDefinitionValidator keyIdentityConstraintDefProcessor;

    KeyrefIdentityConstraintDefinitionValidator(IdentityConstraintDefinition identityconstraintDef, KeyIdentityConstraintDefinitionValidator keyIdentityConstraintDefProcessor, ValidationContext context) {
        super(identityconstraintDef, context);
        this.keyIdentityConstraintDefProcessor = keyIdentityConstraintDefProcessor;
    }

    public boolean validate() {
        int structuresCount = this.fieldsStructuresCollector.size();
        int i = 0;
        while (i < structuresCount) {
            FieldsStructure structure = (FieldsStructure)this.fieldsStructuresCollector.get(i);
            if (structure.isInitialized()) {
                if (!this.keyIdentityConstraintDefProcessor.contains(structure)) {
                    this.context.addError_Identity("combination of element information items " + structure.getRepresentation() + " must be identical to some of element information items combinations, represented by the referenced key of keyref identity constraint definition {" + this.identityConstrDef.getTargetNamespace() + "}:" + this.identityConstrDef.getName() + ".");
                    return false;
                }
            } else {
                this.context.addError_Identity("combination of element information items, represented by the keyref identity constraint definition {" + this.identityConstrDef.getTargetNamespace() + "}:" + this.identityConstrDef.getName() + ", must be present.");
                return false;
            }
            ++i;
        }
        return true;
    }
}

